/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.network.protocol.game;

import com.alaharranhonor.swem.forge.ModRef;
import com.alaharranhonor.swem.forge.container.SaddlebagAndBedrollContainer;
import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class SContainerPacket {
    private int action;
    private final boolean failed;

    public SContainerPacket(int action) {
        this.action = action;
        this.failed = false;
    }

    public SContainerPacket(boolean failed) {
        this.failed = failed;
    }

    public static SContainerPacket decode(ByteBuf buf) {
        try {
            int action = buf.readInt();
            return new SContainerPacket(action);
        }
        catch (IndexOutOfBoundsException e) {
            ModRef.LOGGER.error("SContainerPacket: Unexpected end of packet.\nMessage: " + ByteBufUtil.hexDump((ByteBuf)buf, (int)0, (int)buf.writerIndex()), (Throwable)e);
            return new SContainerPacket(true);
        }
    }

    public static void encode(SContainerPacket msg, FriendlyByteBuf buffer) {
        buffer.writeInt(msg.action);
    }

    public static void handle(SContainerPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            SWEMHorseEntityBase horse;
            ServerPlayer serverPlayer = ((NetworkEvent.Context)ctx.get()).getSender();
            Entity patt2510$temp = serverPlayer.m_20202_();
            if (patt2510$temp instanceof SWEMHorseEntityBase && (horse = (SWEMHorseEntityBase)patt2510$temp).getSaddleBag() != ItemStack.f_41583_ && msg.action == 0) {
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new MenuProvider(){

                    @NotNull
                    public Component m_5446_() {
                        return Component.m_237115_((String)"container.swem.bedroll");
                    }

                    @NotNull
                    public AbstractContainerMenu m_7208_(int p_createMenu_1_, Inventory p_createMenu_2_, Player p_createMenu_3_) {
                        return new SaddlebagAndBedrollContainer(p_createMenu_1_, p_createMenu_2_, horse.m_19879_());
                    }
                }, buffer -> {
                    buffer.writeInt(horse.m_19879_());
                    buffer.writeInt(horse.m_19879_());
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

