/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.network.protocol.game;

import com.alaharranhonor.swem.forge.ModRef;
import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class SHorseFriendPacket {
    private UUID playerUUID;
    private int entityID;
    private int action;
    private final boolean failed;

    public SHorseFriendPacket(UUID playerUUID, int entityID, int action) {
        this.playerUUID = playerUUID;
        this.entityID = entityID;
        this.action = action;
        this.failed = false;
    }

    public SHorseFriendPacket(boolean failed) {
        this.failed = failed;
    }

    public static SHorseFriendPacket decode(ByteBuf buf) {
        try {
            UUID playerUUID = ((FriendlyByteBuf)buf).m_130259_();
            int entityID = buf.readInt();
            int action = buf.readInt();
            return new SHorseFriendPacket(playerUUID, entityID, action);
        }
        catch (IndexOutOfBoundsException e) {
            ModRef.LOGGER.error("SHorseFriendPacket: Unexpected end of packet.\nMessage: " + ByteBufUtil.hexDump((ByteBuf)buf, (int)0, (int)buf.writerIndex()), (Throwable)e);
            return new SHorseFriendPacket(true);
        }
    }

    public static void encode(SHorseFriendPacket msg, FriendlyByteBuf buffer) {
        buffer.m_130077_(msg.playerUUID);
        buffer.writeInt(msg.entityID);
        buffer.writeInt(msg.action);
    }

    public static void handle(SHorseFriendPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            Entity entity = player.m_9236_().m_6815_(msg.entityID);
            if (!(entity instanceof SWEMHorseEntityBase)) {
                return;
            }
            SWEMHorseEntityBase horse = (SWEMHorseEntityBase)entity;
            switch (msg.action) {
                case 1: {
                    horse.addAllowedUUID(msg.playerUUID);
                    break;
                }
                case 2: {
                    horse.removeAllowedUUID(msg.playerUUID);
                    break;
                }
                case 3: {
                    horse.removeAllAllowedUUIDs();
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

