/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.network.protocol.game.jumps;

import com.alaharranhonor.swem.forge.ModRef;
import com.alaharranhonor.swem.forge.blocks.jumps.JumpLayer;
import com.alaharranhonor.swem.forge.blocks.jumps.StandardLayer;
import com.alaharranhonor.swem.forge.client.gui.screens.JumpScreen;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class SDataSendPacket {
    private BlockPos controllerPos;
    private int layerAmount;
    private Map<Integer, JumpLayer> layerTypes = new HashMap<Integer, JumpLayer>();
    private Map<Integer, Integer> layerColors = new HashMap<Integer, Integer>();
    private StandardLayer currentStandard;
    private final boolean failed;

    public SDataSendPacket(BlockPos controllerPos, int layerAmount, Map<Integer, JumpLayer> layerTypes, Map<Integer, Integer> layerColors, StandardLayer currentStandard) {
        this.controllerPos = controllerPos;
        this.layerAmount = layerAmount;
        this.layerTypes = layerTypes;
        this.layerColors = layerColors;
        this.currentStandard = currentStandard;
        this.failed = false;
    }

    public SDataSendPacket(boolean failed) {
        this.failed = failed;
    }

    public static SDataSendPacket decode(ByteBuf buf) {
        try {
            BlockPos controllerPos = ((FriendlyByteBuf)buf).m_130135_();
            int layerAmount = ((FriendlyByteBuf)buf).m_130242_();
            HashMap<Integer, JumpLayer> layers = new HashMap<Integer, JumpLayer>();
            HashMap<Integer, Integer> colors = new HashMap<Integer, Integer>();
            for (int i = 0; i < layerAmount; ++i) {
                layers.put(i + 1, JumpLayer.valueOf(((FriendlyByteBuf)buf).m_130136_(Short.MAX_VALUE)));
                colors.put(i + 1, ((FriendlyByteBuf)buf).m_130242_());
            }
            StandardLayer standard = StandardLayer.valueOf(((FriendlyByteBuf)buf).m_130136_(Short.MAX_VALUE));
            return new SDataSendPacket(controllerPos, layerAmount, layers, colors, standard);
        }
        catch (IndexOutOfBoundsException e) {
            ModRef.LOGGER.error("SDataSendPacket: Unexpected end of packet.\nMessage: " + ByteBufUtil.hexDump((ByteBuf)buf, (int)0, (int)buf.writerIndex()), (Throwable)e);
            return new SDataSendPacket(true);
        }
    }

    public static void encode(SDataSendPacket msg, FriendlyByteBuf buffer) {
        buffer.m_130064_(msg.controllerPos);
        buffer.m_130130_(msg.layerAmount);
        for (int i = 0; i < msg.layerAmount; ++i) {
            buffer.m_130070_(msg.layerTypes.get(i + 1).name());
            buffer.m_130130_(msg.layerColors.get(i + 1).intValue());
        }
        buffer.m_130070_(msg.currentStandard.name());
    }

    public static void handle(SDataSendPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (screen instanceof JumpScreen) {
                JumpScreen jumpScreen = (JumpScreen)screen;
                jumpScreen.updateData(msg.controllerPos, msg.layerAmount, msg.layerTypes, msg.layerColors, msg.currentStandard);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

