/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.network.protocol.game.jumps;

import com.alaharranhonor.swem.forge.network.protocol.Packet;
import com.alaharranhonor.swem.forge.network.protocol.ServerPacketHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundJumpsActionPacket
extends Packet {
    private final Action action;
    private final byte layerToEffect;

    public ServerboundJumpsActionPacket(Action action) {
        this(action, -1);
    }

    public ServerboundJumpsActionPacket(Action action, byte layerToEffect) {
        this.action = action;
        this.layerToEffect = layerToEffect;
    }

    public ServerboundJumpsActionPacket(FriendlyByteBuf reader) {
        super(reader);
        this.action = (Action)reader.m_130066_(Action.class);
        this.layerToEffect = reader.readByte();
    }

    @Override
    public void encode(FriendlyByteBuf writer) {
        writer.m_130068_((Enum)this.action);
        writer.writeByte((int)this.layerToEffect);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ServerPacketHandler.handleJumpsAction(this, (NetworkEvent.Context)ctx.get()));
        ctx.get().setPacketHandled(true);
    }

    public Action getAction() {
        return this.action;
    }

    public byte getLayerToEffect() {
        return this.layerToEffect;
    }

    public static enum Action {
        ADD_LAYER,
        REMOVE_LAYER,
        DESTROY,
        CHANGE_COLOR_FORWARD,
        CHANGE_COLOR_BACKWARDS,
        CHANGE_LAYER_FORWARDS,
        CHANGE_LAYER_BACKWARDS,
        CHANGE_STANDARD_FORWARDS,
        CHANGE_STANDARD_BACKWARDS;

    }
}

