/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.tack;

import com.alaharranhonor.swem.forge.client.model.ModelBoneType;
import com.alaharranhonor.swem.forge.community.RackType;
import com.alaharranhonor.swem.forge.community.TackType;
import com.alaharranhonor.swem.forge.community.content.tack.TackCost;
import com.alaharranhonor.swem.forge.community.content.tack.TackDisplayData;
import com.alaharranhonor.swem.forge.community.content.tack.type.TackTypeData;
import com.alaharranhonor.swem.forge.entities.horse.HorseModelType;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public record TackItemDefinition(TackType type, @Nullable TackCost cost, @Nullable TackDisplayData display, TackTypeData data, Map<RackType, ResourceLocation> rackTextures, Table<HorseModelType, ModelBoneType, ResourceLocation> horseTextures) {
    public static Builder builder(TackType tackType) {
        return new Builder(tackType);
    }

    public static class Builder {
        private final TackType type;
        private Map<RackType, ResourceLocation> rackTextures = new HashMap<RackType, ResourceLocation>();
        private Table<HorseModelType, ModelBoneType, ResourceLocation> horseTextures = HashBasedTable.create();
        private TackDisplayData display;
        private TackCost cost;
        private TackTypeData data;

        Builder(TackType type) {
            this.type = type;
            this.data = type.defaultData();
        }

        public Builder withData(TackTypeData data) {
            this.data = data;
            return this;
        }

        public Builder withCost(TackCost cost) {
            this.cost = cost;
            return this;
        }

        public Builder withDisplay(TackDisplayData display) {
            this.display = display;
            return this;
        }

        public Builder rackTexture(RackType type, ResourceLocation texture) {
            this.rackTextures.put(type, texture);
            return this;
        }

        public Builder horseTexture(HorseModelType type, ModelBoneType bone, ResourceLocation texture) {
            this.horseTextures.put((Object)type, (Object)bone, (Object)texture);
            return this;
        }

        public TackItemDefinition build() {
            return new TackItemDefinition(this.type, this.cost, this.display, this.data, this.rackTextures, this.horseTextures);
        }
    }
}

