/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.tileentity;

import com.alaharranhonor.swem.forge.ModRef;
import com.alaharranhonor.swem.forge.blocks.jumps.JumpBlock;
import com.alaharranhonor.swem.forge.blocks.jumps.JumpControllerBlock;
import com.alaharranhonor.swem.forge.blocks.jumps.JumpLayer;
import com.alaharranhonor.swem.forge.blocks.jumps.JumpStandardBlock;
import com.alaharranhonor.swem.forge.blocks.jumps.StandardLayer;
import com.alaharranhonor.swem.forge.registry.BlockEntitySetup;
import com.alaharranhonor.swem.forge.tileentity.JumpPasserBE;
import com.alaharranhonor.swem.forge.util.SWEMUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class JumpBE
extends BlockEntity {
    public int layerAmount;
    public Map<Integer, JumpLayer> layerTypes = new HashMap<Integer, JumpLayer>();
    public Map<Integer, Integer> layerColors = new HashMap<Integer, Integer>();
    public StandardLayer currentStandard;
    private Map<Integer, ArrayList<BlockPos>> layerPositions = new HashMap<Integer, ArrayList<BlockPos>>();

    public JumpBE(BlockPos p_155630_, BlockState p_155631_) {
        super((BlockEntityType)BlockEntitySetup.JUMP_BLOCK_ENTITY.get(), p_155630_, p_155631_);
    }

    public int getLayerAmount() {
        return this.layerAmount;
    }

    public void setLayerAmount(int layerAmount) {
        this.layerAmount = layerAmount;
    }

    public void assignJumpBlocks(Map<Integer, ArrayList<BlockPos>> blocks) {
        this.layerPositions = blocks;
    }

    public void placeStandards(int layerNumber, StandardLayer standard) {
        this.currentStandard = standard;
        if (standard != StandardLayer.NONE) {
            this.f_58857_.m_7731_(this.layerPositions.get(layerNumber).get(0), layerNumber == this.layerAmount ? (BlockState)standard.getTopState().m_61124_((Property)JumpStandardBlock.f_54117_, (Comparable)((Direction)this.m_58900_().m_61143_((Property)JumpStandardBlock.f_54117_))) : (layerNumber == 1 ? (BlockState)standard.getBottomState().m_61124_((Property)JumpStandardBlock.f_54117_, (Comparable)((Direction)this.m_58900_().m_61143_((Property)JumpStandardBlock.f_54117_)).m_122427_().m_122427_()) : (BlockState)standard.getMiddleState().m_61124_((Property)JumpStandardBlock.f_54117_, (Comparable)((Direction)this.m_58900_().m_61143_((Property)JumpStandardBlock.f_54117_)))), 3);
            this.f_58857_.m_7731_(this.layerPositions.get(layerNumber).get(6), layerNumber == this.layerAmount ? (BlockState)standard.getTopState().m_61124_((Property)JumpStandardBlock.f_54117_, (Comparable)((Direction)this.m_58900_().m_61143_((Property)JumpStandardBlock.f_54117_)).m_122427_().m_122427_()) : (layerNumber == 1 ? (BlockState)standard.getBottomState().m_61124_((Property)JumpStandardBlock.f_54117_, (Comparable)((Direction)this.m_58900_().m_61143_((Property)JumpStandardBlock.f_54117_)).m_122427_().m_122427_()) : (BlockState)standard.getMiddleState().m_61124_((Property)JumpStandardBlock.f_54117_, (Comparable)((Direction)this.m_58900_().m_61143_((Property)JumpStandardBlock.f_54117_)).m_122427_().m_122427_())), 3);
        } else {
            this.f_58857_.m_7731_(this.layerPositions.get(layerNumber).get(0), standard.getBottomState(), 3);
            this.f_58857_.m_7731_(this.layerPositions.get(layerNumber).get(6), standard.getBottomState(), 3);
        }
        JumpBE newTe = this;
        newTe.m_6339_();
        this.f_58857_.addFreshBlockEntities(Collections.singletonList(newTe));
    }

    public void initStandards(StandardLayer standard) {
        this.currentStandard = standard;
        for (int i = 1; i <= this.layerAmount; ++i) {
            this.f_58857_.m_7731_(this.layerPositions.get(i).get(0), i == 1 ? (BlockState)standard.getBottomState().m_61124_((Property)JumpStandardBlock.f_54117_, (Comparable)((Direction)this.m_58900_().m_61143_((Property)JumpControllerBlock.f_54117_))) : (i == this.layerAmount ? (BlockState)standard.getTopState().m_61124_((Property)JumpStandardBlock.f_54117_, (Comparable)((Direction)this.m_58900_().m_61143_((Property)JumpControllerBlock.f_54117_))) : (BlockState)standard.getMiddleState().m_61124_((Property)JumpStandardBlock.f_54117_, (Comparable)((Direction)this.m_58900_().m_61143_((Property)JumpControllerBlock.f_54117_)))), 3);
            ((JumpPasserBE)this.f_58857_.m_7702_(this.layerPositions.get(i).get(0))).setControllerPos(this.m_58899_());
            this.f_58857_.m_7731_(this.layerPositions.get(i).get(6), i == 1 ? (BlockState)standard.getBottomState().m_61124_((Property)JumpStandardBlock.f_54117_, (Comparable)((Direction)this.m_58900_().m_61143_((Property)JumpControllerBlock.f_54117_)).m_122427_().m_122427_()) : (i == this.layerAmount ? (BlockState)standard.getTopState().m_61124_((Property)JumpStandardBlock.f_54117_, (Comparable)((Direction)this.m_58900_().m_61143_((Property)JumpControllerBlock.f_54117_)).m_122427_().m_122427_()) : (BlockState)standard.getMiddleState().m_61124_((Property)JumpStandardBlock.f_54117_, (Comparable)((Direction)this.m_58900_().m_61143_((Property)JumpControllerBlock.f_54117_)).m_122427_().m_122427_())), 3);
            ((JumpPasserBE)this.f_58857_.m_7702_(this.layerPositions.get(i).get(6))).setControllerPos(this.m_58899_());
        }
    }

    public void placeLayer(int number, JumpLayer layer) {
        this.layerTypes.put(number, layer);
        if (!this.layerColors.containsKey(number)) {
            this.resetColor(number);
        }
        if (this.f_58857_ != null) {
            for (int i = 1; i < 6; ++i) {
                BlockState placeState = i % 3 == 0 ? (BlockState)layer.getMiddleState(this.layerColors.get(number)).m_61124_((Property)JumpBlock.f_54117_, (Comparable)((Direction)this.m_58900_().m_61143_((Property)JumpStandardBlock.f_54117_))) : (i % 2 == 0 ? (BlockState)layer.getBetweenState(this.layerColors.get(number)).m_61124_((Property)JumpBlock.f_54117_, (Comparable)(i == 2 ? (Direction)this.m_58900_().m_61143_((Property)JumpStandardBlock.f_54117_) : ((Direction)this.m_58900_().m_61143_((Property)JumpStandardBlock.f_54117_)).m_122424_())) : (BlockState)layer.getEndState(this.layerColors.get(number)).m_61124_((Property)JumpBlock.f_54117_, (Comparable)(i == 1 ? (Direction)this.m_58900_().m_61143_((Property)JumpStandardBlock.f_54117_) : ((Direction)this.m_58900_().m_61143_((Property)JumpStandardBlock.f_54117_)).m_122424_())));
                this.f_58857_.m_7731_(this.layerPositions.get(number).get(i), placeState, 3);
                JumpPasserBE passer = (JumpPasserBE)this.f_58857_.m_7702_(this.layerPositions.get(number).get(i));
                if (passer == null) continue;
                passer.setControllerPos(this.m_58899_());
                passer.m_6596_();
            }
        }
    }

    public void changeLayerForward(int layerNumber) {
        if (!this.isLayerNumberWithinBounds(layerNumber)) {
            return;
        }
        List<JumpLayer> applicableLayers = this.getApplicableLayers(layerNumber);
        if (applicableLayers.contains((Object)this.layerTypes.get(layerNumber))) {
            int indexToPick = applicableLayers.indexOf((Object)this.layerTypes.get(layerNumber)) + 1;
            if (indexToPick >= applicableLayers.size()) {
                indexToPick = 0;
            }
            this.placeLayer(layerNumber, applicableLayers.get(indexToPick));
        } else {
            this.placeLayer(layerNumber, applicableLayers.get(0));
        }
    }

    public void changeLayerBackwards(int layerNumber) {
        if (!this.isLayerNumberWithinBounds(layerNumber)) {
            return;
        }
        List<JumpLayer> applicableLayers = this.getApplicableLayers(layerNumber);
        if (applicableLayers.contains((Object)this.layerTypes.get(layerNumber))) {
            int indexToPick = applicableLayers.indexOf((Object)this.layerTypes.get(layerNumber)) - 1;
            if (indexToPick < 0) {
                indexToPick = applicableLayers.size() - 1;
            }
            this.placeLayer(layerNumber, applicableLayers.get(indexToPick));
        } else {
            this.placeLayer(layerNumber, applicableLayers.get(0));
        }
    }

    public void changeStandardForward() {
        int enumId = this.currentStandard.ordinal();
        if (++enumId > StandardLayer.values().length - 1) {
            enumId = 0;
        }
        this.initStandards(StandardLayer.values()[enumId]);
    }

    public void changeStandardBackwards() {
        int enumId = this.currentStandard.ordinal();
        if (--enumId < 0) {
            enumId = StandardLayer.values().length - 1;
        }
        this.initStandards(StandardLayer.values()[enumId]);
    }

    public void incrementColorVariant(int layerNumber) {
        int nextColor;
        if (!this.isLayerNumberWithinBounds(layerNumber)) {
            return;
        }
        if (!this.layerColors.containsKey(layerNumber)) {
            this.layerColors.put(layerNumber, 0);
        }
        if ((nextColor = this.layerColors.get(layerNumber) + 1) > SWEMUtil.COLOURS.length - 1) {
            nextColor = 0;
        }
        this.layerColors.put(layerNumber, nextColor);
        this.placeLayer(layerNumber, this.getLayer(layerNumber));
    }

    private boolean isLayerNumberWithinBounds(int layerNumber) {
        if (layerNumber <= 0 || layerNumber >= 6) {
            ModRef.LOGGER.error("Something went wrong in the jump controller! Layer number: {} was trying to get modified", (Object)layerNumber);
            return false;
        }
        return true;
    }

    public void decrementColorVariant(int layerNumber) {
        int prevColor;
        if (!this.isLayerNumberWithinBounds(layerNumber)) {
            return;
        }
        if (!this.layerColors.containsKey(layerNumber)) {
            this.layerColors.put(layerNumber, 0);
        }
        if ((prevColor = this.layerColors.get(layerNumber) - 1) < 0) {
            prevColor = SWEMUtil.COLOURS.length - 1;
        }
        this.layerColors.put(layerNumber, prevColor);
        this.placeLayer(layerNumber, this.getLayer(layerNumber));
    }

    private void resetColor(int layerNumber) {
        this.layerColors.put(layerNumber, SWEMUtil.COLOURS[0].m_41060_());
    }

    public DyeColor getColorVariant(int layerNumber) {
        return SWEMUtil.COLOURS[this.layerColors.getOrDefault(layerNumber, SWEMUtil.COLOURS[0].m_41060_())];
    }

    public JumpLayer getLayer(int layerNumber) {
        return this.layerTypes.get(layerNumber);
    }

    public StandardLayer getCurrentStandard() {
        return this.currentStandard;
    }

    public void setCurrentStandard(StandardLayer standard) {
        this.currentStandard = standard;
    }

    public List<JumpLayer> getApplicableLayers(int layerNumber) {
        ArrayList<JumpLayer> layers = new ArrayList<JumpLayer>();
        block8: for (JumpLayer layer : JumpLayer.values()) {
            if (layer == JumpLayer.AIR) continue;
            if (layer == JumpLayer.NONE) {
                layers.add(layer);
                continue;
            }
            if ((layer.getMinHeight() > this.getLayerAmount() || layerNumber < layer.getMinLayer() || layerNumber > layer.getMaxLayer()) && (layerNumber != this.getLayerAmount() || layer.getMaxLayer() != layerNumber + 1 || layerNumber + 1 != layer.getMinLayer())) continue;
            switch (layer) {
                case STAIR_DROP: 
                case CAVALETTI: {
                    if (this.getCurrentStandard() != StandardLayer.NONE) continue block8;
                    if (!(this.layerTypes.containsKey(2) || this.layerTypes.containsKey(3) || this.layerTypes.containsKey(4) || this.layerTypes.containsKey(5))) {
                        layers.add(layer);
                        continue block8;
                    }
                }
                case LOG: 
                case POLE_ON_BOX_SMALL: 
                case POLE_ON_BOX_LARGE: 
                case HEDGE: {
                    if (!(this.layerTypes.containsKey(2) || this.layerTypes.containsKey(3) || this.layerTypes.containsKey(4) || this.layerTypes.containsKey(5))) {
                        layers.add(layer);
                        continue block8;
                    }
                }
                case WALL: 
                case WALL_MINI: {
                    boolean shouldAdd = true;
                    for (int i = 1; i < layerNumber; ++i) {
                        if (this.layerTypes.get(i) == JumpLayer.WALL) continue;
                        shouldAdd = false;
                        break;
                    }
                    if (!shouldAdd) continue block8;
                    layers.add(layer);
                    continue block8;
                }
                case BRUSH_BOX: 
                case FLOWER_BOX: 
                case COOP: 
                case ROLL_TOP: 
                case GROUND_POLE: {
                    if (this.layerTypes.containsKey(2) && !JumpLayer.testForRail(this.layerTypes.get(2)) && !JumpLayer.testForNone(this.layerTypes.get(2)) || this.layerTypes.containsKey(3) && !JumpLayer.testForRail(this.layerTypes.get(3)) && !JumpLayer.testForNone(this.layerTypes.get(2)) || this.layerTypes.containsKey(4) && !JumpLayer.testForRail(this.layerTypes.get(4)) && !JumpLayer.testForNone(this.layerTypes.get(2)) || this.layerTypes.containsKey(5) && !JumpLayer.testForRail(this.layerTypes.get(5)) && !JumpLayer.testForNone(this.layerTypes.get(2))) continue block8;
                    layers.add(layer);
                    continue block8;
                }
                case RAIL: 
                case PLANK: 
                case PLANK_FANCY: {
                    layers.add(layer);
                    continue block8;
                }
                case PANEL_WAVE: 
                case PANEL_ARROW: 
                case PANEL_STRIPE: {
                    if (!this.layerTypes.containsKey(layerNumber + 1) || !JumpLayer.testForRail(this.layerTypes.get(layerNumber + 1))) continue block8;
                    layers.add(layer);
                    continue block8;
                }
            }
        }
        return layers;
    }

    public void deleteLayer() {
        if (this.layerAmount <= 1) {
            return;
        }
        int layerToDelete = this.layerAmount;
        for (int i = 0; i < 7; ++i) {
            this.f_58857_.m_7731_(this.layerPositions.get(layerToDelete).get(i), Blocks.f_50016_.m_49966_(), 3);
        }
        this.layerTypes.remove(layerToDelete);
        this.layerPositions.remove(layerToDelete);
        this.layerColors.remove(layerToDelete);
        --this.layerAmount;
        if (this.layerAmount > 1) {
            this.placeStandards(this.layerAmount, this.currentStandard);
        }
    }

    public void addLayer() {
        if (this.layerAmount >= 5) {
            return;
        }
        int layerToAdd = this.layerAmount + 1;
        this.layerTypes.put(layerToAdd, JumpLayer.NONE);
        ArrayList<BlockPos> positions = this.layerPositions.getOrDefault(layerToAdd, new ArrayList());
        for (int i = 0; i < 7; ++i) {
            Direction facing;
            BlockPos newPos = this.layerPositions.get(layerToAdd - 1).get(i).m_7918_(0, 1, 0);
            positions.add(newPos);
            if (i != 0 && i != 6) continue;
            Direction direction = facing = i == 0 ? (Direction)this.m_58900_().m_61143_((Property)JumpControllerBlock.f_54117_) : ((Direction)this.m_58900_().m_61143_((Property)JumpControllerBlock.f_54117_)).m_122427_().m_122427_();
            if (layerToAdd - 1 != 1) {
                this.f_58857_.m_7731_(this.layerPositions.get(layerToAdd - 1).get(i), (BlockState)this.currentStandard.getMiddleState().m_61124_((Property)JumpStandardBlock.f_54117_, (Comparable)facing), 3);
                ((JumpPasserBE)this.f_58857_.m_7702_(this.layerPositions.get(layerToAdd - 1).get(i))).setControllerPos(this.m_58899_());
            }
            this.f_58857_.m_7731_(newPos, (BlockState)this.currentStandard.getTopState().m_61124_((Property)JumpStandardBlock.f_54117_, (Comparable)facing), 3);
            ((JumpPasserBE)this.f_58857_.m_7702_(newPos)).setControllerPos(this.m_58899_());
        }
        this.layerPositions.put(layerToAdd, positions);
        this.placeLayer(layerToAdd, JumpLayer.NONE);
        ++this.layerAmount;
    }

    public void destroyJump() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_7731_(this.m_58899_(), Blocks.f_50016_.m_49966_(), 3);
            for (ArrayList<BlockPos> positions : this.layerPositions.values()) {
                for (BlockPos pos : positions) {
                    this.f_58857_.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                }
            }
            this.m_7651_();
        }
    }

    public void m_183515_(CompoundTag compound) {
        CompoundTag positions = new CompoundTag();
        this.layerPositions.forEach((layerNumber, blockPos) -> {
            CompoundTag layer = new CompoundTag();
            for (int i = 0; i < 7; ++i) {
                BlockPos pos = (BlockPos)blockPos.get(i);
                layer.m_128385_(Integer.toString(i), new int[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()});
            }
            positions.m_128365_(Integer.toString(layerNumber), (Tag)layer);
        });
        compound.m_128365_("layerPositions", (Tag)positions);
        CompoundTag layerTypes = new CompoundTag();
        this.layerTypes.forEach((layerNumber, jumpType) -> layerTypes.m_128359_(Integer.toString(layerNumber), jumpType.name()));
        compound.m_128365_("layerTypes", (Tag)layerTypes);
        CompoundTag layerColors = new CompoundTag();
        this.layerColors.forEach((layerNumber, colorId) -> layerColors.m_128405_(Integer.toString(layerNumber), colorId.intValue()));
        compound.m_128365_("layerColors", (Tag)layerColors);
        compound.m_128405_("layerAmount", this.layerAmount);
        compound.m_128359_("standard", this.currentStandard != null ? this.currentStandard.name() : StandardLayer.SCHOOLING.name());
        super.m_183515_(compound);
    }

    public void m_142466_(CompoundTag nbt) {
        this.setLayerAmount(nbt.m_128451_("layerAmount"));
        if (nbt.m_128441_("layerPositions")) {
            HashMap<Integer, ArrayList<BlockPos>> layerPos = new HashMap<Integer, ArrayList<BlockPos>>();
            CompoundTag positions = nbt.m_128469_("layerPositions");
            for (int i = 1; i <= this.layerAmount; ++i) {
                CompoundTag layer = positions.m_128469_(Integer.toString(i));
                ArrayList<BlockPos> blockPositions = new ArrayList<BlockPos>();
                for (int j = 0; j < 7; ++j) {
                    int[] posCords = layer.m_128465_(Integer.toString(j));
                    blockPositions.add(new BlockPos(posCords[0], posCords[1], posCords[2]));
                }
                layerPos.put(i, blockPositions);
            }
            this.assignJumpBlocks(layerPos);
        }
        if (nbt.m_128441_("layerColors")) {
            CompoundTag layerColors = nbt.m_128469_("layerColors");
            for (int i = 1; i <= this.layerAmount; ++i) {
                this.layerColors.put(i, layerColors.m_128451_(Integer.toString(i)));
            }
        }
        if (nbt.m_128441_("layerTypes")) {
            CompoundTag layerTypes = nbt.m_128469_("layerTypes");
            for (int i = 1; i <= this.layerAmount; ++i) {
                String jumpName = layerTypes.m_128461_(Integer.toString(i));
                if (jumpName.isEmpty()) continue;
                this.placeLayer(i, JumpLayer.valueOf(jumpName));
            }
        }
        this.currentStandard = nbt.m_128441_("standard") ? StandardLayer.valueOf(nbt.m_128461_("standard")) : StandardLayer.SCHOOLING;
        super.m_142466_(nbt);
    }
}

