/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.tileentity;

import com.alaharranhonor.swem.forge.blocks.TackBoxBlock;
import com.alaharranhonor.swem.forge.container.TackBoxContainer;
import com.alaharranhonor.swem.forge.registry.BlockEntitySetup;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class TackBoxBE
extends RandomizableContainerBlockEntity
implements MenuProvider,
GeoBlockEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int numPlayersUsing;
    private NonNullList<ItemStack> tackContents = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
    private final IItemHandlerModifiable items = this.createHandler();
    private final LazyOptional<IItemHandlerModifiable> itemHandler = LazyOptional.of(() -> this.items);
    private UUID horseId;
    private Component horseName;

    public TackBoxBE(BlockPos p_155630_, BlockState p_155631_) {
        super((BlockEntityType)BlockEntitySetup.TACK_BOX_BLOCK_ENTITY.get(), p_155630_, p_155631_);
    }

    public boolean isBound() {
        return this.horseId != null;
    }

    public void setHorseData(UUID id, Component name) {
        this.horseId = id;
        this.horseName = name;
        this.m_6596_();
    }

    public UUID getHorseId() {
        return this.horseId;
    }

    public Component getHorseName() {
        return this.horseName;
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.tackContents);
        if (this.horseId != null) {
            tag.m_128362_("HorseId", this.horseId);
        }
        if (this.horseName != null) {
            tag.m_128359_("HorseName", Component.Serializer.m_130703_((Component)this.horseName));
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.tackContents = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.tackContents);
        if (tag.m_128441_("HorseId")) {
            this.horseId = tag.m_128342_("HorseId");
        }
        if (tag.m_128441_("HorseName")) {
            this.horseName = Component.Serializer.m_130701_((String)tag.m_128461_("HorseName"));
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.swem.tack_box");
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.swem.tack_box");
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory player) {
        return new TackBoxContainer(id, player, this);
    }

    public static int getPlayersUsing(BlockGetter reader, BlockPos pos) {
        BlockEntity tileEntity;
        BlockState state = reader.m_8055_(pos);
        if (state.m_155947_() && (tileEntity = reader.m_7702_(pos)) instanceof TackBoxBE) {
            return ((TackBoxBE)tileEntity).numPlayersUsing;
        }
        return 0;
    }

    private void playSound(SoundEvent event) {
        double dx = (double)this.m_58899_().m_123341_() + 0.5;
        double dy = (double)this.m_58899_().m_123342_() + 0.5;
        double dz = (double)this.m_58899_().m_123343_() + 0.5;
        this.f_58857_.m_6263_(null, dx, dy, dz, event, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    public boolean m_7531_(int id, int data) {
        if (id == 1) {
            this.numPlayersUsing = data;
            return true;
        }
        return super.m_7531_(id, data);
    }

    public void m_5856_(Player player) {
        if (!player.m_5833_()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            this.onOpenOrClose();
        }
    }

    public void m_5785_(Player player) {
        if (!player.m_5833_()) {
            --this.numPlayersUsing;
            this.onOpenOrClose();
        }
    }

    protected void onOpenOrClose() {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof TackBoxBlock) {
            this.f_58857_.m_7696_(this.m_58899_(), block, 1, this.numPlayersUsing);
            this.f_58857_.m_46672_(this.m_58899_(), block);
        }
    }

    @javax.annotation.Nullable
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @javax.annotation.Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    private IItemHandlerModifiable createHandler() {
        return new InvWrapper((Container)this);
    }

    public NonNullList<ItemStack> m_7086_() {
        return this.tackContents;
    }

    public void m_6520_(NonNullList<ItemStack> itemsIn) {
        this.tackContents = itemsIn;
    }

    public static void swapContents(TackBoxBE te, TackBoxBE otherTe) {
        NonNullList<ItemStack> list = te.m_7086_();
        te.m_6520_(otherTe.m_7086_());
        otherTe.m_6520_(list);
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.itemHandler != null) {
            this.itemHandler.invalidate();
        }
    }

    public int m_6643_() {
        return 31;
    }

    public <E extends GeoAnimatable> PlayState predicate(AnimationState<E> event) {
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

