/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.util;

import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import com.alaharranhonor.swem.forge.keys.Keys;
import com.alaharranhonor.swem.forge.util.PermissionNodes;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class HorseUtil {
    public static SWEMHorseEntityBase getRidingOrFilmingHorse(ServerLevel level, Player player, boolean targetFilming) {
        Entity entity = player.m_20202_();
        if (entity instanceof SWEMHorseEntityBase) {
            SWEMHorseEntityBase horse = (SWEMHorseEntityBase)entity;
            return horse;
        }
        if (targetFilming && Keys.hasPermission(player, PermissionNodes.CAN_FILM) && player.getPersistentData().m_128403_("FilmingHorse") && (entity = level.m_8791_(player.getPersistentData().m_128342_("FilmingHorse"))) instanceof SWEMHorseEntityBase) {
            SWEMHorseEntityBase horse = (SWEMHorseEntityBase)entity;
            return horse;
        }
        return null;
    }

    public static boolean isOwner(Entity entity, Player player) {
        if (entity instanceof SWEMHorseEntityBase) {
            SWEMHorseEntityBase horse = (SWEMHorseEntityBase)entity;
            return player.m_20148_().equals(horse.m_21805_());
        }
        return false;
    }

    public static InteractionResult bindLead(Player pPlayer, Level pLevel, BlockPos pPos, BlockState state) {
        LeashFenceKnotEntity leashknotentity = null;
        boolean flag = false;
        double range = 7.0;
        int x = pPos.m_123341_();
        int y = pPos.m_123342_();
        int z = pPos.m_123343_();
        AABB bounds = new AABB((double)x - range, (double)y - range, (double)z - range, (double)x + range, (double)y + range, (double)z + range);
        for (Mob mobentity : pLevel.m_45976_(Mob.class, bounds)) {
            if (mobentity.m_21524_() != pPlayer) continue;
            if (leashknotentity == null) {
                leashknotentity = LeashFenceKnotEntity.m_31844_((Level)pLevel, (BlockPos)pPos);
                leashknotentity.m_6842_(true);
            }
            mobentity.m_21463_((Entity)leashknotentity, true);
            flag = true;
        }
        return flag ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    public static InteractionResult canBindLead(Player pPlayer, Level pLevel, BlockPos pPos, BlockState state) {
        double range = 7.0;
        int x = pPos.m_123341_();
        int y = pPos.m_123342_();
        int z = pPos.m_123343_();
        AABB bounds = new AABB((double)x - range, (double)y - range, (double)z - range, (double)x + range, (double)y + range, (double)z + range);
        for (Mob mobentity : pLevel.m_45976_(Mob.class, bounds)) {
            if (mobentity.m_21524_() != pPlayer) continue;
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

