/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.util;

import com.alaharranhonor.swem.forge.util.DualDyeableItem;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;

public class SWEMUtil {
    public static final CauldronInteraction DUAL_DYED_ITEM = (state, level, pos, player, hand, stack) -> {
        Item item = stack.m_41720_();
        if (!(item instanceof DualDyeableItem)) {
            return InteractionResult.PASS;
        }
        DualDyeableItem dyeable = (DualDyeableItem)item;
        if (!dyeable.hasCustomPrimary(stack) && !dyeable.hasCustomSecondary(stack)) {
            return InteractionResult.PASS;
        }
        if (!level.f_46443_) {
            dyeable.clearColor(stack);
            player.m_36220_(Stats.f_12945_);
            LayeredCauldronBlock.m_153559_((BlockState)state, (Level)level, (BlockPos)pos);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    };
    public static DyeColor[] COLOURS = new DyeColor[]{DyeColor.WHITE, DyeColor.LIGHT_BLUE, DyeColor.CYAN, DyeColor.BLUE, DyeColor.PINK, DyeColor.MAGENTA, DyeColor.PURPLE, DyeColor.YELLOW, DyeColor.ORANGE, DyeColor.RED, DyeColor.LIME, DyeColor.GREEN, DyeColor.LIGHT_GRAY, DyeColor.GRAY, DyeColor.BLACK, DyeColor.BROWN};
    private static final DyeColor[] BY_INDEX = (DyeColor[])Arrays.stream(COLOURS).toArray(DyeColor[]::new);

    public static void damageOrShrink(ItemStack stack, Player player) {
        if (stack.m_41720_() instanceof BucketItem) {
            BucketItem cfr_ignored_0 = (BucketItem)stack.m_41720_();
            player.m_21008_(player.m_7655_(), BucketItem.m_40699_((ItemStack)stack, (Player)player));
        }
        if (stack.m_41763_()) {
            stack.m_41622_(1, (LivingEntity)player, playerEntity -> playerEntity.m_21190_(playerEntity.m_7655_()));
        } else {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            player.m_21008_(player.m_7655_(), stack);
        }
    }

    public static boolean hasTankControls(Entity pEntity) {
        return pEntity.getPersistentData().m_128471_("swem:tank_controls");
    }

    public static boolean isInDistanceOfBlock(Level level, BlockPos pos, int distance, Block blockToCheck) {
        for (int x = -distance; x <= distance; ++x) {
            for (int z = -distance; z <= distance; ++z) {
                for (int y = -distance; y <= distance; ++y) {
                    if (level.m_8055_(pos.m_7918_(x, y, z)).m_60734_() != blockToCheck) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static String checkTextOverflow(String text, int maxLimit) {
        if (text.length() > maxLimit - 2) {
            return text.substring(0, maxLimit - 2) + "...";
        }
        return text;
    }

    public static DyeColor logicalByIndex(int pColorId) {
        if (pColorId < 0 || pColorId >= BY_INDEX.length) {
            pColorId = 0;
        }
        return BY_INDEX[pColorId];
    }

    public static double getJumpBlocksFromInternalJump(double internal) {
        return Math.pow(internal, 1.7) * 5.293;
    }

    public static double getInternalJumpFromBlocks(double blocks) {
        return Math.pow(blocks / 5.293, 0.5882352941176471);
    }

    public static double getBlocksPerSecondFromInternalSpeed(double internal) {
        return internal * 43.17;
    }

    public static double getInternalSpeedFromBlocksPerSecond(double blocksPerSecond) {
        return blocksPerSecond / 43.17;
    }
}

