/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.entity;

import com.github.yimeng261.maidspell.entity.MaidSpellEntities;
import com.github.yimeng261.maidspell.sound.MaidSpellSounds;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class WindSeekingBellEntity
extends Entity {
    private static final EntityDataAccessor<ItemStack> DATA_ITEM_STACK = SynchedEntityData.m_135353_(WindSeekingBellEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private double targetX;
    private double targetY;
    private double targetZ;
    private int life;
    private boolean surviveAfterDeath;
    private double aX;
    private double aY;
    private double aZ;
    private Player player;
    private UUID playerUUID;

    public WindSeekingBellEntity(EntityType<? extends WindSeekingBellEntity> entityType, Level level) {
        super(entityType, level);
    }

    public WindSeekingBellEntity(Level level, Player player) {
        this((EntityType<? extends WindSeekingBellEntity>)((EntityType)MaidSpellEntities.WIND_SEEKING_BELL.get()), level);
        this.player = player;
        this.playerUUID = player.m_20148_();
        this.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
    }

    public void setItem(ItemStack itemStack) {
        this.m_20088_().m_135381_(DATA_ITEM_STACK, (Object)itemStack.m_41777_());
    }

    private ItemStack getItemRaw() {
        return (ItemStack)this.m_20088_().m_135370_(DATA_ITEM_STACK);
    }

    public ItemStack getItem() {
        ItemStack itemStack = this.getItemRaw();
        return itemStack.m_41619_() ? ItemStack.f_41583_ : itemStack;
    }

    private Player getPlayer() {
        Level level;
        if (this.player != null && this.player.m_6084_()) {
            return this.player;
        }
        if (this.playerUUID != null && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.player = serverLevel.m_46003_(this.playerUUID);
            return this.player;
        }
        return null;
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(DATA_ITEM_STACK, (Object)ItemStack.f_41583_);
    }

    public void signalTo(BlockPos targetPos) {
        double d3;
        this.aX = (double)targetPos.m_123341_() + 0.5;
        this.aY = targetPos.m_123342_();
        this.aZ = (double)targetPos.m_123343_() + 0.5;
        double d0 = targetPos.m_123341_();
        int i = targetPos.m_123342_();
        double d1 = targetPos.m_123343_();
        double d2 = d0 - this.m_20185_();
        double d4 = Math.sqrt(d2 * d2 + (d3 = d1 - this.m_20189_()) * d3);
        if (d4 > 12.0) {
            this.targetX = this.m_20185_() + d2 / d4 * 12.0;
            this.targetZ = this.m_20189_() + d3 / d4 * 12.0;
            this.targetY = this.m_20186_() + 20.0;
        } else {
            this.targetX = d0;
            this.targetY = i;
            this.targetZ = d1;
        }
        this.life = 0;
        this.surviveAfterDeath = true;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            double dz;
            double dx = this.targetX - this.m_20185_();
            double distance = Math.sqrt(dx * dx + (dz = this.targetZ - this.m_20189_()) * dz);
            if (distance < 1.0) {
                this.playBreakSound();
                this.m_146870_();
                return;
            }
            Vec3 vec3 = this.m_20184_();
            double d0 = this.m_20185_() + vec3.f_82479_;
            double d2 = this.m_20189_() + vec3.f_82481_;
            double d3 = vec3.m_165924_();
            this.m_146926_(WindSeekingBellEntity.lerpRotation(this.f_19860_, (float)(Mth.m_14136_((double)vec3.f_82480_, (double)d3) * 57.2957763671875)));
            this.m_146922_(WindSeekingBellEntity.lerpRotation(this.f_19859_, (float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875)));
            double d4 = this.targetX - d0;
            double d5 = this.targetZ - d2;
            float f = (float)Math.sqrt(d4 * d4 + d5 * d5);
            float f1 = (float)Mth.m_14136_((double)d5, (double)d4);
            double d6 = Mth.m_14139_((double)0.0025, (double)d3, (double)f);
            double d7 = vec3.f_82480_;
            if (f < 1.0f) {
                d6 *= 0.8;
                d7 *= 0.8;
            }
            int j = this.m_20186_() < this.targetY ? 1 : -1;
            vec3 = new Vec3(Math.cos(f1) * d6, d7 + ((double)j - d7) * (double)0.015f, Math.sin(f1) * d6);
            this.m_20256_(vec3);
            HitResult hitResult = ProjectileUtil.m_278158_((Entity)this, this::canHitEntity);
            ++this.life;
            if (this.life > 80 || hitResult.m_6662_() != HitResult.Type.MISS) {
                this.playBreakSound();
                this.m_146870_();
            }
        } else {
            this.spawnCherryParticles();
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
    }

    private static float lerpRotation(float p_37274_, float p_37275_) {
        while (p_37275_ - p_37274_ < -180.0f) {
            p_37274_ -= 360.0f;
        }
        while (p_37275_ - p_37274_ >= 180.0f) {
            p_37274_ += 360.0f;
        }
        return Mth.m_14179_((float)0.2f, (float)p_37274_, (float)p_37275_);
    }

    private void spawnCherryParticles() {
        if (this.m_9236_().f_46443_) {
            for (int i = 0; i < 4; ++i) {
                double offsetX = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                double offsetY = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_276452_, this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ, 0.0, -0.1, 0.0);
            }
        }
    }

    private void playBreakSound() {
        ItemStack item;
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)MaidSpellSounds.WIND_SEEKING_BELL.get(), SoundSource.NEUTRAL, 0.8f, 0.8f);
        Player currentPlayer = this.getPlayer();
        if (currentPlayer != null) {
            ItemStack item2;
            currentPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 1200, 1));
            if (currentPlayer.m_7500_()) {
                currentPlayer.m_6021_(this.aX, this.aY, this.aZ);
            }
            if (this.surviveAfterDeath && !currentPlayer.m_7500_() && !(item2 = this.getItem()).m_41619_()) {
                ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), item2);
                this.m_9236_().m_7967_((Entity)itemEntity);
            }
        } else if (this.surviveAfterDeath && !(item = this.getItem()).m_41619_()) {
            ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), item);
            this.m_9236_().m_7967_((Entity)itemEntity);
        }
    }

    protected boolean canHitEntity(Entity entity) {
        return entity instanceof Player && !entity.m_5833_() && entity.m_6084_();
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        ItemStack item = this.getItemRaw();
        if (!item.m_41619_()) {
            compound.m_128365_("Item", (Tag)item.m_41739_(new CompoundTag()));
        }
        compound.m_128347_("TargetX", this.targetX);
        compound.m_128347_("TargetY", this.targetY);
        compound.m_128347_("TargetZ", this.targetZ);
        compound.m_128347_("AX", this.aX);
        compound.m_128347_("AY", this.aY);
        compound.m_128347_("AZ", this.aZ);
        compound.m_128405_("Life", this.life);
        compound.m_128379_("SurviveAfterDeath", this.surviveAfterDeath);
        if (this.playerUUID != null) {
            compound.m_128362_("PlayerUUID", this.playerUUID);
        }
    }

    public void m_7378_(CompoundTag compound) {
        ItemStack item = ItemStack.m_41712_((CompoundTag)compound.m_128469_("Item"));
        this.setItem(item);
        this.targetX = compound.m_128459_("TargetX");
        this.targetY = compound.m_128459_("TargetY");
        this.targetZ = compound.m_128459_("TargetZ");
        this.aX = compound.m_128459_("AX");
        this.aY = compound.m_128459_("AY");
        this.aZ = compound.m_128459_("AZ");
        this.life = compound.m_128451_("Life");
        this.surviveAfterDeath = compound.m_128471_("SurviveAfterDeath");
        if (compound.m_128403_("PlayerUUID")) {
            this.playerUUID = compound.m_128342_("PlayerUUID");
        }
    }

    public boolean m_6087_() {
        return false;
    }

    public float m_6143_() {
        return 0.0f;
    }
}

