/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.event;

import com.github.tartaricacid.touhoulittlemaid.api.event.MaidBackpackChangeEvent;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidTamedEvent;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidTickEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.Global;
import com.github.yimeng261.maidspell.api.ISpellBookProvider;
import com.github.yimeng261.maidspell.item.MaidSpellItems;
import com.github.yimeng261.maidspell.item.bauble.enderPocket.EnderPocketService;
import com.github.yimeng261.maidspell.network.NetworkHandler;
import com.github.yimeng261.maidspell.network.message.EnderPocketMessage;
import com.github.yimeng261.maidspell.spell.data.MaidSlashBladeData;
import com.github.yimeng261.maidspell.spell.manager.AllianceManager;
import com.github.yimeng261.maidspell.spell.manager.BaubleStateManager;
import com.github.yimeng261.maidspell.spell.manager.SpellBookManager;
import com.github.yimeng261.maidspell.utils.ChunkLoadingManager;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import mods.flammpfeil.slashblade.capability.inputstate.CapabilityInputState;
import mods.flammpfeil.slashblade.capability.inputstate.InputStateCapabilityProvider;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="touhou_little_maid_spell")
public class MaidSpellEventHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final UUID MAID_STEP_HEIGHT_UUID = UUID.fromString("8e2c4a16-7f9d-4b45-a3e2-1c8f5d9a6b47");

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)entity;
            if (!event.getLevel().m_5776_()) {
                SpellBookManager manager = SpellBookManager.getOrCreateManager(maid);
                manager.setMaid(maid);
                manager.initSpellBooks();
                LivingEntity owner = maid.m_269323_();
                Global.maidList.add(maid);
                if (owner != null) {
                    Global.maidInfos.computeIfAbsent(owner.m_20148_(), k -> new HashMap()).put(maid.m_20148_(), maid);
                }
                MaidSpellEventHandler.addStepHeightToMaid(maid);
                if (BaubleStateManager.hasBauble(maid, MaidSpellItems.ANCHOR_CORE)) {
                    ServerLevel serverLevel = (ServerLevel)maid.m_9236_();
                    MinecraftServer server = serverLevel.m_7654_();
                    UUID maidId = maid.m_20148_();
                    server.execute(() -> {
                        try {
                            Entity delayedEntity = serverLevel.m_8791_(maidId);
                            if (delayedEntity instanceof EntityMaid) {
                                EntityMaid delayedMaid = (EntityMaid)delayedEntity;
                                if (ChunkLoadingManager.shouldEnableChunkLoading(delayedMaid, server)) {
                                    ChunkLoadingManager.restoreChunkLoadingFromSavedData(delayedMaid, server);
                                } else {
                                    ChunkLoadingManager.enableChunkLoading(delayedMaid);
                                }
                            }
                        }
                        catch (Exception e) {
                            LOGGER.error("\u5904\u7406\u5973\u4ec6\u533a\u5757\u52a0\u8f7d\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
                        }
                    });
                }
            }
        }
    }

    @SubscribeEvent
    public static void onMaidInvPutOn(MaidBackpackChangeEvent.PutOn event) {
        EntityMaid maid = event.getMaid();
        if (maid.m_9236_().m_5776_()) {
            return;
        }
        SpellBookManager manager = SpellBookManager.getOrCreateManager(maid);
        manager.addSpellItem(maid, event.getItemStack());
    }

    @SubscribeEvent
    public static void onMaidInvTakeOff(MaidBackpackChangeEvent.TakeOff event) {
        EntityMaid maid = event.getMaid();
        if (maid.m_9236_().m_5776_()) {
            return;
        }
        SpellBookManager manager = SpellBookManager.getOrCreateManager(maid);
        manager.removeSpellItem(maid, event.getItemStack());
        LOGGER.debug("itemstack: {} take off", (Object)event.getItemStack());
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            for (EntityMaid maid : Global.maidList) {
                LivingEntity owner = maid.m_269323_();
                if (owner == null) continue;
                Global.maidInfos.computeIfAbsent(owner.m_20148_(), k -> new HashMap()).put(maid.m_20148_(), maid);
            }
            MaidSpellEventHandler.restorePlayerMaidChunkLoading(player2);
            try {
                List<EnderPocketService.EnderPocketMaidInfo> maidInfos = EnderPocketService.getPlayerEnderPocketMaids(player2);
                if (!maidInfos.isEmpty()) {
                    LOGGER.debug("[MaidSpell] Pushing ender pocket data to player {} on login: {} maids", (Object)player2.m_7755_().getString(), (Object)maidInfos.size());
                    EnderPocketMessage message = EnderPocketMessage.serverPushUpdate(maidInfos);
                    NetworkHandler.CHANNEL.sendTo((Object)message, player2.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                    LOGGER.debug("[MaidSpell] Pushed ender pocket data to player {} on login: {} maids", (Object)player2.m_7755_().getString(), (Object)maidInfos.size());
                }
            }
            catch (Exception e) {
                LOGGER.error("[MaidSpell] Failed to sync ender pocket data for player {} on login: {}", new Object[]{player2.m_7755_().getString(), e.getMessage(), e});
            }
        }
    }

    @SubscribeEvent
    public static void onEntityLeaveLevel(EntityLeaveLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)entity;
            if (!event.getLevel().m_5776_()) {
                SpellBookManager manager = SpellBookManager.getOrCreateManager(maid);
                manager.stopAllCasting();
                LivingEntity owner = maid.m_269323_();
                if (owner != null) {
                    Global.maidInfos.computeIfAbsent(owner.m_20148_(), k -> new HashMap()).remove(maid.m_20148_());
                }
            }
        }
    }

    @SubscribeEvent
    public static void onMaidEquip(LivingEquipmentChangeEvent event) {
        EntityMaid maid;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof EntityMaid && !(maid = (EntityMaid)livingEntity).m_9236_().m_5776_() && !maid.m_9236_().m_5776_()) {
            SpellBookManager manager = SpellBookManager.getOrCreateManager(maid);
            LOGGER.debug("[MaidSpell] from: {}, to: {}", (Object)event.getFrom(), (Object)event.getTo());
            if (event.getTo() != ItemStack.f_41583_) {
                manager.addSpellItem(maid, event.getTo());
            }
            if (event.getFrom() != ItemStack.f_41583_) {
                manager.removeSpellItem(maid, event.getFrom());
            }
        }
    }

    @SubscribeEvent
    public static void onEntityTeleport(EntityTeleportEvent event) {
        EntityMaid maid;
        Entity entity = event.getEntity();
        if (entity instanceof EntityMaid && !(maid = (EntityMaid)entity).m_9236_().m_5776_()) {
            try {
                if (BaubleStateManager.hasBauble(maid, MaidSpellItems.ANCHOR_CORE)) {
                    UUID maidId = maid.m_20148_();
                    Global.LOGGER.debug("\u68c0\u6d4b\u5230\u5973\u4ec6 {} \u4f20\u9001\u4e8b\u4ef6\uff0c\u51c6\u5907\u66f4\u65b0\u533a\u5757\u52a0\u8f7d", (Object)maidId);
                    Level level = maid.m_9236_();
                    if (level instanceof ServerLevel) {
                        ServerLevel level2 = (ServerLevel)level;
                        ChunkLoadingManager.preloadTeleportTarget(maid, new Vec3(event.getTargetX(), event.getTargetY(), event.getTargetZ()), level2);
                        Global.LOGGER.debug("\u9884\u52a0\u8f7d\u5973\u4ec6 {} \u4f20\u9001\u76ee\u6807\u533a\u5757", (Object)maidId);
                    }
                }
            }
            catch (Exception e) {
                Global.LOGGER.error("\u5904\u7406\u5973\u4ec6\u4f20\u9001\u4e8b\u4ef6\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityTravelToDimension(EntityTravelToDimensionEvent event) {
        EntityMaid maid;
        Entity entity = event.getEntity();
        if (entity instanceof EntityMaid && !(maid = (EntityMaid)entity).m_9236_().m_5776_()) {
            try {
                if (BaubleStateManager.hasBauble(maid, MaidSpellItems.ANCHOR_CORE)) {
                    Entity newMaid;
                    UUID maidId = maid.m_20148_();
                    Global.LOGGER.debug("\u5973\u4ec6 {} \u8de8\u7ef4\u5ea6\u4f20\u9001\uff0c\u7981\u7528\u5f53\u524d\u7ef4\u5ea6\u533a\u5757\u52a0\u8f7d", (Object)maidId);
                    MinecraftServer server = maid.m_20194_();
                    if (server != null && (newMaid = Objects.requireNonNull(server.m_129880_(event.getDimension())).m_8791_(maidId)) instanceof EntityMaid) {
                        EntityMaid newMaidEntity = (EntityMaid)newMaid;
                        ChunkLoadingManager.enableChunkLoading(newMaidEntity);
                        Global.LOGGER.debug("\u5973\u4ec6 {} \u8de8\u7ef4\u5ea6\u4f20\u9001\u5b8c\u6210\uff0c\u542f\u7528\u65b0\u7ef4\u5ea6\u533a\u5757\u52a0\u8f7d", (Object)maidId);
                    }
                }
            }
            catch (Exception e) {
                Global.LOGGER.error("\u5904\u7406\u5973\u4ec6\u8de8\u7ef4\u5ea6\u4f20\u9001\u4e8b\u4ef6\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    @SubscribeEvent
    public static void onMaidTick(MaidTickEvent event) {
        EntityMaid maid = event.getMaid();
        if (!maid.m_9236_().m_5776_()) {
            try {
                SpellBookManager manager = SpellBookManager.getOrCreateManager(maid);
                manager.tick();
                if (maid.f_19797_ % 20 == 0) {
                    if (maid.m_21525_() && maid.getTask().getUid().toString().startsWith("maidspell")) {
                        maid.m_21557_(false);
                    }
                    if (maid.getTask().getUid().toString().startsWith("maidspell")) {
                        if (!AllianceManager.getAllianceStatus().containsKey(maid.m_20148_())) {
                            AllianceManager.setMaidAlliance(maid, true);
                        }
                    } else {
                        AllianceManager.setMaidAlliance(maid, false);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Error in maid tick handler for maid {}: {}", new Object[]{maid.m_7755_().getString(), e.getMessage(), e});
            }
        }
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingHurtEvent event) {
        EntityMaid maid;
        LivingEntity entity = event.getEntity();
        Entity source = event.getSource().m_7639_();
        if (source instanceof EntityMaid) {
            maid = (EntityMaid)source;
            MaidSpellEventHandler.processor_pre(event, maid);
        }
        if (entity instanceof EntityMaid) {
            maid = (EntityMaid)entity;
            Global.commonHurtCalc.forEach((Consumer<BiFunction<LivingHurtEvent, EntityMaid, Void>>)((Consumer<BiFunction>)function -> function.apply(event, maid)));
            Global.baubleCommonHurtCalcPre.forEach((item, func) -> {
                if (BaubleStateManager.hasBauble(maid, item)) {
                    func.apply(event, maid);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onEntityDamage(LivingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        Entity direct = event.getSource().m_7640_();
        Entity source = event.getSource().m_7639_();
        if (source instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)source;
            MaidSpellEventHandler.processorAft(event, maid);
        } else if (direct instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)direct;
            MaidSpellEventHandler.processorAft(event, maid);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Global.playerHurtCalcAft.forEach((Consumer<BiFunction<LivingDamageEvent, Player, Void>>)((Consumer<BiFunction>)func -> func.apply(event, player)));
        }
    }

    @SubscribeEvent
    public static void onMaidEffectAdded(MobEffectEvent.Added event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)livingEntity;
            Global.baubleEffectAddedCalc.forEach((item, func) -> {
                if (BaubleStateManager.hasBauble(maid, item)) {
                    func.apply(event, maid);
                }
            });
        }
    }

    private static void processorAft(LivingDamageEvent event, EntityMaid maid) {
        Global.baubleDamageCalcAft.forEach((item, func) -> {
            if (BaubleStateManager.hasBauble(maid, item)) {
                func.apply(event, maid);
            }
        });
    }

    private static void processor_pre(LivingHurtEvent event, EntityMaid maid) {
        Global.commonDamageCalc.forEach((Consumer<BiFunction<LivingHurtEvent, EntityMaid, Void>>)((Consumer<BiFunction>)function -> function.apply(event, maid)));
        Global.baubleDamageCalcPre.forEach((item, func) -> {
            if (BaubleStateManager.hasBauble(maid, item)) {
                func.apply(event, maid);
            }
        });
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (((Entity)event.getObject()).m_9236_().m_5776_()) {
            return;
        }
        if (event.getObject() instanceof EntityMaid) {
            if (!ModList.get().isLoaded("slashblade")) {
                return;
            }
            Entity entity = (Entity)event.getObject();
            ResourceLocation maidInputStateKey = new ResourceLocation("touhou_little_maid_spell", "maid_inputstate");
            try {
                if (!entity.getCapability(CapabilityInputState.INPUT_STATE).isPresent()) {
                    event.addCapability(maidInputStateKey, (ICapabilityProvider)new InputStateCapabilityProvider());
                    LOGGER.debug("Added INPUT_STATE capability to maid entity");
                }
            }
            catch (Exception e) {
                LOGGER.warn("Failed to add INPUT_STATE capability to maid: {}", (Object)e.getMessage());
            }
        }
    }

    @SubscribeEvent
    public static void onMaidDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)livingEntity;
            Global.baubleDeathCalc.forEach((item, func) -> {
                if (BaubleStateManager.hasBauble(maid, item)) {
                    func.apply(event, maid);
                }
            });
            if (!event.isCanceled()) {
                MaidSpellEventHandler.cleanupMaidSpellData(maid);
            }
        }
    }

    private static void cleanupMaidSpellData(EntityMaid maid) {
        try {
            SpellBookManager manager = SpellBookManager.getOrCreateManager(maid);
            for (ISpellBookProvider<?, ?> provider : manager.getProviders()) {
                if (!provider.isCasting(maid)) continue;
                provider.stopCasting(maid);
            }
            MaidSlashBladeData.remove(maid.m_20148_());
            SpellBookManager.removeManager(maid);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void addStepHeightToMaid(EntityMaid maid) {
        try {
            AttributeInstance stepHeightAttribute = maid.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get());
            if (stepHeightAttribute == null) {
                LOGGER.warn("Maid {} does not have step height attribute", (Object)maid.m_7755_().getString());
                return;
            }
            if (stepHeightAttribute.m_22111_(MAID_STEP_HEIGHT_UUID) == null) {
                AttributeModifier stepHeightModifier = new AttributeModifier(MAID_STEP_HEIGHT_UUID, "Maid Step Height Addition", 1.0, AttributeModifier.Operation.ADDITION);
                stepHeightAttribute.m_22125_(stepHeightModifier);
                LOGGER.debug("Added step height attribute to maid: {}", (Object)maid.m_7755_().getString());
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to add step height attribute to maid {}: {}", (Object)maid.m_7755_().getString(), (Object)e.getMessage());
        }
    }

    @SubscribeEvent
    public static void onMaidTamed(MaidTamedEvent event) {
        Level level;
        EntityMaid maid = event.getMaid();
        Player player = event.getPlayer();
        if (!player.m_9236_().m_5776_() && (level = player.m_9236_()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (maid.m_21827_() && !maid.isStructureSpawn() && MaidSpellEventHandler.isInHiddenRetreatStructure(level2, maid.m_20183_())) {
                player.m_213846_((Component)Component.m_237115_((String)"item.touhou_little_maid_spell.maid_tamed_event.maid_in_hidden_retreat").m_130940_(ChatFormatting.LIGHT_PURPLE));
            }
        }
    }

    private static void restorePlayerMaidChunkLoading(ServerPlayer player) {
        try {
            MinecraftServer server = player.m_20194_();
            if (server == null) {
                return;
            }
            ChunkLoadingManager.ChunkLoadingData data = ChunkLoadingManager.ChunkLoadingData.get(server);
            Map<UUID, ChunkLoadingManager.ChunkKey> savedPositions = data.getSavedPositions();
            if (savedPositions.isEmpty()) {
                return;
            }
            int restoredCount = 0;
            int totalCount = savedPositions.size();
            LOGGER.info("\u5f00\u59cb\u4e3a\u73a9\u5bb6 {} \u6062\u590d {} \u4e2a\u5973\u4ec6\u7684\u533a\u5757\u52a0\u8f7d\u72b6\u6001", (Object)player.m_7755_().getString(), (Object)totalCount);
            for (Map.Entry<UUID, ChunkLoadingManager.ChunkKey> entry : savedPositions.entrySet()) {
                UUID maidId = entry.getKey();
                ChunkLoadingManager.ChunkKey info = entry.getValue();
                try {
                    ServerLevel targetLevel = info.level();
                    if (targetLevel == null) {
                        LOGGER.warn("\u65e0\u6cd5\u627e\u5230\u7ef4\u5ea6 {} \u6765\u6062\u590d\u5973\u4ec6 {} \u7684\u533a\u5757\u52a0\u8f7d", null, (Object)maidId);
                        continue;
                    }
                    boolean success = ForgeChunkManager.forceChunk((ServerLevel)targetLevel, (String)"touhou_little_maid_spell", (UUID)maidId, (int)info.chunkPos().f_45578_, (int)info.chunkPos().f_45579_, (boolean)true, (boolean)true);
                    if (success) {
                        ChunkLoadingManager.maidChunkPositions.put(maidId, info);
                        ++restoredCount;
                        LOGGER.debug("\u6210\u529f\u6062\u590d\u5973\u4ec6 {} \u7684\u533a\u5757\u52a0\u8f7d: {} ({})", new Object[]{maidId, info.chunkPos(), info.level()});
                        continue;
                    }
                    LOGGER.warn("\u65e0\u6cd5\u6062\u590d\u5973\u4ec6 {} \u7684\u533a\u5757\u52a0\u8f7d: {} ({})", new Object[]{maidId, info.chunkPos(), info.level()});
                }
                catch (Exception e) {
                    LOGGER.warn("\u6062\u590d\u5973\u4ec6 {} \u533a\u5757\u52a0\u8f7d\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)maidId, (Object)e.getMessage());
                }
            }
            if (restoredCount > 0) {
                LOGGER.info("\u4e3a\u73a9\u5bb6 {} \u6210\u529f\u6062\u590d\u4e86 {}/{} \u4e2a\u5973\u4ec6\u7684\u533a\u5757\u52a0\u8f7d", new Object[]{player.m_7755_().getString(), restoredCount, totalCount});
            } else {
                LOGGER.warn("\u4e3a\u73a9\u5bb6 {} \u6062\u590d\u5973\u4ec6\u533a\u5757\u52a0\u8f7d\u5931\u8d25\uff0c\u6ca1\u6709\u6210\u529f\u6062\u590d\u4efb\u4f55\u5973\u4ec6", (Object)player.m_7755_().getString());
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4e3a\u73a9\u5bb6 {} \u6062\u590d\u5973\u4ec6\u533a\u5757\u52a0\u8f7d\u65f6\u53d1\u751f\u4e25\u91cd\u9519\u8bef", (Object)player.m_7755_().getString(), (Object)e);
        }
    }

    private static boolean isInHiddenRetreatStructure(ServerLevel level, BlockPos pos) {
        try {
            StructureManager structureManager = level.m_215010_();
            Optional hiddenRetreatStructureSet = level.m_9598_().m_175515_(Registries.f_256944_).m_6612_(new ResourceLocation("touhou_little_maid_spell", "hidden_retreat"));
            if (hiddenRetreatStructureSet.isPresent()) {
                StructureStart structureStart = structureManager.m_220524_(pos, (Structure)hiddenRetreatStructureSet.get());
                return structureStart.m_73603_();
            }
        }
        catch (Exception e) {
            LogUtils.getLogger().debug("Error checking hidden_retreat structure at {}: {}", (Object)pos, (Object)e.getMessage());
        }
        return false;
    }
}

