/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.item.bauble.enderPocket;

import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.Global;
import com.github.yimeng261.maidspell.client.event.MaidBackpackEnderPocketIntegration;
import com.github.yimeng261.maidspell.item.bauble.enderPocket.EnderPocketService;
import com.github.yimeng261.maidspell.network.NetworkHandler;
import com.github.yimeng261.maidspell.network.message.EnderPocketMessage;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkDirection;

public class EnderPocketBauble
implements IMaidBauble {
    public void onPutOn(EntityMaid maid, ItemStack baubleItem) {
        try {
            LivingEntity livingEntity;
            if (maid.m_9236_().m_5776_()) {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> ClientHandler::handleBaubleChange);
            }
            if (!maid.m_9236_().m_5776_() && (livingEntity = maid.m_269323_()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                this.pushEnderPocketDataToClient(player);
            }
        }
        catch (Exception e) {
            Global.LOGGER.error("Failed to handle ender pocket bauble add for maid: {}", (Object)maid.m_7755_().getString(), (Object)e);
        }
    }

    public void onTakeOff(EntityMaid maid, ItemStack baubleItem) {
        try {
            LivingEntity livingEntity;
            if (maid.m_9236_().m_5776_()) {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> ClientHandler::handleBaubleChange);
            }
            if (!maid.m_9236_().m_5776_() && (livingEntity = maid.m_269323_()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                this.pushEnderPocketDataToClient(player);
            }
        }
        catch (Exception e) {
            Global.LOGGER.error("Failed to handle ender pocket bauble remove for maid: {}", (Object)maid.m_7755_().getString(), (Object)e);
        }
    }

    private void pushEnderPocketDataToClient(ServerPlayer player) {
        try {
            List<EnderPocketService.EnderPocketMaidInfo> maidInfos = EnderPocketService.getPlayerEnderPocketMaids(player);
            EnderPocketMessage message = EnderPocketMessage.serverPushUpdate(maidInfos);
            NetworkHandler.CHANNEL.sendTo((Object)message, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
        catch (Exception e) {
            Global.LOGGER.error("Failed to push ender pocket data to client for player: {}", (Object)player.m_7755_().getString(), (Object)e);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class ClientHandler {
        private ClientHandler() {
        }

        public static void handleBaubleChange() {
            try {
                Minecraft mc = Minecraft.m_91087_();
                if (mc.m_91403_() != null) {
                    MaidBackpackEnderPocketIntegration.forceRefreshData();
                }
            }
            catch (Exception e) {
                Global.LOGGER.error("Failed to handle bauble change on client side: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }
}

