/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.item.bauble.hairpin;

import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidAfterEatEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.github.yimeng261.maidspell.Config;
import com.github.yimeng261.maidspell.Global;
import com.github.yimeng261.maidspell.damage.InfoDamageSource;
import com.github.yimeng261.maidspell.item.MaidSpellItems;
import com.mojang.logging.LogUtils;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.slf4j.Logger;

public class HairpinBauble
implements IMaidBauble {
    public static final Logger LOGGER = LogUtils.getLogger();

    public HairpinBauble() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void onTick(EntityMaid maid, ItemStack baubleItem) {
        if (maid.f_19797_ % 10 == 0) {
            maid.m_21220_().forEach(effect -> {
                if (!effect.m_19544_().m_19486_()) {
                    effect.m_19558_(new MobEffectInstance(effect.m_19544_(), 0, 0));
                }
            });
        }
    }

    @SubscribeEvent
    public void beforeMaidEffectAdded(MobEffectEvent.Applicable event) {
        EntityMaid maid;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof EntityMaid && ItemsUtil.getBaubleSlotInMaid((EntityMaid)(maid = (EntityMaid)livingEntity), (IMaidBauble)this) >= 0) {
            MobEffectInstance effectInstance = event.getEffectInstance();
            int fl = maid.getFavorabilityManager().getLevel();
            if (fl >= 3 && !effectInstance.m_19544_().m_19486_()) {
                event.setResult(Event.Result.DENY);
            }
            if (fl >= 2) {
                int duration = effectInstance.m_19557_();
                if (effectInstance.m_19544_().m_19486_()) {
                    duration = Math.max((int)((double)duration * Config.hairpinBeneficialEffectExtension), duration + Config.hairpinMinExtensionTicks);
                    effectInstance.m_19558_(new MobEffectInstance(effectInstance.m_19544_(), duration, event.getEffectInstance().m_19564_(), event.getEffectInstance().m_19571_(), event.getEffectInstance().m_19572_()));
                }
            }
        }
    }

    @SubscribeEvent
    public void afterMaidEat(MaidAfterEatEvent event) {
        EntityMaid maid = event.getMaid();
        if (ItemsUtil.getBaubleSlotInMaid((EntityMaid)maid, (IMaidBauble)this) >= 0) {
            maid.getFavorabilityManager().add(Config.hairpinFavorabilityGain);
        }
    }

    static {
        Global.baubleCommonHurtCalcPre.put((Item)MaidSpellItems.HAIRPIN.get(), (event, maid) -> {
            LivingEntity owner = maid.m_269323_();
            DamageSource source = event.getSource();
            if (owner == null) {
                return null;
            }
            if (source instanceof InfoDamageSource) {
                InfoDamageSource infoDamage = (InfoDamageSource)source;
                if ("hairpin_redirect".equals(infoDamage.msg_type)) {
                    return null;
                }
            }
            InfoDamageSource hairpinDamage = InfoDamageSource.create(owner.m_9236_(), "hairpin_redirect", source);
            hairpinDamage.setSourceEntity((LivingEntity)maid);
            owner.m_20331_(false);
            owner.f_19802_ = 0;
            owner.m_6469_((DamageSource)hairpinDamage, event.getAmount());
            event.setCanceled(true);
            return null;
        });
        Global.playerHurtCalcAft.add((event, player) -> {
            DamageSource source = event.getSource();
            if (source instanceof InfoDamageSource) {
                InfoDamageSource infoDamage = (InfoDamageSource)source;
                if ("hairpin_redirect".equals(infoDamage.msg_type)) {
                    EntityMaid maid = (EntityMaid)infoDamage.sourceEntity;
                    maid.m_20331_(false);
                    maid.f_19802_ = 0;
                    maid.m_6469_(source, event.getAmount());
                    event.setCanceled(true);
                }
            }
            return null;
        });
    }
}

