/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.item.bauble.spellCore;

import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

public class SpellEnhancementBauble
implements IMaidBauble {
    private static final List<AttributeConfig> ATTRIBUTES = new ArrayList<AttributeConfig>();
    private static final Logger LOGGER = LogUtils.getLogger();

    private static void initializeAttributes() {
        ForgeRegistries.ATTRIBUTES.forEach(attribute -> {
            if (attribute.m_22087_().startsWith("attribute.irons_spellbooks.")) {
                double defaultValue = attribute.m_22082_();
                ATTRIBUTES.add(new AttributeConfig((Attribute)attribute, defaultValue, attribute.m_22087_().replace("attribute.irons_spellbooks.", "")));
            }
        });
    }

    public void onTick(EntityMaid maid, ItemStack baubleItem) {
        if (maid.m_9236_().f_46443_ || maid.f_19797_ % 40 != 0) {
            return;
        }
        LivingEntity owner = maid.m_269323_();
        if (!(owner instanceof Player)) {
            return;
        }
        Player player = (Player)owner;
        this.updateMaidEnhancements(maid, player);
    }

    private void updateMaidEnhancements(EntityMaid maid, Player player) {
        for (AttributeConfig config : ATTRIBUTES) {
            double bonus = 0.0;
            if (player != null) {
                double playerValue = player.m_21133_(config.attribute);
                bonus = Math.max(0.0, playerValue - config.defaultValue);
            }
            AttributeInstance maidAttr = maid.m_21051_(config.attribute);
            AttributeModifier modifier = new AttributeModifier("yimeng" + config.attributeName, bonus, AttributeModifier.Operation.ADDITION);
            if (maidAttr == null) {
                return;
            }
            if (config.uuid != null) {
                maidAttr.m_22120_(config.uuid);
            }
            config.uuid = modifier.m_22209_();
            maidAttr.m_22118_(modifier);
        }
    }

    private void clearAllEnhancements(EntityMaid maid) {
        for (AttributeConfig config : ATTRIBUTES) {
            AttributeInstance maidAttr = maid.m_21051_(config.attribute);
            if (maidAttr == null || config.uuid == null) continue;
            maidAttr.m_22120_(config.uuid);
            LOGGER.debug("Removed modifier {} for attribute {} from maid {}", new Object[]{config.uuid, config.attributeName, maid.m_7755_().getString()});
        }
    }

    static {
        if (ModList.get().isLoaded("irons_spellbooks")) {
            SpellEnhancementBauble.initializeAttributes();
        }
    }

    private static class AttributeConfig {
        final Attribute attribute;
        final double defaultValue;
        UUID uuid = null;
        String attributeName;

        AttributeConfig(Attribute attribute, double defaultValue, String attributeName) {
            this.attribute = attribute;
            this.defaultValue = defaultValue;
            this.attributeName = attributeName;
        }
    }
}

