/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.spell.data;

import com.github.yimeng261.maidspell.api.IMaidSpellData;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class MaidSlashBladeData
extends IMaidSpellData {
    private static final Map<UUID, MaidSlashBladeData> DATA_MAP = new ConcurrentHashMap<UUID, MaidSlashBladeData>();
    private WeakReference<LivingEntity> target = new WeakReference<Object>(null);
    private boolean isCasting = false;
    private long saExecutionStartTime = 0L;
    private ResourceLocation lastComboState = null;
    private int targetUseTime = 0;
    private int cooldown = 0;

    private MaidSlashBladeData(UUID maidUUID) {
    }

    public static MaidSlashBladeData getOrCreate(UUID maidUUID) {
        return DATA_MAP.computeIfAbsent(maidUUID, MaidSlashBladeData::new);
    }

    public static void remove(UUID maidUUID) {
        DATA_MAP.remove(maidUUID);
    }

    @Override
    public LivingEntity getTarget() {
        return (LivingEntity)this.target.get();
    }

    @Override
    public void setTarget(LivingEntity target) {
        this.target = new WeakReference<LivingEntity>(target);
    }

    @Override
    public boolean isCasting() {
        return this.isCasting;
    }

    @Override
    public void setCasting(boolean casting) {
        this.isCasting = casting;
    }

    public void setSAExecutionStartTime(long time) {
        this.saExecutionStartTime = time;
    }

    public long getSAExecutionStartTime() {
        return this.saExecutionStartTime;
    }

    public int getTargetUseTime() {
        return this.targetUseTime;
    }

    public void setTargetUseTime(int time) {
        this.targetUseTime = time;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(int time) {
        this.cooldown = time;
    }

    public Boolean isOnCooldown() {
        return this.cooldown > 0;
    }

    public ResourceLocation getLastComboState() {
        return this.lastComboState;
    }

    public void setLastComboState(ResourceLocation lastComboState) {
        this.lastComboState = lastComboState;
    }

    @Override
    public void updateCooldowns() {
        this.cooldown -= 20;
    }

    public void reset() {
        this.target = new WeakReference<Object>(null);
        this.isCasting = false;
        this.saExecutionStartTime = 0L;
        this.targetUseTime = 0;
        this.lastComboState = null;
    }
}

