/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.spell.manager;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.api.ISpellBookProvider;
import com.github.yimeng261.maidspell.spell.providers.ArsNouveauProvider;
import com.github.yimeng261.maidspell.spell.providers.GoetyProvider;
import com.github.yimeng261.maidspell.spell.providers.IronsSpellbooksProvider;
import com.github.yimeng261.maidspell.spell.providers.PsiProvider;
import com.github.yimeng261.maidspell.spell.providers.SlashBladeProvider;
import com.github.yimeng261.maidspell.spell.providers.YoukaiHomecomingProvider;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class SpellBookManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<UUID, SpellBookManager> MAID_MANAGERS = new ConcurrentHashMap<UUID, SpellBookManager>();
    private static final List<ISpellBookProvider<?, ?>> instanceProviders = new ArrayList();
    public static final List<String> loadedMods = new ArrayList<String>();
    private EntityMaid maid;

    private static void initializeProviderFactories() {
        LOGGER.info("Initializing spell book provider factories...");
        SpellBookManager.registerProviderFactoryByClass("irons_spellbooks", "IronsSpellbooksProvider", IronsSpellbooksProvider.class);
        SpellBookManager.registerProviderFactoryByClass("ars_nouveau", "ArsNouveauProvider", ArsNouveauProvider.class);
        SpellBookManager.registerProviderFactoryByClass("psi", "PsiProvider", PsiProvider.class);
        SpellBookManager.registerProviderFactoryByClass("slashblade", "SlashBladeProvider", SlashBladeProvider.class);
        SpellBookManager.registerProviderFactoryByClass("goety", "GoetyProvider", GoetyProvider.class);
        SpellBookManager.registerProviderFactoryByClass("youkaishomecoming", "YoukaiHomecomingProvider", YoukaiHomecomingProvider.class);
    }

    private static void registerProviderFactoryByClass(String modId, String providerName, Class<?> providerClass) {
        try {
            if (ModList.get().isLoaded(modId)) {
                instanceProviders.add((ISpellBookProvider)providerClass.getConstructor(new Class[0]).newInstance(new Object[0]));
                loadedMods.add(modId);
                LOGGER.debug("Mod {} loaded, finished {} registration", (Object)modId, (Object)providerName);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to register provider factory for mod {}: {}", (Object)modId, (Object)e.getMessage());
        }
    }

    private SpellBookManager(EntityMaid maid) {
        this.maid = maid;
    }

    @NotNull
    public static SpellBookManager getOrCreateManager(EntityMaid maid) {
        UUID maidUUID = maid.m_20148_();
        return MAID_MANAGERS.computeIfAbsent(maidUUID, uuid -> {
            LOGGER.debug("Creating new SpellBookManager for maid {}", uuid);
            return new SpellBookManager(maid);
        });
    }

    public static void removeManager(EntityMaid maid) {
        if (maid == null) {
            return;
        }
        UUID maidUUID = maid.m_20148_();
        SpellBookManager removed = MAID_MANAGERS.remove(maidUUID);
        if (removed != null) {
            LOGGER.debug("Removed SpellBookManager for maid {}", (Object)maidUUID);
        }
    }

    public void castSpell(EntityMaid maid) {
        for (ISpellBookProvider<?, ?> provider : this.getProviders()) {
            provider.castSpell(maid);
        }
    }

    public List<ISpellBookProvider<?, ?>> getProviders() {
        return new ArrayList(instanceProviders);
    }

    public void stopAllCasting() {
        for (ISpellBookProvider<?, ?> provider : this.getProviders()) {
            if (!provider.isCasting(this.maid)) continue;
            provider.stopCasting(this.maid);
        }
    }

    public EntityMaid getMaid() {
        return this.maid;
    }

    public void setMaid(EntityMaid maid) {
        this.maid = maid;
    }

    public void updateCooldown() {
        for (ISpellBookProvider<?, ?> provider : this.getProviders()) {
            provider.updateCooldown(this.maid);
        }
    }

    public void tick() {
        for (ISpellBookProvider<?, ?> provider : this.getProviders()) {
            if (provider.getTarget(this.maid) != null) {
                provider.getTarget((EntityMaid)this.maid).f_19802_ = 0;
            }
            provider.processContinuousCasting(this.maid);
        }
        if (this.maid.f_19797_ % 20 == 0) {
            this.updateCooldown();
        }
    }

    public void initSpellBooks() {
        for (ISpellBookProvider<?, ?> provider : this.getProviders()) {
            provider.clearSpellItems(this.maid);
        }
        CombinedInvWrapper wrapper = this.maid.getAvailableInv(true);
        for (int i = 0; i < wrapper.getSlots(); ++i) {
            ItemStack itemStack = wrapper.getStackInSlot(i);
            for (ISpellBookProvider<?, ?> provider : this.getProviders()) {
                provider.handleItemStack(this.maid, itemStack, true);
            }
        }
    }

    public void removeSpellItem(EntityMaid maid, ItemStack itemStack) {
        for (ISpellBookProvider<?, ?> provider : this.getProviders()) {
            provider.handleItemStack(maid, itemStack, false);
        }
    }

    public void addSpellItem(EntityMaid maid, ItemStack itemStack) {
        for (ISpellBookProvider<?, ?> provider : this.getProviders()) {
            provider.handleItemStack(maid, itemStack, true);
        }
    }

    static {
        SpellBookManager.initializeProviderFactories();
    }
}

