/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.spell.providers;

import com.Polarice3.Goety.api.items.magic.IFocus;
import com.Polarice3.Goety.api.magic.IChargingSpell;
import com.Polarice3.Goety.api.magic.ISpell;
import com.Polarice3.Goety.common.items.handler.FocusBagItemHandler;
import com.Polarice3.Goety.common.items.magic.FocusBag;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.api.ISpellBookProvider;
import com.github.yimeng261.maidspell.spell.data.MaidGoetySpellData;
import com.github.yimeng261.maidspell.utils.VersionUtil;
import com.mojang.logging.LogUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;

public class GoetyProvider
extends ISpellBookProvider<MaidGoetySpellData, ISpell> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int MAX_INFINITE_CASTING_TIME = 45;
    private static final String NEW_API_MIN_VERSION = "2.5.37.0";
    private static Method cachedStopSpellMethod = null;
    private static volatile boolean stopSpellMethodInitialized = false;
    private static volatile Boolean useNewAPI = null;

    public GoetyProvider() {
        super(MaidGoetySpellData::getOrCreate, ISpell.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean shouldUseNewAPI() {
        if (useNewAPI != null) return useNewAPI;
        Class<GoetyProvider> clazz = GoetyProvider.class;
        synchronized (GoetyProvider.class) {
            if (useNewAPI != null) return useNewAPI;
            useNewAPI = VersionUtil.isGoetyVersionSatisfied(NEW_API_MIN_VERSION);
            LOGGER.info("Goety API version detection: using {} API", (Object)(useNewAPI != false ? "new" : "old"));
            // ** MonitorExit[var0] (shouldn't be in output)
            return useNewAPI;
        }
    }

    @Override
    protected List<ISpell> collectSpellFromSingleSpellBook(ItemStack spellBook, EntityMaid maid) {
        ArrayList<ISpell> availableFoci = new ArrayList<ISpell>();
        MaidGoetySpellData data = (MaidGoetySpellData)this.getData(maid);
        FocusBagItemHandler bagHandler = FocusBagItemHandler.get((ItemStack)spellBook);
        for (int i = 0; i < bagHandler.getSlots(); ++i) {
            IFocus focus;
            ISpell spell;
            Item item;
            ItemStack focusStack = bagHandler.getStackInSlot(i);
            if (focusStack.m_41619_() || !((item = focusStack.m_41720_()) instanceof IFocus) || (spell = (focus = (IFocus)item).getSpell()) == null || data.isSpellOnCooldown(this.getSpellId(spell))) continue;
            availableFoci.add(focus.getSpell());
        }
        return availableFoci;
    }

    @Override
    public boolean isSpellBook(ItemStack itemStack) {
        return itemStack != null && !itemStack.m_41619_() && itemStack.m_41720_() instanceof FocusBag;
    }

    @Override
    public void initiateCasting(EntityMaid maid) {
        MaidGoetySpellData data = (MaidGoetySpellData)this.getData(maid);
        LivingEntity target = data.getTarget();
        if (target == null || !target.m_6084_()) {
            return;
        }
        ISpell spell = this.selectSpell(maid);
        if (spell == null) {
            return;
        }
        this.updateMaidOrientation(maid, data);
        this.startSpellCasting(maid, spell);
    }

    @Override
    public void processContinuousCasting(EntityMaid maid) {
        MaidGoetySpellData data = (MaidGoetySpellData)this.getData(maid);
        if (data == null || !data.isCasting() || data.getCurrentSpell() == null || !this.isSpellBook(data.getSpellBook())) {
            return;
        }
        data.incrementCastingTime();
        this.updateMaidOrientation(maid, data);
        this.processSpellCasting(maid);
    }

    @Override
    public void stopCasting(EntityMaid maid) {
        MaidGoetySpellData data;
        if (maid.m_6117_()) {
            maid.m_5810_();
        }
        if ((data = (MaidGoetySpellData)this.getData(maid)) == null || !data.isCasting() || data.getCurrentSpell() == null) {
            return;
        }
        Level level = maid.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int remainingTime = data.getMaxCastingTime() - data.getCastingTime();
            this.stopSpellUnified(data.getCurrentSpell(), serverLevel, maid, data.getSpellBook(), remainingTime);
        }
        this.setCooldown(maid, data.getCurrentSpell());
        this.resetCastingState(maid, data);
    }

    private ISpell selectSpell(EntityMaid maid) {
        MaidGoetySpellData data = (MaidGoetySpellData)this.getData(maid);
        if (data.getSpellBook() == null || data.getSpellBook().m_41619_()) {
            return null;
        }
        List availableFoci = this.collectSpellFromAvailableSpellBooks(maid);
        if (availableFoci.isEmpty()) {
            return null;
        }
        int randomIndex = (int)(Math.random() * (double)availableFoci.size());
        return (ISpell)availableFoci.get(randomIndex);
    }

    private void startSpellCasting(EntityMaid maid, ISpell spell) {
        int castDuration;
        if (spell.CastingSound() != null) {
            this.playSpellSound(maid, spell);
        }
        if ((castDuration = spell.defaultCastDuration()) <= 0 && !(spell instanceof IChargingSpell)) {
            this.executeInstantSpell(maid, spell);
            this.setCooldown(maid, spell);
            return;
        }
        if (spell instanceof IChargingSpell) {
            IChargingSpell chargingSpell = (IChargingSpell)spell;
            if (chargingSpell.everCharge()) {
                castDuration = 45;
            }
            this.resetChargingCounters(maid);
        }
        this.initiateCastingState(maid, spell, castDuration);
        this.startSpellExecution(maid, spell);
    }

    private void executeInstantSpell(EntityMaid maid, ISpell spell) {
        Level level = maid.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            spell.startSpell(serverLevel, (LivingEntity)maid, ((MaidGoetySpellData)this.getData(maid)).getSpellBook(), spell.defaultStats());
            spell.SpellResult(serverLevel, (LivingEntity)maid, ((MaidGoetySpellData)this.getData(maid)).getSpellBook(), spell.defaultStats());
        }
    }

    private void initiateCastingState(EntityMaid maid, ISpell spell, int duration) {
        MaidGoetySpellData data = (MaidGoetySpellData)this.getData(maid);
        if (data != null) {
            data.initiateCastingState(spell, duration);
        }
    }

    private void resetChargingCounters(EntityMaid maid) {
        MaidGoetySpellData data = (MaidGoetySpellData)this.getData(maid);
        if (data != null) {
            data.resetChargingCounters();
        }
    }

    private void startSpellExecution(EntityMaid maid, ISpell spell) {
        Level level = maid.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            spell.startSpell(serverLevel, (LivingEntity)maid, ((MaidGoetySpellData)this.getData(maid)).getSpellBook(), spell.defaultStats());
        }
    }

    private void updateMaidOrientation(EntityMaid maid, MaidGoetySpellData data) {
        LivingEntity target = data.getTarget();
        if (target != null && target.m_6084_()) {
            BehaviorUtils.m_22595_((LivingEntity)maid, (LivingEntity)target);
            if (data.getCurrentSpell() instanceof IChargingSpell) {
                this.updatePreciseOrientation(maid, data);
            }
        }
    }

    private void updatePreciseOrientation(EntityMaid maid, MaidGoetySpellData data) {
        LivingEntity target = data.getTarget();
        if (target == null) {
            return;
        }
        double dx = target.m_20185_() - maid.m_20185_();
        double dy = target.m_20188_() - maid.m_20188_();
        double dz = target.m_20189_() - maid.m_20189_();
        double horizontalDistance = Math.sqrt(dx * dx + dz * dz);
        float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
        float pitch = (float)(-(Math.atan2(dy, horizontalDistance) * 180.0 / Math.PI));
        maid.m_146922_(yaw);
        maid.m_146926_(pitch);
        maid.f_19859_ = yaw;
        maid.f_19860_ = pitch;
    }

    private void processSpellCasting(EntityMaid maid) {
        MaidGoetySpellData data = (MaidGoetySpellData)this.getData(maid);
        if (data == null) {
            return;
        }
        ISpell spell = data.getCurrentSpell();
        if (spell == null) {
            return;
        }
        Level level = maid.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!data.spellUsed()) {
                spell.useSpell(serverLevel, (LivingEntity)maid, data.getSpellBook(), data.getCastingTime(), spell.defaultStats());
                data.setSpellUsed(true);
            }
        }
        if (data.getCastingTime() >= data.getMaxCastingTime()) {
            this.completeCasting(maid);
            return;
        }
        if (spell instanceof IChargingSpell) {
            IChargingSpell chargingSpell = (IChargingSpell)spell;
            this.handleChargingLogic(maid, chargingSpell);
        }
    }

    private void handleChargingLogic(EntityMaid maid, IChargingSpell chargingSpell) {
        MaidGoetySpellData data = (MaidGoetySpellData)this.getData(maid);
        if (data == null) {
            return;
        }
        data.incrementCoolCounter();
        int requiredCooldown = chargingSpell.Cooldown((LivingEntity)maid, data.getSpellBook(), data.getShotsFired());
        if (data.getCoolCounter() >= requiredCooldown) {
            data.setCoolCounter(0);
            this.executeChargingShot(maid, chargingSpell);
            int shootCount = chargingSpell.shotsNumber((LivingEntity)maid, data.getSpellBook());
            if (shootCount > 0 && shootCount <= data.getShotsFired()) {
                this.completeCasting(maid);
            }
        }
    }

    private void executeChargingShot(EntityMaid maid, IChargingSpell chargingSpell) {
        MaidGoetySpellData data = (MaidGoetySpellData)this.getData(maid);
        if (data == null) {
            return;
        }
        Level level = maid.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            chargingSpell.SpellResult(serverLevel, (LivingEntity)maid, data.getSpellBook(), chargingSpell.defaultStats());
        }
    }

    private void playSpellSound(EntityMaid maid, ISpell spell) {
        maid.m_9236_().m_6263_(null, maid.m_20185_(), maid.m_20186_(), maid.m_20189_(), Objects.requireNonNull(spell.CastingSound()), SoundSource.HOSTILE, spell.castingVolume(), spell.castingPitch());
    }

    private void completeCasting(EntityMaid maid) {
        MaidGoetySpellData data = (MaidGoetySpellData)this.getData(maid);
        if (data == null || data.getCurrentSpell() == null) {
            return;
        }
        Level level = maid.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.stopSpellUnified(data.getCurrentSpell(), serverLevel, maid, data.getSpellBook(), 0);
            data.getCurrentSpell().SpellResult(serverLevel, (LivingEntity)maid, data.getSpellBook(), data.getCurrentSpell().defaultStats());
        }
        this.setCooldown(maid, data.getCurrentSpell());
        this.resetCastingState(maid, data);
    }

    private void resetCastingState(EntityMaid maid, MaidGoetySpellData data) {
        data.resetCastingState();
        maid.m_5810_();
    }

    private String getSpellId(ISpell spell) {
        return spell.getClass().getSimpleName();
    }

    private void setCooldown(EntityMaid maid, ISpell spell) {
        MaidGoetySpellData data = (MaidGoetySpellData)this.getData(maid);
        if (data != null && spell != null) {
            String spellId = this.getSpellId(spell);
            int cooldown = spell.defaultSpellCooldown();
            data.setSpellCooldown(spellId, cooldown, maid);
        }
    }

    private void stopSpellUnified(ISpell spell, ServerLevel serverLevel, EntityMaid maid, ItemStack focusBag, int remainingTime) {
        if (GoetyProvider.shouldUseNewAPI()) {
            ItemStack focus = FocusBagItemHandler.get((ItemStack)focusBag).getSlot();
            spell.stopSpell(serverLevel, (LivingEntity)maid, focusBag, focus, remainingTime, spell.defaultStats());
        } else {
            this.stopSpellOldAPI(spell, serverLevel, maid, focusBag, remainingTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void stopSpellOldAPI(ISpell spell, ServerLevel serverLevel, EntityMaid maid, ItemStack spellBook, int remainingTime) {
        try {
            if (!stopSpellMethodInitialized) {
                Class<GoetyProvider> clazz = GoetyProvider.class;
                // MONITORENTER : com.github.yimeng261.maidspell.spell.providers.GoetyProvider.class
                cachedStopSpellMethod = ISpell.class.getMethod("stopSpell", ServerLevel.class, LivingEntity.class, ItemStack.class, Integer.TYPE);
                LOGGER.debug("Successfully cached old version stopSpell method");
                stopSpellMethodInitialized = true;
                // MONITOREXIT : clazz
            }
            cachedStopSpellMethod.invoke((Object)spell, serverLevel, maid, spellBook, remainingTime);
            return;
        }
        catch (Exception e) {
            LOGGER.error("Error calling old version stopSpell method for spell {}: {}", (Object)spell.getClass().getSimpleName(), (Object)e.getMessage());
        }
    }
}

