/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.spell.providers;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.api.ISpellBookProvider;
import com.github.yimeng261.maidspell.spell.data.MaidPsiSpellData;
import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import org.slf4j.Logger;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.ISpellAcceptor;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.common.core.handler.PlayerDataHandler;
import vazkii.psi.common.item.ItemCAD;

public class PsiProvider
extends ISpellBookProvider<MaidPsiSpellData, Spell> {
    private static final Logger LOGGER = LogUtils.getLogger();

    public PsiProvider() {
        super(MaidPsiSpellData::getOrCreate, Spell.class);
    }

    @Override
    protected List<Spell> collectSpellFromSingleSpellBook(ItemStack spellBook, EntityMaid maid) {
        ArrayList<Spell> spells = new ArrayList<Spell>();
        if (spellBook == null || spellBook.m_41619_() || !this.isSpellBook(spellBook)) {
            return spells;
        }
        ISocketable sockets = (ISocketable)spellBook.getCapability(PsiAPI.SOCKETABLE_CAPABILITY).orElse(null);
        if (sockets == null) {
            return spells;
        }
        for (int i = 0; i <= sockets.getLastSlot(); ++i) {
            ISpellAcceptor spellContainer;
            Spell spell;
            ItemStack bullet;
            if (!sockets.isSocketSlotAvailable(i) || (bullet = sockets.getBulletInSocket(i)).m_41619_() || !ISpellAcceptor.hasSpell((ItemStack)bullet) || (spell = (spellContainer = ISpellAcceptor.acceptor((ItemStack)bullet)).getSpell()) == null) continue;
            spells.add(spell);
        }
        return spells;
    }

    @Override
    public boolean isSpellBook(ItemStack itemStack) {
        if (itemStack == null || itemStack.m_41619_()) {
            return false;
        }
        return itemStack.m_41720_() instanceof ICAD;
    }

    @Override
    public void initiateCasting(EntityMaid maid) {
        MaidPsiSpellData data = (MaidPsiSpellData)this.getData(maid);
        if (data == null) {
            return;
        }
        ItemStack cad = data.getSpellBook();
        if (!this.isSpellBook(cad)) {
            return;
        }
        ISocketable sockets = (ISocketable)cad.getCapability(PsiAPI.SOCKETABLE_CAPABILITY).orElse(null);
        ItemStack bullet = this.getRandomBulletFromMagazine(sockets, maid);
        if (bullet.m_41619_() || !ISpellAcceptor.hasSpell((ItemStack)bullet)) {
            return;
        }
        this.attemptCastSpell(maid, cad, bullet);
    }

    private ItemStack getRandomBulletFromMagazine(ISocketable sockets, EntityMaid maid) {
        ArrayList<ItemStack> validBullets = new ArrayList<ItemStack>();
        for (int i = 0; i <= sockets.getLastSlot(); ++i) {
            ItemStack bullet;
            if (!sockets.isSocketSlotAvailable(i) || (bullet = sockets.getBulletInSocket(i)).m_41619_() || !ISpellAcceptor.hasSpell((ItemStack)bullet)) continue;
            validBullets.add(bullet);
        }
        if (validBullets.isEmpty()) {
            return ItemStack.f_41583_;
        }
        int randomIndex = maid.m_217043_().m_188503_(validBullets.size());
        return (ItemStack)validBullets.get(randomIndex);
    }

    private boolean attemptCastSpell(EntityMaid maid, ItemStack cad, ItemStack bullet) {
        try {
            ISpellAcceptor spellContainer = ISpellAcceptor.acceptor((ItemStack)bullet);
            Spell spell = spellContainer.getSpell();
            if (spell == null) {
                return false;
            }
            String spellId = this.getSpellId(spell);
            MaidPsiSpellData data = (MaidPsiSpellData)this.getData(maid);
            if (data.isSpellOnCooldown(spellId)) {
                return false;
            }
            SpellContext context = this.createSpellContext(maid, spell);
            if (context == null || !context.isValid()) {
                return false;
            }
            if (context.caster != null) {
                this.setupVirtualPlayerData(context.caster);
            }
            if (!context.cspell.metadata.evaluateAgainst(cad)) {
                return false;
            }
            int cost = ItemCAD.getRealCost((ItemStack)cad, (ItemStack)bullet, (int)context.cspell.metadata.getStat(EnumSpellStat.COST));
            int cooldownTicks = this.calculateCooldownFromCost(cost);
            context.cspell.safeExecute(context);
            data.setCasting(true);
            data.setCurrentSpell(spell);
            data.setCastingTicks(20);
            data.setSpellCooldown(spellId, cooldownTicks, maid);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private int calculateCooldownFromCost(int cost) {
        return cost / 300 * 20;
    }

    private String getSpellId(Spell spell) {
        if (spell == null || spell.name == null) {
            return "unknown_spell";
        }
        return spell.name;
    }

    private SpellContext createSpellContext(EntityMaid maid, Spell spell) {
        try {
            SpellContext context = new SpellContext();
            Player caster = this.getValidCaster(maid);
            if (caster == null) {
                return null;
            }
            context.caster = caster;
            context.setFocalPoint((Entity)maid);
            context.setSpell(spell);
            context.castFrom = InteractionHand.MAIN_HAND;
            return context;
        }
        catch (Exception e) {
            return null;
        }
    }

    private Player getValidCaster(EntityMaid maid) {
        Level level = maid.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            try {
                FakePlayer fakePlayer = FakePlayerFactory.get((ServerLevel)serverLevel, (GameProfile)new GameProfile(UUID.randomUUID(), "MaidCaster_" + maid.m_20148_().toString().substring(0, 8)));
                fakePlayer.m_6034_(maid.m_20185_(), maid.m_20186_(), maid.m_20189_());
                fakePlayer.m_146922_(maid.m_146908_());
                fakePlayer.m_146926_(maid.m_146909_());
                return fakePlayer;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private void setupVirtualPlayerData(Player fakePlayer) {
        try {
            PlayerDataHandler.PlayerData playerData = PlayerDataHandler.get((Player)fakePlayer);
            playerData.availablePsi = Integer.MAX_VALUE;
            playerData.overflowed = false;
            playerData.regenCooldown = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void processContinuousCasting(EntityMaid maid) {
        MaidPsiSpellData data = (MaidPsiSpellData)this.getData(maid);
        if (data == null || !data.isCasting()) {
            return;
        }
        int remainingTicks = data.getCastingTicks() - 1;
        data.setCastingTicks(remainingTicks);
        if (remainingTicks <= 0) {
            data.setCasting(false);
            data.setCurrentSpell(null);
            data.setCastingTicks(0);
        }
    }

    @Override
    public void stopCasting(EntityMaid maid) {
        MaidPsiSpellData data = (MaidPsiSpellData)this.getData(maid);
        if (data != null) {
            data.setCasting(false);
            data.setCurrentSpell(null);
            data.setCastingTicks(0);
        }
    }
}

