/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.simplebedrockmodel.client.compat.sodium;

import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.api.vertex.format.common.ModelVertex;
import org.joml.Vector3f;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public interface ISodiumVertexWriter {
    public static final int STRIDE = 36;
    public static final int SIZE = 24;
    public static final long SCRATCH_BUFFER = MemoryUtil.nmemAlignedAlloc((long)64L, (long)864L);
    public static final int[] NORMALS = new int[6];

    default public void emitVertex(long ptr, float x, float y, float z, int color, float u, float v, int packedOverlay, int packedLight, int normal) {
        ModelVertex.write((long)ptr, (float)x, (float)y, (float)z, (int)color, (float)u, (float)v, (int)packedOverlay, (int)packedLight, (int)normal);
    }

    default public void flush(VertexBufferWriter writer, int vertexCount) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            writer.push(stack, SCRATCH_BUFFER, vertexCount, ModelVertex.FORMAT);
        }
    }

    default public int packNormal(float x, float y, float z) {
        int normX = (int)(x * 127.0f) & 0xFF;
        int normY = (int)(y * 127.0f) & 0xFF;
        int normZ = (int)(z * 127.0f) & 0xFF;
        return normZ << 16 | normY << 8 | normX;
    }

    default public void prepareNormals(Vector3f[] normals) {
        for (int i = 0; i < normals.length; ++i) {
            ISodiumVertexWriter.NORMALS[i] = this.packNormal(normals[i].x, normals[i].y, normals[i].z);
        }
    }
}

