/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.model.bedrock;

import com.github.tartaricacid.simplebedrockmodel.client.bedrock.AbstractBedrockEntityModel;
import com.github.tartaricacid.simplebedrockmodel.client.bedrock.model.BedrockPart;
import com.github.tartaricacid.simplebedrockmodel.client.bedrock.pojo.BedrockModelPOJO;
import com.github.tartaricacid.simplebedrockmodel.client.bedrock.pojo.BedrockVersion;
import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.client.animation.CustomJsAnimationManger;
import com.github.tartaricacid.touhoulittlemaid.client.animation.HardcodedAnimationManger;
import com.github.tartaricacid.touhoulittlemaid.client.animation.inner.IAnimation;
import com.github.tartaricacid.touhoulittlemaid.client.animation.script.EntityChairWrapper;
import com.github.tartaricacid.touhoulittlemaid.client.animation.script.EntityMaidWrapper;
import com.github.tartaricacid.touhoulittlemaid.client.animation.script.ModelRendererWrapper;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.script.Invocable;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BedrockModel<T extends LivingEntity>
extends AbstractBedrockEntityModel<T> {
    private final EntityMaidWrapper entityMaidWrapper = new EntityMaidWrapper();
    private final EntityChairWrapper entityChairWrapper = new EntityChairWrapper();
    protected final HashMap<String, ModelRendererWrapper> modelMapWrapper = Maps.newHashMap();
    private List<Object> animations = Lists.newArrayList();

    public BedrockModel() {
    }

    public BedrockModel(BedrockModelPOJO pojo, BedrockVersion version) {
        super(pojo, version);
        this.modelMap.forEach((key, model) -> this.modelMapWrapper.put((String)key, new ModelRendererWrapper((BedrockPart)model)));
    }

    @ParametersAreNonnullByDefault
    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (this.animations != null) {
            Invocable invocable = (Invocable)((Object)CustomJsAnimationManger.NASHORN);
            if (entityIn instanceof Mob) {
                Mob mob = (Mob)entityIn;
                IMaid maid = IMaid.convert(mob);
                if (maid != null) {
                    this.setupMaidAnim(maid, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, invocable);
                    HardcodedAnimationManger.playMaidAnimation(maid, this.modelMapWrapper, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                }
                return;
            }
            if (entityIn instanceof EntityChair) {
                this.setupChairAnim((EntityChair)((Object)entityIn), limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, invocable);
            }
        }
    }

    private void setupMaidAnim(IMaid entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, Invocable invocable) {
        try {
            for (Object animation : this.animations) {
                if (animation instanceof IAnimation) {
                    ((IAnimation)animation).setRotationAngles(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, 0.0f, entityIn.asEntity(), this.modelMapWrapper);
                    continue;
                }
                this.entityMaidWrapper.setData(entityIn, this.f_102608_, this.f_102609_);
                invocable.invokeMethod(animation, "animation", this.entityMaidWrapper, Float.valueOf(limbSwing), Float.valueOf(limbSwingAmount), Float.valueOf(ageInTicks), Float.valueOf(netHeadYaw), Float.valueOf(headPitch), Float.valueOf(0.0625f), this.modelMapWrapper);
                this.entityMaidWrapper.clearData();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            CustomPackLoader.MAID_MODELS.removeAnimation(entityIn.getModelId());
        }
    }

    private void setupChairAnim(EntityChair entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, Invocable invocable) {
        try {
            for (Object animation : this.animations) {
                if (animation instanceof IAnimation) {
                    ((IAnimation)animation).setRotationAngles(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, 0.0f, entityIn, this.modelMapWrapper);
                    continue;
                }
                this.entityChairWrapper.setData(entityIn);
                invocable.invokeMethod(animation, "animation", this.entityChairWrapper, Float.valueOf(limbSwing), Float.valueOf(limbSwingAmount), Float.valueOf(ageInTicks), Float.valueOf(netHeadYaw), Float.valueOf(headPitch), Float.valueOf(0.0625f), this.modelMapWrapper);
                this.entityChairWrapper.clearData();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            CustomPackLoader.CHAIR_MODELS.removeAnimation(entityIn.getModelId());
        }
    }

    public void translateToHand(HumanoidArm sideIn, PoseStack poseStack) {
        BedrockPart arm = this.getArm(sideIn);
        if (arm != null) {
            arm.translateAndRotate(poseStack);
        }
    }

    public boolean hasBackpackPositioningModel() {
        return this.modelMap.get("backpackPositioningBone") != null;
    }

    public BedrockPart getBackpackPositioningModel() {
        return (BedrockPart)this.modelMap.get("backpackPositioningBone");
    }

    @Nullable
    private BedrockPart getArm(HumanoidArm sideIn) {
        return sideIn == HumanoidArm.LEFT ? (BedrockPart)this.modelMap.get("armLeft") : (BedrockPart)this.modelMap.get("armRight");
    }

    public boolean hasHead() {
        return this.modelMap.containsKey("head");
    }

    public BedrockPart getHead() {
        return (BedrockPart)this.modelMap.get("head");
    }

    public boolean hasLeftArm() {
        return this.modelMap.containsKey("armLeft");
    }

    public BedrockPart getLeftArm() {
        return (BedrockPart)this.modelMap.get("armLeft");
    }

    public boolean hasRightArm() {
        return this.modelMap.containsKey("armRight");
    }

    public BedrockPart getRightArm() {
        return (BedrockPart)this.modelMap.get("armRight");
    }

    public boolean hasArmPositioningModel(HumanoidArm side) {
        BedrockPart arm = side == HumanoidArm.LEFT ? (BedrockPart)this.modelMap.get("armLeftPositioningBone") : (BedrockPart)this.modelMap.get("armRightPositioningBone");
        return arm != null;
    }

    @Nullable
    public BedrockPart getArmPositioningModel(HumanoidArm side) {
        return side == HumanoidArm.LEFT ? (BedrockPart)this.modelMap.get("armLeftPositioningBone") : (BedrockPart)this.modelMap.get("armRightPositioningBone");
    }

    public void translateToPositioningHand(HumanoidArm sideIn, PoseStack poseStack) {
        BedrockPart arm;
        BedrockPart bedrockPart = arm = sideIn == HumanoidArm.LEFT ? (BedrockPart)this.modelMap.get("armLeftPositioningBone") : (BedrockPart)this.modelMap.get("armRightPositioningBone");
        if (arm != null) {
            arm.translateAndRotate(poseStack);
        }
    }

    public boolean hasWaistPositioningModel(HumanoidArm side) {
        BedrockPart waist = side == HumanoidArm.LEFT ? (BedrockPart)this.modelMap.get("waistLeftPositioningBone") : (BedrockPart)this.modelMap.get("waistRightPositioningBone");
        return waist != null;
    }

    public void translateToPositioningWaist(HumanoidArm sideIn, PoseStack poseStack) {
        BedrockPart waist;
        BedrockPart bedrockPart = waist = sideIn == HumanoidArm.LEFT ? (BedrockPart)this.modelMap.get("waistLeftPositioningBone") : (BedrockPart)this.modelMap.get("waistRightPositioningBone");
        if (waist != null) {
            waist.translateAndRotate(poseStack);
        }
    }

    public void setAnimations(@Nullable List<Object> animations) {
        this.animations = animations;
    }
}

