/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.geckolayer;

import com.github.tartaricacid.simplebedrockmodel.client.bedrock.model.BedrockPart;
import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.SimpleBedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.BedrockModelLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.GeoLayerRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.IGeoEntityRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.animated.ILocationModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.RenderUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.Holder;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BannerPattern;

public class GeckoLayerMaidBanner<T extends Mob, R extends IGeoEntityRenderer<T>>
extends GeoLayerRenderer<T, R> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("touhou_little_maid", "textures/bedrock/entity/maid_banner.png");
    private final SimpleBedrockModel<EntityMaid> bannerModel;
    private final EntityModelSet modelSet;

    public GeckoLayerMaidBanner(R renderer, EntityModelSet modelSet) {
        super(renderer);
        this.modelSet = modelSet;
        this.bannerModel = Objects.requireNonNull(BedrockModelLoader.getModel(BedrockModelLoader.MAID_BANNER));
    }

    @Override
    public GeoLayerRenderer<T, R> copy(R entityRendererIn) {
        return new GeckoLayerMaidBanner<T, R>(entityRendererIn, this.modelSet);
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource bufferIn, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        Item item;
        EntityMaid maid = IMaid.convertToMaid(entity);
        if (maid == null || !((item = maid.getBackpackShowItem().m_41720_()) instanceof BannerItem)) {
            return;
        }
        BannerItem bannerItem = (BannerItem)item;
        if (!this.getGeoEntity(entity).getMaidInfo().isShowBackpack() || entity.m_5803_() || entity.m_20145_()) {
            return;
        }
        if (!maid.getConfigManager().isShowBackItem()) {
            return;
        }
        ILocationModel geoModel = this.getLocationModel(entity);
        if (geoModel != null && !geoModel.backpackBones().isEmpty()) {
            poseStack.m_85836_();
            RenderUtils.prepMatrixForLocator(poseStack, geoModel.backpackBones());
            poseStack.m_85837_(0.0, 0.75, 0.3);
            poseStack.m_85841_(0.65f, -0.65f, -0.65f);
            poseStack.m_252781_(Axis.f_252392_.m_252977_(180.0f));
            poseStack.m_252781_(Axis.f_252495_.m_252977_(5.0f));
            VertexConsumer buffer = bufferIn.m_6299_(RenderType.m_110446_((ResourceLocation)TEXTURE));
            this.bannerModel.m_7695_(poseStack, buffer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            List list = BannerBlockEntity.m_58484_((DyeColor)bannerItem.m_40545_(), (ListTag)BannerBlockEntity.m_58487_((ItemStack)maid.getBackpackShowItem()));
            this.renderPatterns(poseStack, bufferIn, packedLight, this.bannerModel.getPart("banner"), list);
            poseStack.m_85849_();
        }
    }

    private void renderPatterns(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, BedrockPart banner, List<Pair<Holder<BannerPattern>, DyeColor>> patterns) {
        banner.render(poseStack, ModelBakery.f_119224_.m_119197_(bufferSource, RenderType::m_110446_, false), packedLight, OverlayTexture.f_118083_);
        for (int index = 0; index < 17 && index < patterns.size(); ++index) {
            Pair<Holder<BannerPattern>, DyeColor> patternPair = patterns.get(index);
            float[] colorComponents = ((DyeColor)patternPair.getSecond()).m_41068_();
            ((Holder)patternPair.getFirst()).m_203543_().map(Sheets::m_234347_).ifPresent(material -> banner.render(poseStack, material.m_119194_(bufferSource, RenderType::m_110482_), packedLight, OverlayTexture.f_118083_, colorComponents[0], colorComponents[1], colorComponents[2], 1.0f));
        }
    }
}

