/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.geckolayer;

import com.github.tartaricacid.touhoulittlemaid.compat.carryon.RenderFixer;
import com.github.tartaricacid.touhoulittlemaid.compat.slashblade.SlashBladeCompat;
import com.github.tartaricacid.touhoulittlemaid.compat.slashblade.SlashBladeRender;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.processor.ILocationBone;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.GeoLayerRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.IGeoEntityRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.animated.ILocationModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.RenderUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class GeckoLayerMaidHeld<T extends Mob, R extends IGeoEntityRenderer<T>>
extends GeoLayerRenderer<T, R> {
    private final ItemInHandRenderer itemInHandRenderer;

    public GeckoLayerMaidHeld(R entityRendererIn, ItemInHandRenderer itemInHandRenderer) {
        super(entityRendererIn);
        this.itemInHandRenderer = itemInHandRenderer;
    }

    @Override
    public GeoLayerRenderer<T, R> copy(R entityRendererIn) {
        return new GeckoLayerMaidHeld<T, R>(entityRendererIn, this.itemInHandRenderer);
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack offhandItem = entity.m_21206_();
        ItemStack mainHandItem = entity.m_21205_();
        ILocationModel geoModel = this.getLocationModel(entity);
        if (geoModel == null) {
            return;
        }
        if (!offhandItem.m_41619_() || !mainHandItem.m_41619_()) {
            poseStack.m_85836_();
            if (!geoModel.rightHandBones().isEmpty() && !RenderFixer.isCarryOnRender(mainHandItem, buffer)) {
                if (SlashBladeCompat.isSlashBladeItem(mainHandItem)) {
                    SlashBladeRender.renderMaidMainhandSlashBlade(entity, geoModel, poseStack, buffer, packedLight, mainHandItem, partialTicks);
                } else {
                    this.renderArmWithItem(entity, mainHandItem, geoModel, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, HumanoidArm.RIGHT, poseStack, buffer, packedLight);
                }
            }
            if (!geoModel.leftHandBones().isEmpty() && !RenderFixer.isCarryOnRender(offhandItem, buffer)) {
                if (SlashBladeCompat.isSlashBladeItem(offhandItem)) {
                    SlashBladeRender.renderMaidOffhandSlashBlade(geoModel, poseStack, buffer, packedLight, offhandItem);
                } else {
                    this.renderArmWithItem(entity, offhandItem, geoModel, ItemDisplayContext.THIRD_PERSON_LEFT_HAND, HumanoidArm.LEFT, poseStack, buffer, packedLight);
                }
            }
            poseStack.m_85849_();
        }
    }

    protected void renderArmWithItem(T livingEntity, ItemStack itemStack, ILocationModel geoModel, ItemDisplayContext displayContext, HumanoidArm arm, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        if (!itemStack.m_41619_() && geoModel != null) {
            boolean isLeftHand = arm == HumanoidArm.LEFT;
            poseStack.m_85836_();
            boolean scaleResult = this.translateToHand(arm, poseStack, geoModel);
            if (!scaleResult) {
                poseStack.m_85837_(0.0, -0.0625, -0.1);
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                this.itemInHandRenderer.m_269530_(livingEntity, itemStack, displayContext, isLeftHand, poseStack, bufferSource, light);
            }
            poseStack.m_85849_();
            List<List<? extends ILocationBone>> extraBones = isLeftHand ? geoModel.extraLeftHandBones() : geoModel.extraRightHandBones();
            extraBones.forEach(bones -> {
                poseStack.m_85836_();
                boolean extraScaleResult = RenderUtils.prepMatrixForLocator(poseStack, bones);
                if (!extraScaleResult) {
                    poseStack.m_85837_(0.0, -0.0625, -0.1);
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                    this.itemInHandRenderer.m_269530_((LivingEntity)livingEntity, itemStack, displayContext, isLeftHand, poseStack, bufferSource, light);
                }
                poseStack.m_85849_();
            });
        }
    }

    protected boolean translateToHand(HumanoidArm arm, PoseStack poseStack, ILocationModel geoModel) {
        if (arm == HumanoidArm.LEFT) {
            return RenderUtils.prepMatrixForLocator(poseStack, geoModel.leftHandBones());
        }
        return RenderUtils.prepMatrixForLocator(poseStack, geoModel.rightHandBones());
    }
}

