/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;

public class MaidAttackStrafingTask
extends Behavior<EntityMaid> {
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;

    public MaidAttackStrafingTask() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_148205_, (Object)MemoryStatus.VALUE_PRESENT), 1200);
    }

    protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid owner) {
        return owner.m_21205_().m_41720_() instanceof ProjectileWeaponItem && owner.m_6274_().m_21952_(MemoryModuleType.f_26372_).filter(Entity::m_6084_).isPresent();
    }

    protected void tick(ServerLevel worldIn, EntityMaid owner, long gameTime) {
        ItemStack stack = owner.m_21205_();
        if (!(stack.m_41720_() instanceof ProjectileWeaponItem)) {
            return;
        }
        owner.m_6274_().m_21952_(MemoryModuleType.f_26372_).ifPresent(target -> {
            int maxAttackDistance = ((ProjectileWeaponItem)stack.m_41720_()).m_6615_();
            double distance = owner.m_20270_((Entity)target);
            this.strafingTime = distance < (double)owner.searchRadius() ? ++this.strafingTime : -1;
            if (this.strafingTime >= 20) {
                if ((double)owner.m_217043_().m_188501_() < 0.3) {
                    boolean bl = this.strafingClockwise = !this.strafingClockwise;
                }
                if ((double)owner.m_217043_().m_188501_() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                Player player;
                LivingEntity patt3304$temp;
                if (distance > (double)maxAttackDistance * 0.5) {
                    this.strafingBackwards = false;
                } else if (distance < (double)maxAttackDistance * 0.2) {
                    this.strafingBackwards = true;
                }
                if (!owner.m_21536_() && (patt3304$temp = owner.m_269323_()) instanceof Player && owner.m_20270_((Entity)(player = (Player)patt3304$temp)) >= owner.m_21535_()) {
                    this.stopInPlace(owner);
                } else {
                    owner.m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                }
                owner.m_146922_(Mth.m_14094_((float)owner.m_146908_(), (float)owner.f_20885_, (float)0.0f));
                BehaviorUtils.m_22595_((LivingEntity)owner, (LivingEntity)target);
            } else {
                BehaviorUtils.m_22595_((LivingEntity)owner, (LivingEntity)target);
            }
        });
    }

    protected void start(ServerLevel worldIn, EntityMaid entityIn, long gameTimeIn) {
        entityIn.setSwingingArms(true);
    }

    protected void stop(ServerLevel worldIn, EntityMaid entityIn, long gameTimeIn) {
        entityIn.setSwingingArms(false);
        entityIn.m_21566_().m_24988_(0.0f, 0.0f);
    }

    protected boolean canStillUse(ServerLevel worldIn, EntityMaid entityIn, long gameTimeIn) {
        return this.checkExtraStartConditions(worldIn, entityIn);
    }

    private void stopInPlace(EntityMaid maid) {
        maid.m_21573_().m_26573_();
        maid.m_21570_(0.0f);
        maid.m_21567_(0.0f);
        maid.m_7910_(0.0f);
    }
}

