/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.passive;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Slime;

public final class MaidKillRecordManager {
    private static final String KILL_RECORD = "KillRecord";
    private static final String TOTAL_COUNT = "TotalCount";
    private static final String SLIME_COUNT = "Slime";
    private static final String WITHER_COUNT = "Wither";
    private static final String ENDER_DRAGON_COUNT = "EnderDragon";
    private int totalCount;
    private int slimeCount;
    private int witherCount;
    private int enderDragonCount;

    void addAdditionalSaveData(CompoundTag compound) {
        CompoundTag killRecord = new CompoundTag();
        killRecord.m_128405_(KILL_RECORD, this.totalCount);
        killRecord.m_128405_(SLIME_COUNT, this.slimeCount);
        killRecord.m_128405_(WITHER_COUNT, this.witherCount);
        killRecord.m_128405_(ENDER_DRAGON_COUNT, this.enderDragonCount);
        compound.m_128365_(KILL_RECORD, (Tag)killRecord);
    }

    void readAdditionalSaveData(CompoundTag compound) {
        if (compound.m_128441_(KILL_RECORD)) {
            CompoundTag killRecord = compound.m_128469_(KILL_RECORD);
            this.totalCount = killRecord.m_128451_(TOTAL_COUNT);
            this.slimeCount = killRecord.m_128451_(SLIME_COUNT);
            this.witherCount = killRecord.m_128451_(WITHER_COUNT);
            this.enderDragonCount = killRecord.m_128451_(ENDER_DRAGON_COUNT);
        }
    }

    public void onTargetDeath(EntityMaid maid, LivingEntity target) {
        LivingEntity owner = maid.m_269323_();
        ++this.totalCount;
        this.triggerKill(owner, "maid_kill_mob");
        if (this.totalCount >= 100) {
            this.triggerKill(owner, "kill_100");
        }
        if (target instanceof Slime) {
            ++this.slimeCount;
            if (this.slimeCount >= 300) {
                this.triggerKill(owner, "kill_slime_300");
            }
        }
        if (target instanceof WitherBoss) {
            ++this.witherCount;
            this.triggerKill(owner, "kill_wither");
        }
        if (target instanceof EnderDragon) {
            ++this.enderDragonCount;
            this.triggerKill(owner, "kill_dragon");
        }
    }

    private void triggerKill(@Nullable LivingEntity owner, String eventName) {
        if (owner instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)owner;
            InitTrigger.MAID_EVENT.trigger(serverPlayer, eventName);
        }
    }
}

