/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IRangedAttackTask;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidAttackTridentTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidRangedWalkToTarget;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidTridentTargetTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.phys.AABB;

public class TaskTridentAttack
implements IRangedAttackTask {
    public static final ResourceLocation UID = new ResourceLocation("touhou_little_maid", "trident_attack");

    @Override
    public ResourceLocation getUid() {
        return UID;
    }

    @Override
    public ItemStack getIcon() {
        return Items.f_42713_.m_7968_();
    }

    @Override
    @Nullable
    public SoundEvent getAmbientSound(EntityMaid maid) {
        return SoundUtil.attackSound(maid, (SoundEvent)InitSounds.MAID_RANGE_ATTACK.get(), 0.5f);
    }

    @Override
    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        BehaviorControl supplementedTask = StartAttacking.m_257741_(this::hasTrident, IRangedAttackTask::findFirstValidAttackTarget);
        BehaviorControl findTargetTask = StopAttackingIfTargetInvalid.m_257990_(target -> !this.hasTrident(maid) || this.farAway((LivingEntity)target, maid));
        BehaviorControl<EntityMaid> moveToTargetTask = MaidRangedWalkToTarget.create(0.6f);
        MaidAttackTridentTask maidAttackStrafingTask = new MaidAttackTridentTask();
        MaidTridentTargetTask shootTargetTask = new MaidTridentTargetTask();
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)supplementedTask), Pair.of((Object)5, (Object)findTargetTask), Pair.of((Object)5, moveToTargetTask), Pair.of((Object)5, (Object)((Object)maidAttackStrafingTask)), Pair.of((Object)5, (Object)((Object)shootTargetTask))});
    }

    @Override
    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createRideBrainTasks(EntityMaid maid) {
        BehaviorControl supplementedTask = StartAttacking.m_257741_(this::hasTrident, IRangedAttackTask::findFirstValidAttackTarget);
        BehaviorControl findTargetTask = StopAttackingIfTargetInvalid.m_257990_(target -> !this.hasTrident(maid) || this.farAway((LivingEntity)target, maid));
        MaidTridentTargetTask shootTargetTask = new MaidTridentTargetTask();
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)supplementedTask), Pair.of((Object)5, (Object)findTargetTask), Pair.of((Object)5, (Object)((Object)shootTargetTask))});
    }

    @Override
    public boolean canSee(EntityMaid maid, LivingEntity target) {
        return IRangedAttackTask.targetConditionsTest(maid, target, MaidConfig.TRIDENT_RANGE);
    }

    @Override
    public AABB searchDimension(EntityMaid maid) {
        if (this.hasTrident(maid)) {
            float searchRange = this.searchRadius(maid);
            if (maid.m_21536_()) {
                return new AABB(maid.m_21534_()).m_82400_((double)searchRange);
            }
            return maid.m_20191_().m_82400_((double)searchRange);
        }
        return IRangedAttackTask.super.searchDimension(maid);
    }

    @Override
    public float searchRadius(EntityMaid maid) {
        return ((Integer)MaidConfig.TRIDENT_RANGE.get()).intValue();
    }

    @Override
    public void performRangedAttack(EntityMaid shooter, LivingEntity target, float distanceFactor) {
        ItemStack tridentItem = shooter.m_21205_().m_41777_();
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)tridentItem);
        if (!enchantments.isEmpty() && enchantments.containsKey(Enchantments.f_44955_)) {
            enchantments.remove(Enchantments.f_44955_);
            EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)tridentItem);
        }
        ThrownTrident thrownTrident = new ThrownTrident(shooter.f_19853_, (LivingEntity)shooter, tridentItem);
        double x = target.m_20185_() - shooter.m_20185_();
        double y = target.m_20188_() - shooter.m_20188_();
        double z = target.m_20189_() - shooter.m_20189_();
        float distance = shooter.m_20270_((Entity)target);
        float velocity = Mth.m_14036_((float)(distance / 10.0f), (float)1.6f, (float)3.2f);
        float inaccuracy = 1.0f - Mth.m_14036_((float)(distance / 100.0f), (float)0.0f, (float)0.9f);
        thrownTrident.m_20242_(true);
        thrownTrident.m_6686_(x, y, z, velocity, inaccuracy);
        thrownTrident.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
        shooter.m_21205_().m_41622_(1, (LivingEntity)shooter, maid -> maid.m_21190_(InteractionHand.MAIN_HAND));
        shooter.f_19853_.m_7967_((Entity)thrownTrident);
        shooter.m_5496_(SoundEvents.f_12520_, 1.0f, 1.0f);
    }

    @Override
    public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(EntityMaid maid) {
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"has_trident", this::hasTrident)});
    }

    @Override
    public boolean isWeapon(EntityMaid maid, ItemStack stack) {
        return stack.m_41720_() instanceof TridentItem;
    }

    private boolean farAway(LivingEntity target, EntityMaid maid) {
        return maid.m_20270_((Entity)target) > this.searchRadius(maid);
    }

    private boolean hasTrident(EntityMaid maid) {
        return maid.m_21205_().m_41720_() instanceof TridentItem;
    }
}

