/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.event;

import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.capability.ChatTokensCapability;
import com.github.tartaricacid.touhoulittlemaid.capability.ChatTokensCapabilityProvider;
import com.github.tartaricacid.touhoulittlemaid.capability.GeckoMaidEntityCapabilityProvider;
import com.github.tartaricacid.touhoulittlemaid.capability.MaidNumCapability;
import com.github.tartaricacid.touhoulittlemaid.capability.MaidNumCapabilityProvider;
import com.github.tartaricacid.touhoulittlemaid.capability.PowerCapability;
import com.github.tartaricacid.touhoulittlemaid.capability.PowerCapabilityProvider;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MiscConfig;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.SyncCapabilityMessage;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public final class CapabilityEvent {
    private static final ResourceLocation POWER_CAP = new ResourceLocation("touhou_little_maid", "power");
    private static final ResourceLocation MAID_NUM_CAP = new ResourceLocation("touhou_little_maid", "maid_num");
    private static final ResourceLocation GECKO_MAID_CAP = new ResourceLocation("touhou_little_maid", "gecko_maid");
    private static final ResourceLocation CHAT_TOKENS_CAP = new ResourceLocation("touhou_little_maid", "chat_tokens");

    @SubscribeEvent
    public static void onAttachCapabilityEvent(AttachCapabilitiesEvent<Entity> event) {
        Mob mob;
        IMaid maid;
        Entity entity = (Entity)event.getObject();
        if (entity instanceof Player) {
            event.addCapability(POWER_CAP, (ICapabilityProvider)new PowerCapabilityProvider());
            event.addCapability(MAID_NUM_CAP, (ICapabilityProvider)new MaidNumCapabilityProvider());
            event.addCapability(CHAT_TOKENS_CAP, (ICapabilityProvider)new ChatTokensCapabilityProvider());
        } else if (entity.f_19853_.m_5776_() && entity instanceof Mob && (maid = IMaid.convert(mob = (Mob)entity)) != null) {
            event.addCapability(GECKO_MAID_CAP, new GeckoMaidEntityCapabilityProvider<Mob>(mob, maid));
        }
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        Player original = event.getOriginal();
        Player newPlayer = event.getEntity();
        original.reviveCaps();
        LazyOptional<PowerCapability> oldPowerCap = CapabilityEvent.getPowerCap(original);
        LazyOptional<PowerCapability> newPowerCap = CapabilityEvent.getPowerCap(newPlayer);
        newPowerCap.ifPresent(newPower -> oldPowerCap.ifPresent(oldPower -> {
            boolean keep = ((GameRules.BooleanValue)newPlayer.f_19853_.m_46469_().m_46170_(GameRules.f_46133_)).m_46223_();
            if (event.isWasDeath() && !keep) {
                newPower.set(oldPower.get() - ((Double)MiscConfig.PLAYER_DEATH_LOSS_POWER_POINT.get()).floatValue());
            } else {
                newPower.set(oldPower.get());
            }
        }));
        LazyOptional<MaidNumCapability> oldMaidNumCap = CapabilityEvent.getMaidNumCap(original);
        LazyOptional<MaidNumCapability> newMaidNumCap = CapabilityEvent.getMaidNumCap(newPlayer);
        newMaidNumCap.ifPresent(newMaidNum -> oldMaidNumCap.ifPresent(oldMaidNum -> newMaidNum.set(oldMaidNum.get())));
        LazyOptional<ChatTokensCapability> oldChatTokensCap = CapabilityEvent.getChatTokensCap(original);
        LazyOptional<ChatTokensCapability> newChatTokensCap = CapabilityEvent.getChatTokensCap(newPlayer);
        newChatTokensCap.ifPresent(newChatTokens -> oldChatTokensCap.ifPresent(oldChatTokens -> newChatTokens.setCount(oldChatTokens.getCount())));
        original.invalidateCaps();
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            CapabilityEvent.getPowerCap(player).ifPresent(PowerCapability::markDirty);
            CapabilityEvent.getMaidNumCap(player).ifPresent(MaidNumCapability::markDirty);
        }
    }

    @SubscribeEvent
    public static void playerTickEvent(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.END) {
            CapabilityEvent.getPowerCap(player).ifPresent(power -> CapabilityEvent.getMaidNumCap(player).ifPresent(maidNum -> {
                if (power.isDirty() || maidNum.isDirty()) {
                    NetworkHandler.sendToClientPlayer(new SyncCapabilityMessage(power.get(), maidNum.get()), player);
                    power.setDirty(false);
                    maidNum.setDirty(false);
                }
            }));
        }
    }

    private static LazyOptional<MaidNumCapability> getMaidNumCap(Player player) {
        return player.getCapability(MaidNumCapabilityProvider.MAID_NUM_CAP);
    }

    private static LazyOptional<PowerCapability> getPowerCap(Player player) {
        return player.getCapability(PowerCapabilityProvider.POWER_CAP);
    }

    private static LazyOptional<ChatTokensCapability> getChatTokensCap(Player player) {
        return player.getCapability(ChatTokensCapabilityProvider.CHAT_TOKENS_CAP);
    }
}

