/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.inventory.tooltip.BoardStateTooltip;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;

public class ItemBoardState
extends Item {
    public static final String DATA_TAG = "BoardStateData";
    public static final String DESC_TAG = "BoardStateDesc";
    public static final String AUTHOR_TAG = "BoardStateAuthor";

    public ItemBoardState() {
        super(new Item.Properties());
    }

    public static void setState(ItemStack stack, String data, String desc, String author) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_(DATA_TAG, data);
        tag.m_128359_(DESC_TAG, desc);
        tag.m_128359_(AUTHOR_TAG, author);
    }

    @Nullable
    public static String[] getState(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return null;
        }
        if (!tag.m_128425_(DATA_TAG, 8)) {
            return null;
        }
        return new String[]{tag.m_128461_(DATA_TAG), tag.m_128461_(DESC_TAG), tag.m_128461_(AUTHOR_TAG)};
    }

    @OnlyIn(value=Dist.CLIENT)
    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        if (!Screen.m_96638_()) {
            return Optional.empty();
        }
        String[] state = ItemBoardState.getState(stack);
        if (state == null) {
            return Optional.empty();
        }
        String stateData = state[0];
        if (StringUtils.isBlank((CharSequence)stateData)) {
            return Optional.empty();
        }
        if (stack.m_150930_((Item)InitItems.GOMOKU_BOARD_STATE.get())) {
            return Optional.of(BoardStateTooltip.ofGomoku(stateData));
        }
        if (stack.m_150930_((Item)InitItems.CCHESS_BOARD_STATE.get())) {
            return Optional.of(BoardStateTooltip.ofXiangqi(stateData));
        }
        if (stack.m_150930_((Item)InitItems.WCHESS_BOARD_STATE.get())) {
            return Optional.of(BoardStateTooltip.ofChess(stateData));
        }
        return Optional.empty();
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        String author;
        String[] state = ItemBoardState.getState(stack);
        if (state == null) {
            tooltip.add((Component)Component.m_237115_((String)"tooltips.touhou_little_maid.board_state.empty").m_130940_(ChatFormatting.GRAY));
            return;
        }
        String descKey = state[1];
        if (StringUtils.isNotBlank((CharSequence)descKey)) {
            tooltip.add((Component)Component.m_237115_((String)descKey).m_130940_(ChatFormatting.GRAY));
        }
        if (StringUtils.isNotBlank((CharSequence)(author = state[2]))) {
            tooltip.add((Component)Component.m_237110_((String)"tooltips.touhou_little_maid.board_state.author", (Object[])new Object[]{author}).m_130940_(ChatFormatting.GRAY));
        }
        if (!Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"board_state.touhou_little_maid.show_picture").m_130940_(ChatFormatting.DARK_GRAY).m_130940_(ChatFormatting.ITALIC));
        }
    }
}

