/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class ItemKappaCompass
extends Item {
    public ItemKappaCompass() {
        super(new Item.Properties().m_41487_(1));
    }

    public static void addPoint(Activity activity, BlockPos pos, ItemStack compass) {
        CompoundTag tag = compass.m_41698_("KappaCompassData");
        tag.m_128365_(activity.m_37998_(), (Tag)NbtUtils.m_129224_((BlockPos)pos));
    }

    public static void addDimension(ResourceLocation dimension, ItemStack compass) {
        CompoundTag tag = compass.m_41698_("KappaCompassData");
        tag.m_128359_("Dimension", dimension.toString());
    }

    @Nullable
    public static BlockPos getPoint(Activity activity, ItemStack compass) {
        CompoundTag tag = compass.m_41737_("KappaCompassData");
        if (tag != null) {
            String name = activity.m_37998_();
            if (tag.m_128425_(name, 10)) {
                return NbtUtils.m_129239_((CompoundTag)tag.m_128469_(name));
            }
            name = Activity.f_37979_.m_37998_();
            if (tag.m_128425_(name, 10)) {
                return NbtUtils.m_129239_((CompoundTag)tag.m_128469_(name));
            }
            name = Activity.f_37980_.m_37998_();
            if (tag.m_128425_(name, 10)) {
                return NbtUtils.m_129239_((CompoundTag)tag.m_128469_(name));
            }
        }
        return null;
    }

    @Nullable
    public static ResourceLocation getDimension(ItemStack compass) {
        CompoundTag tag = compass.m_41737_("KappaCompassData");
        if (tag != null) {
            return new ResourceLocation(tag.m_128461_("Dimension"));
        }
        return null;
    }

    public static int getRecordCount(ItemStack compass) {
        CompoundTag tag = compass.m_41737_("KappaCompassData");
        int count = 0;
        if (tag != null) {
            if (tag.m_128425_(Activity.f_37980_.m_37998_(), 10)) {
                ++count;
            }
            if (tag.m_128425_(Activity.f_37979_.m_37998_(), 10)) {
                ++count;
            }
            if (tag.m_128425_(Activity.f_37982_.m_37998_(), 10)) {
                ++count;
            }
        }
        return count;
    }

    public static boolean hasKappaCompassData(ItemStack compass) {
        return compass.m_41737_("KappaCompassData") != null;
    }

    public InteractionResult m_6880_(ItemStack compass, Player player, LivingEntity livingEntity, InteractionHand hand) {
        if (livingEntity instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)livingEntity;
            if (!maid.f_19853_.f_46443_) {
                if (player.m_20163_()) {
                    maid.getSchedulePos().clear(maid);
                    player.m_213846_((Component)Component.m_237115_((String)"message.touhou_little_maid.kappa_compass.maid_clear"));
                    player.f_19853_.m_5594_(null, player.m_20183_(), (SoundEvent)InitSounds.COMPASS_POINT.get(), SoundSource.PLAYERS, 0.8f, 1.5f);
                    return InteractionResult.SUCCESS;
                }
                CompoundTag tag = compass.m_41737_("KappaCompassData");
                ResourceLocation dimension = ItemKappaCompass.getDimension(compass);
                if (tag != null || dimension != null) {
                    if (!maid.f_19853_.m_46472_().m_135782_().equals((Object)dimension)) {
                        player.m_213846_((Component)Component.m_237115_((String)"message.touhou_little_maid.kappa_compass.maid_dimension_check"));
                        return InteractionResult.CONSUME;
                    }
                    maid.getSchedulePos().setDimension(dimension);
                    BlockPos point = ItemKappaCompass.getPoint(Activity.f_37980_, compass);
                    if (point != null) {
                        maid.getSchedulePos().setWorkPos(point);
                    }
                    if ((point = ItemKappaCompass.getPoint(Activity.f_37979_, compass)) != null) {
                        maid.getSchedulePos().setIdlePos(point);
                    }
                    if ((point = ItemKappaCompass.getPoint(Activity.f_37982_, compass)) != null) {
                        maid.getSchedulePos().setSleepPos(point);
                    }
                    maid.getSchedulePos().setConfigured(true);
                    maid.getSchedulePos().restrictTo(maid);
                    player.m_213846_((Component)Component.m_237115_((String)"message.touhou_little_maid.kappa_compass.maid_write"));
                    player.f_19853_.m_5594_(null, player.m_20183_(), (SoundEvent)InitSounds.COMPASS_POINT.get(), SoundSource.PLAYERS, 0.8f, 1.5f);
                    return InteractionResult.SUCCESS;
                }
                player.m_213846_((Component)Component.m_237115_((String)"message.touhou_little_maid.kappa_compass.no_data"));
                return InteractionResult.CONSUME;
            }
        }
        return super.m_6880_(compass, player, livingEntity, hand);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        ItemStack compass = context.m_43722_();
        BlockPos clickedPos = context.m_8083_();
        if (player == null || context.m_43725_().f_46443_) {
            return super.m_6225_(context);
        }
        if (player.m_20163_()) {
            compass.m_41749_("KappaCompassData");
            player.m_213846_((Component)Component.m_237115_((String)"message.touhou_little_maid.kappa_compass.clear"));
        } else {
            ResourceLocation dimension = ItemKappaCompass.getDimension(compass);
            int recordCount = ItemKappaCompass.getRecordCount(compass);
            if (recordCount >= 3) {
                player.m_213846_((Component)Component.m_237115_((String)"message.touhou_little_maid.kappa_compass.full"));
            } else if (recordCount == 2) {
                BlockPos idlePos = ItemKappaCompass.getPoint(Activity.f_37979_, compass);
                if (idlePos != null && idlePos.m_123331_((Vec3i)clickedPos) > 4096.0) {
                    player.m_213846_((Component)Component.m_237115_((String)"message.touhou_little_maid.kappa_compass.far_away"));
                    return super.m_6225_(context);
                }
                if (dimension != null && !player.f_19853_.m_46472_().m_135782_().equals((Object)dimension)) {
                    player.m_213846_((Component)Component.m_237115_((String)"message.touhou_little_maid.kappa_compass.diff_dimension"));
                    return super.m_6225_(context);
                }
                ItemKappaCompass.addPoint(Activity.f_37982_, clickedPos, compass);
                player.m_213846_((Component)Component.m_237110_((String)"message.touhou_little_maid.kappa_compass.sleep", (Object[])new Object[]{clickedPos.m_123341_(), clickedPos.m_123342_(), clickedPos.m_123343_()}));
            } else if (recordCount == 1) {
                BlockPos workPos = ItemKappaCompass.getPoint(Activity.f_37980_, compass);
                if (workPos != null && workPos.m_123331_((Vec3i)clickedPos) > 4096.0) {
                    player.m_213846_((Component)Component.m_237115_((String)"message.touhou_little_maid.kappa_compass.far_away"));
                    return super.m_6225_(context);
                }
                if (dimension != null && !player.f_19853_.m_46472_().m_135782_().equals((Object)dimension)) {
                    player.m_213846_((Component)Component.m_237115_((String)"message.touhou_little_maid.kappa_compass.diff_dimension"));
                    return super.m_6225_(context);
                }
                ItemKappaCompass.addPoint(Activity.f_37979_, clickedPos, compass);
                player.m_213846_((Component)Component.m_237110_((String)"message.touhou_little_maid.kappa_compass.idle", (Object[])new Object[]{clickedPos.m_123341_(), clickedPos.m_123342_(), clickedPos.m_123343_()}));
            } else {
                ItemKappaCompass.addPoint(Activity.f_37980_, clickedPos, compass);
                player.m_213846_((Component)Component.m_237110_((String)"message.touhou_little_maid.kappa_compass.work", (Object[])new Object[]{clickedPos.m_123341_(), clickedPos.m_123342_(), clickedPos.m_123343_()}));
            }
            ItemKappaCompass.addDimension(player.f_19853_.m_46472_().m_135782_(), compass);
        }
        player.f_19853_.m_5594_(null, player.m_20183_(), (SoundEvent)InitSounds.COMPASS_POINT.get(), SoundSource.PLAYERS, 0.8f, 1.5f);
        return InteractionResult.SUCCESS;
    }

    public void m_7373_(ItemStack stack, @Nullable Level pLevel, List<Component> components, TooltipFlag pIsAdvanced) {
        if (ItemKappaCompass.hasKappaCompassData(stack)) {
            ResourceLocation dimension = ItemKappaCompass.getDimension(stack);
            BlockPos workPos = ItemKappaCompass.getPoint(Activity.f_37980_, stack);
            BlockPos idlePos = ItemKappaCompass.getPoint(Activity.f_37979_, stack);
            BlockPos sleepPos = ItemKappaCompass.getPoint(Activity.f_37982_, stack);
            if (dimension != null) {
                components.add((Component)Component.m_237110_((String)"tooltips.touhou_little_maid.fox_scroll.dimension", (Object[])new Object[]{dimension.toString()}).m_130940_(ChatFormatting.GOLD));
            }
            if (workPos != null) {
                components.add((Component)Component.m_237110_((String)"message.touhou_little_maid.kappa_compass.work", (Object[])new Object[]{workPos.m_123341_(), workPos.m_123342_(), workPos.m_123343_()}).m_130940_(ChatFormatting.RED));
            }
            if (idlePos != null) {
                components.add((Component)Component.m_237110_((String)"message.touhou_little_maid.kappa_compass.idle", (Object[])new Object[]{idlePos.m_123341_(), idlePos.m_123342_(), idlePos.m_123343_()}).m_130940_(ChatFormatting.GREEN));
            }
            if (sleepPos != null) {
                components.add((Component)Component.m_237110_((String)"message.touhou_little_maid.kappa_compass.sleep", (Object[])new Object[]{sleepPos.m_123341_(), sleepPos.m_123342_(), sleepPos.m_123343_()}).m_130940_(ChatFormatting.BLUE));
            }
            components.add((Component)Component.m_237119_());
        }
        components.add((Component)Component.m_237115_((String)"message.touhou_little_maid.kappa_compass.usage.set_pos"));
        components.add((Component)Component.m_237115_((String)"message.touhou_little_maid.kappa_compass.usage.clear_pos"));
        components.add((Component)Component.m_237115_((String)"message.touhou_little_maid.kappa_compass.usage.write_pos_to_maid"));
        components.add((Component)Component.m_237115_((String)"message.touhou_little_maid.kappa_compass.usage.clear_maid_pos"));
    }
}

