/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class ClearMaidAIDataMessage {
    private static final int ALL_MSG_INDEX = -1;
    private final int entityId;
    private final int msgIndex;

    public ClearMaidAIDataMessage(int entityId, int msgIndex) {
        this.entityId = entityId;
        this.msgIndex = msgIndex;
    }

    public ClearMaidAIDataMessage(int entityId) {
        this(entityId, -1);
    }

    public static void encode(ClearMaidAIDataMessage message, FriendlyByteBuf buf) {
        buf.m_130130_(message.entityId);
        buf.m_130130_(message.msgIndex);
    }

    public static ClearMaidAIDataMessage decode(FriendlyByteBuf buf) {
        int entityId = buf.m_130242_();
        int msgIndex = buf.m_130242_();
        return new ClearMaidAIDataMessage(entityId, msgIndex);
    }

    public static void handle(ClearMaidAIDataMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> ClearMaidAIDataMessage.handle(message, ((NetworkEvent.Context)contextSupplier.get()).getSender()));
        }
        context.setPacketHandled(true);
    }

    private static void handle(ClearMaidAIDataMessage message, @Nullable ServerPlayer player) {
        EntityMaid maid;
        if (player == null) {
            return;
        }
        Entity entity = player.f_19853_.m_6815_(message.entityId);
        if (entity instanceof EntityMaid && (maid = (EntityMaid)entity).m_21830_((LivingEntity)player) && message.msgIndex == -1) {
            maid.getAiChatManager().getHistory().getDeque().clear();
        }
    }
}

