/*
 * Decompiled with CFR 0.152.
 */
package net.psunset.twilightforestfinalboss.data;

import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.psunset.twilightforestfinalboss.data.blockstates.TFFBBlockStateProvider;
import net.psunset.twilightforestfinalboss.data.lang.TFFBLangProvider;
import net.psunset.twilightforestfinalboss.data.loot_table.TFFBLootTableProvider;
import net.psunset.twilightforestfinalboss.data.models.TFFBItemModelProvider;
import net.psunset.twilightforestfinalboss.data.tags.TFFBBlockTagsProvider;
import net.psunset.twilightforestfinalboss.data.tags.TFFBDamageTypeTagsProvider;
import net.psunset.twilightforestfinalboss.data.tags.TFFBItemTagsProvider;

@Mod.EventBusSubscriber(modid="twilight_forest_final_boss", bus=Mod.EventBusSubscriber.Bus.MOD)
public class TFFBDataGenerator {
    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture registries = event.getLookupProvider();
        boolean isServer = event.includeServer();
        boolean isClient = event.includeClient();
        generator.addProvider(isClient, (DataProvider)new TFFBBlockStateProvider(output, fileHelper));
        generator.addProvider(isClient, (DataProvider)new TFFBItemModelProvider(output, fileHelper));
        generator.addProvider(isClient, (DataProvider)new TFFBLangProvider(output));
        generator.addProvider(isServer, (DataProvider)new TFFBLootTableProvider(output));
        TFFBBlockTagsProvider blockTagsProvider = new TFFBBlockTagsProvider(output, registries, fileHelper);
        generator.addProvider(isServer, (DataProvider)blockTagsProvider);
        generator.addProvider(isServer, (DataProvider)new TFFBItemTagsProvider(output, registries, blockTagsProvider.m_274426_(), fileHelper));
        generator.addProvider(isServer, (DataProvider)new TFFBDamageTypeTagsProvider(output, registries, fileHelper));
    }
}

