/*
 * Decompiled with CFR 0.152.
 */
package net.psunset.twilightforestfinalboss.entity.boss;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;
import twilightforest.TFConfig;
import twilightforest.entity.EnforcedHomePoint;
import twilightforest.entity.boss.IBossLootBuffer;
import twilightforest.loot.TFLootTables;
import twilightforest.util.EntityUtil;
import twilightforest.util.LandmarkUtil;

public abstract class BaseTFBoss
extends Monster
implements IBossLootBuffer,
EnforcedHomePoint {
    private static final EntityDataAccessor<Optional<GlobalPos>> HOME_POINT = SynchedEntityData.m_135353_(BaseTFBoss.class, (EntityDataSerializer)EntityDataSerializers.f_238113_);
    private final ServerBossEvent bossEvent;
    private final NonNullList<ItemStack> dyingInventory = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);

    protected BaseTFBoss(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.bossEvent = this.createBossBar();
    }

    public abstract ResourceKey<Structure> getHomeStructure();

    public abstract Block getDeathContainer(RandomSource var1);

    public abstract Block getBossSpawner();

    protected boolean shouldSpawnLoot() {
        return this.m_9236_().m_46469_().m_46207_(GameRules.f_46135_);
    }

    protected boolean shouldCreateSpawner() {
        return true;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(HOME_POINT, Optional.empty());
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.getBossBar().m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.getBossBar().m_6539_(player);
    }

    public void m_7380_(CompoundTag compound) {
        this.saveHomePointToNbt(compound);
        this.addDeathItemsSaveData(compound);
        super.m_7380_(compound);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.readDeathItemsSaveData(compound);
        this.loadHomePointFromNbt(compound);
    }

    public void m_20093_() {
        if (!this.m_5825_()) {
            this.m_20254_(5);
            if (this.m_6469_(this.m_269291_().m_269233_(), 4.0f)) {
                this.m_5496_(SoundEvents.f_11909_, 0.4f, 2.0f + this.m_217043_().m_188501_() * 0.4f);
                AABB bounds = this.m_20191_().m_82400_(9.0);
                for (double x = bounds.f_82288_; x < bounds.f_82291_; x += 1.0) {
                    for (double z = bounds.f_82290_; z < bounds.f_82293_; z += 1.0) {
                        for (double y = bounds.f_82289_; y < bounds.f_82292_; y += 1.0) {
                            BlockPos pos = BlockPos.m_274561_((double)x, (double)y, (double)z);
                            BlockState state = this.m_9236_().m_8055_(pos);
                            if (!state.m_60713_(Blocks.f_49991_)) continue;
                            this.m_9236_().m_46597_(pos, Blocks.f_50016_.m_49966_());
                        }
                    }
                }
            }
        }
    }

    public void m_6667_(DamageSource cause) {
        Level level;
        super.m_6667_(cause);
        if (this.shouldSpawnLoot() && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            this.postmortem(server, cause);
        }
    }

    protected void postmortem(ServerLevel serverLevel, DamageSource cause) {
        this.getBossBar().m_142711_(0.0f);
        IBossLootBuffer.saveDropsIntoBoss((LivingEntity)this, (LootParams)TFLootTables.createLootParams((LivingEntity)this, (boolean)true, (DamageSource)cause).m_287235_(LootContextParamSets.f_81415_), (ServerLevel)serverLevel);
        LandmarkUtil.markStructureConquered((Level)serverLevel, (EnforcedHomePoint)this, this.getHomeStructure(), (boolean)true);
    }

    public void m_142687_(Entity.RemovalReason reason) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.postRemoval(serverLevel, reason);
        }
        super.m_142687_(reason);
    }

    protected void postRemoval(ServerLevel serverLevel, Entity.RemovalReason reason) {
        if (reason.equals((Object)Entity.RemovalReason.KILLED) && this.shouldSpawnLoot()) {
            IBossLootBuffer.depositDropsIntoChest((LivingEntity)this, (BlockState)((BlockState)this.getDeathContainer(this.m_217043_()).m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)Direction.Plane.HORIZONTAL.m_235690_(this.m_9236_().m_213780_()))), (BlockPos)EntityUtil.bossChestLocation((Mob)this), (ServerLevel)serverLevel);
        }
    }

    public void m_6043_() {
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
            if (this.shouldCreateSpawner() && this.isRestrictionPointValid(this.m_9236_().m_46472_()) && this.m_9236_().m_46749_(Objects.requireNonNull(this.getRestrictionPoint()).m_122646_())) {
                this.placeSpawner(this.getRestrictionPoint().m_122646_());
            }
            this.m_146870_();
        } else {
            super.m_6043_();
        }
    }

    public void placeSpawner(BlockPos pos) {
        this.m_9236_().m_46597_(pos, this.getBossSpawner().m_49966_());
    }

    protected boolean m_8028_() {
        return true;
    }

    protected boolean m_6125_() {
        return (Boolean)TFConfig.COMMON_CONFIG.bossDropChests.get() == false;
    }

    public boolean m_6785_(double distance) {
        return false;
    }

    protected boolean m_7341_(Entity entity) {
        return false;
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    protected float m_6108_() {
        return 1.0f;
    }

    @Nullable
    public GlobalPos getRestrictionPoint() {
        return ((Optional)this.m_20088_().m_135370_(HOME_POINT)).orElse(null);
    }

    public void setRestrictionPoint(@Nullable GlobalPos pos) {
        this.m_20088_().m_135381_(HOME_POINT, Optional.ofNullable(pos));
    }

    public NonNullList<ItemStack> getItemStacks() {
        return this.dyingInventory;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (!this.m_213877_()) {
            if (!this.m_9236_().m_5776_()) {
                if (this.isDeathAnimationFinished()) {
                    this.m_9236_().m_7605_((Entity)this, (byte)60);
                    this.m_142687_(Entity.RemovalReason.KILLED);
                } else {
                    this.tickBossBar();
                }
            } else {
                this.tickDeathAnimation();
            }
        }
    }

    public boolean isDeathAnimationFinished() {
        return this.f_20919_ >= 20;
    }

    public void tickDeathAnimation() {
    }

    public ServerBossEvent getBossBar() {
        return this.bossEvent;
    }

    protected void m_8024_() {
        super.m_8024_();
        if (!this.m_9236_().m_5776_()) {
            this.tickBossBar();
        }
    }

    protected void tickBossBar() {
        this.getBossBar().m_142711_(this.m_21223_() / this.m_21233_());
    }

    protected ServerBossEvent createBossBar() {
        return new ServerBossEvent(this.getBossBarTitle(), this.getBossBarColor(), this.getBossBarOverlay());
    }

    public Component getBossBarTitle() {
        return this.m_5446_() != null ? this.m_5446_() : this.m_5677_();
    }

    public abstract BossEvent.BossBarColor getBossBarColor();

    public BossEvent.BossBarOverlay getBossBarOverlay() {
        return BossEvent.BossBarOverlay.PROGRESS;
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossEvent.m_6456_(this.getBossBarTitle());
    }
}

