/*
 * Decompiled with CFR 0.152.
 */
package net.psunset.twilightforestfinalboss.entity.boss;

import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.DragonFireball;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.psunset.twilightforestfinalboss.TwilightForestFinalBoss;
import net.psunset.twilightforestfinalboss.entity.boss.BaseTFBoss;
import net.psunset.twilightforestfinalboss.init.TFFBEntities;
import net.psunset.twilightforestfinalboss.tool.ActionUtl;
import net.psunset.twilightforestfinalboss.tool.RLUtl;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFEntities;
import twilightforest.init.TFStructures;

public class CastleKeeper
extends BaseTFBoss
implements GeoEntity {
    public static final EntityDataAccessor<String> DATA_ANIMATION = SynchedEntityData.m_135353_(CastleKeeper.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> DATA_TEXTURE = SynchedEntityData.m_135353_(CastleKeeper.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Integer> DATA_SHOOT_CD = SynchedEntityData.m_135353_(CastleKeeper.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DATA_SWING_CD = SynchedEntityData.m_135353_(CastleKeeper.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DATA_STOMP_CD = SynchedEntityData.m_135353_(CastleKeeper.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DATA_SPOUT_CD = SynchedEntityData.m_135353_(CastleKeeper.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final Map<Mob, CastleKeeper> CHILDREN_TO_PARENT = Maps.newHashMap();
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private byte midHpPhase;
    public String animation = "empty";
    String oAnimation = "empty";

    public CastleKeeper(EntityType<? extends CastleKeeper> type, Level world) {
        super(type, world);
        this.f_21364_ = 999;
        this.midHpPhase = 0;
        this.m_21557_(false);
        this.m_21530_();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_ANIMATION, (Object)"undefined");
        this.m_20088_().m_135372_(DATA_TEXTURE, (Object)"castle_keeper");
        this.m_20088_().m_135372_(DATA_SHOOT_CD, (Object)0);
        this.m_20088_().m_135372_(DATA_SWING_CD, (Object)0);
        this.m_20088_().m_135372_(DATA_STOMP_CD, (Object)0);
        this.m_20088_().m_135372_(DATA_SPOUT_CD, (Object)0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new CastleKeeperStompAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new CastleKeeperSwingAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new CastleKeeperSpoutAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new CastleKeeperShootAttackGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 1.0, 999.0f));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, 500.0).m_22268_(Attributes.f_22284_, 25.0).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22278_, 999.0).m_22268_(Attributes.f_22282_, 3.0);
    }

    public void setTexture(String texture) {
        this.f_19804_.m_135381_(DATA_TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.f_19804_.m_135370_(DATA_TEXTURE);
    }

    public byte getMidHPPhase() {
        return this.midHpPhase;
    }

    public void progressMidHPPhase() {
        this.midHpPhase = (byte)(this.midHpPhase + 1);
    }

    private void progressAttackCooldown() {
        int cooldown = (Integer)this.f_19804_.m_135370_(DATA_SHOOT_CD);
        if (cooldown > 0) {
            this.f_19804_.m_135381_(DATA_SHOOT_CD, (Object)(cooldown - 1));
        }
        if ((cooldown = ((Integer)this.f_19804_.m_135370_(DATA_SWING_CD)).intValue()) > 0) {
            this.f_19804_.m_135381_(DATA_SWING_CD, (Object)(cooldown - 1));
        }
        if ((cooldown = ((Integer)this.f_19804_.m_135370_(DATA_STOMP_CD)).intValue()) > 0) {
            this.f_19804_.m_135381_(DATA_STOMP_CD, (Object)(cooldown - 1));
        }
        if ((cooldown = ((Integer)this.f_19804_.m_135370_(DATA_SPOUT_CD)).intValue()) > 0) {
            this.f_19804_.m_135381_(DATA_SPOUT_CD, (Object)(cooldown - 1));
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity entity;
        if (CHILDREN_TO_PARENT.values().stream().anyMatch(it -> it.m_20148_().equals(this.m_20148_()))) {
            return false;
        }
        if (this.getMidHPPhase() >= 2 && (entity = source.m_7640_()) instanceof AbstractArrow) {
            return false;
        }
        boolean toReturn = super.m_6469_(source, amount);
        if (toReturn) {
            this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(RLUtl.ofVanilla("entity.blaze.hurt")), SoundSource.MASTER, 4.0f, -2.0f);
            if (this.f_19796_.m_188500_() < 0.5) {
                this.spawnNearby((EntityType)TFEntities.HARBINGER_CUBE.get());
            }
            if (this.f_19796_.m_188500_() < 0.5) {
                this.spawnNearby((EntityType)TFEntities.ADHERENT.get());
            }
            float health = this.m_21223_();
            int difficulty = this.m_9236_().m_46791_().m_19028_();
            if (health <= 400.0f && this.getMidHPPhase() < 1) {
                this.progressMidHPPhase();
                this.delayServerAction(20, it -> {
                    it.spawnNearby((EntityType)TFEntities.NAGA.get(), child -> {
                        child.setRestrictionPoint(GlobalPos.m_122643_((ResourceKey)child.m_9236_().m_46472_(), (BlockPos)child.m_20183_()));
                        CHILDREN_TO_PARENT.put((Mob)child, this);
                    });
                    it.delayServerAction(20, _it -> _it.spawnNearby((EntityType)TFEntities.NAGA.get(), child -> {
                        child.setRestrictionPoint(GlobalPos.m_122643_((ResourceKey)child.m_9236_().m_46472_(), (BlockPos)child.m_20183_()));
                        CHILDREN_TO_PARENT.put((Mob)child, this);
                    }));
                });
                if (difficulty >= 2) {
                    this.delayServerAction(20, it -> {
                        for (int i = 0; i < 2; ++i) {
                            it.spawnNearby((EntityType)TFEntities.MIST_WOLF.get());
                        }
                        it.delayServerAction(20, _it -> {
                            for (int j = 0; j < 2; ++j) {
                                _it.spawnNearby((EntityType)TFEntities.KING_SPIDER.get());
                            }
                        });
                    });
                }
            } else if (health <= 300.0f && this.getMidHPPhase() < 2) {
                this.progressMidHPPhase();
                this.setTexture("castle_keeper_damage1");
                LightningBolt lightning = (LightningBolt)EntityType.f_20465_.m_20615_(this.m_9236_());
                lightning.m_20219_(Vec3.m_82539_((Vec3i)this.m_20183_()));
                lightning.m_20874_(true);
                this.m_9236_().m_7967_((Entity)lightning);
                this.delayServerAction(20, it -> {
                    it.spawnNearby((EntityType)TFEntities.LICH.get(), child -> {
                        child.setRestrictionPoint(GlobalPos.m_122643_((ResourceKey)child.m_9236_().m_46472_(), (BlockPos)child.m_20183_()));
                        CHILDREN_TO_PARENT.put((Mob)child, this);
                    });
                    this.delayServerAction(20, _it -> {
                        _it.spawnNearby((EntityType)TFEntities.ARMORED_GIANT.get());
                        _it.spawnNearby((EntityType)TFEntities.GIANT_MINER.get());
                    });
                });
                if (difficulty >= 2) {
                    this.delayServerAction(20, it -> {
                        it.spawnNearby((EntityType)TFEntities.ARMORED_GIANT.get());
                        it.delayServerAction(20, _it -> _it.spawnNearby((EntityType)TFEntities.GIANT_MINER.get()));
                    });
                }
                this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(RLUtl.ofVanilla("block.anvil.destroy")), SoundSource.MASTER, 6.0f, 1.0f);
                this.m_9236_().m_46796_(2001, BlockPos.m_274561_((double)this.m_20185_(), (double)(this.m_20186_() + 2.5), (double)this.m_20189_()), Block.m_49956_((BlockState)Blocks.f_256831_.m_49966_()));
            } else if (health <= 200.0f && this.getMidHPPhase() < 3) {
                this.progressMidHPPhase();
                this.delayServerAction(20, it -> it.spawnNearby((EntityType)TFEntities.SNOW_QUEEN.get(), child -> {
                    child.setRestrictionPoint(GlobalPos.m_122643_((ResourceKey)child.m_9236_().m_46472_(), (BlockPos)child.m_20183_()));
                    CHILDREN_TO_PARENT.put((Mob)child, this);
                }));
                if (difficulty >= 2) {
                    this.delayServerAction(20, it -> it.spawnNearby((EntityType)TFEntities.ALPHA_YETI.get(), child -> {
                        child.setRestrictionPoint(GlobalPos.m_122643_((ResourceKey)child.m_9236_().m_46472_(), (BlockPos)child.m_20183_()));
                        CHILDREN_TO_PARENT.put((Mob)child, this);
                    }));
                }
            } else if (health <= 100.0f && this.getMidHPPhase() < 4) {
                this.progressMidHPPhase();
                this.setTexture("castle_keeper_damage2");
                LightningBolt lightning = (LightningBolt)EntityType.f_20465_.m_20615_(this.m_9236_());
                lightning.m_20219_(Vec3.m_82539_((Vec3i)this.m_20183_()));
                lightning.m_20874_(true);
                this.m_9236_().m_7967_((Entity)lightning);
                this.delayServerAction(20, it -> {
                    it.spawnNearby((EntityType)TFEntities.HYDRA.get(), child -> {
                        child.setRestrictionPoint(GlobalPos.m_122643_((ResourceKey)child.m_9236_().m_46472_(), (BlockPos)child.m_20183_()));
                        CHILDREN_TO_PARENT.put((Mob)child, this);
                    });
                    it.delayServerAction(20, _it -> _it.spawnNearby((EntityType)TFEntities.UR_GHAST.get(), child -> {
                        child.setRestrictionPoint(GlobalPos.m_122643_((ResourceKey)child.m_9236_().m_46472_(), (BlockPos)child.m_20183_()));
                        CHILDREN_TO_PARENT.put((Mob)child, this);
                    }));
                });
                if (difficulty >= 2) {
                    this.delayServerAction(20, it -> {
                        it.spawnNearby((EntityType)TFEntities.MINOSHROOM.get(), child -> {
                            child.setRestrictionPoint(GlobalPos.m_122643_((ResourceKey)child.m_9236_().m_46472_(), (BlockPos)child.m_20183_()));
                            CHILDREN_TO_PARENT.put((Mob)child, this);
                        });
                        it.delayServerAction(20, _it -> {
                            for (int i = 0; i < 6; ++i) {
                                _it.spawnNearby((EntityType)TFEntities.KNIGHT_PHANTOM.get(), child -> {
                                    child.setRestrictionPoint(GlobalPos.m_122643_((ResourceKey)child.m_9236_().m_46472_(), (BlockPos)child.m_20183_()));
                                    CHILDREN_TO_PARENT.put((Mob)child, this);
                                });
                            }
                        });
                    });
                }
                this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(RLUtl.ofVanilla("block.anvil.destroy")), SoundSource.MASTER, 6.0f, 1.0f);
                this.m_9236_().m_46796_(2001, BlockPos.m_274561_((double)this.m_20185_(), (double)(this.m_20186_() + 3.2), (double)this.m_20189_()), Block.m_49956_((BlockState)Blocks.f_50503_.m_49966_()));
            }
        }
        return toReturn;
    }

    public boolean m_6673_(DamageSource source) {
        if (source.m_269533_(DamageTypeTags.f_268738_)) {
            return false;
        }
        return !(source.m_7639_() instanceof Player) || super.m_6673_(source);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag pDataTag) {
        if (this.m_9236_().m_46791_() != Difficulty.EASY && this.m_21051_(Attributes.f_22276_) != null) {
            boolean hard = this.m_9236_().m_46791_() == Difficulty.HARD;
            AttributeModifier modifier = new AttributeModifier("Difficulty Health Boost", hard ? 100.0 : 60.0, AttributeModifier.Operation.ADDITION);
            if (!Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22109_(modifier)) {
                Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22125_(modifier);
                this.m_21153_(this.m_21233_());
            }
        }
        this.getPersistentData().m_128405_("CastleKeeperAttack", 0);
        return spawnGroupData;
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("Texture", this.getTexture());
        compound.m_128344_("Phase", this.getMidHPPhase());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Texture")) {
            this.setTexture(compound.m_128461_("Texture"));
        }
        if (compound.m_128441_("Phase")) {
            this.midHpPhase = compound.m_128445_("Phase");
        }
    }

    public void m_8119_() {
        super.m_8119_();
        this.progressAttackCooldown();
        String animation = this.getAnimation();
        if (!animation.equals("undefined")) {
            this.setAnimation("undefined");
            this.animation = animation;
        }
    }

    public void m_6075_() {
        super.m_6075_();
        this.m_6210_();
    }

    public boolean m_6072_() {
        return false;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_11701_;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_11704_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11703_;
    }

    @Override
    public BossEvent.BossBarOverlay getBossBarOverlay() {
        return BossEvent.BossBarOverlay.NOTCHED_20;
    }

    @Override
    public BossEvent.BossBarColor getBossBarColor() {
        return BossEvent.BossBarColor.RED;
    }

    @Override
    public void m_6667_(DamageSource cause) {
        this.getPersistentData().m_128347_("CastleKeeperAttack", 0.0);
        if (!this.m_9236_().m_5776_()) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123745_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 10, 0.4, 1.0, 0.4, 0.02);
            TwilightForestFinalBoss.LOGGER.info("Summoning escaping souls");
            AbstractArrow arrow = (AbstractArrow)((EntityType)TFFBEntities.ESCAPING_SOUL.get()).m_20615_(this.m_9236_());
            arrow.m_36781_(5.0);
            arrow.m_20219_(this.m_20182_());
            arrow.m_6686_(Mth.m_216263_((RandomSource)this.f_19796_, (double)-0.4, (double)0.4), 3.5, Mth.m_216263_((RandomSource)this.f_19796_, (double)-0.4, (double)0.4), 2.0f, 0.0f);
            this.m_9236_().m_7967_((Entity)arrow);
        }
        super.m_6667_(cause);
    }

    @Override
    protected void m_6153_() {
        ++this.f_20919_;
        if (!this.m_213877_()) {
            if (!this.m_9236_().m_5776_()) {
                if (this.isDeathAnimationFinished()) {
                    this.m_9236_().m_7605_((Entity)this, (byte)60);
                    this.m_142687_(Entity.RemovalReason.KILLED);
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123747_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 50, 0.5, 0.5, 0.5, 0.0);
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 50, 0.5, 0.5, 0.5, 0.0);
                } else {
                    this.tickBossBar();
                }
            } else {
                this.tickDeathAnimation();
            }
        }
    }

    private PlayState movementPredicate(AnimationState<CastleKeeper> event) {
        if (this.animation.equals("empty")) {
            if (!event.isMoving() && event.getLimbSwingAmount() > -0.15f && event.getLimbSwingAmount() < 0.15f) {
                return this.m_21224_() ? event.setAndContinue(RawAnimation.begin().thenPlay("death")) : event.setAndContinue(RawAnimation.begin().thenLoop("idle"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("walk"));
        }
        return PlayState.STOP;
    }

    private PlayState procedurePredicate(AnimationState<CastleKeeper> event) {
        if (!this.animation.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !this.animation.equals(this.oAnimation) && !this.animation.equals("empty")) {
            if (!this.animation.equals(this.oAnimation)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animation));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animation = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animation.equals("empty")) {
            this.oAnimation = "empty";
            return PlayState.STOP;
        }
        this.oAnimation = this.animation;
        return PlayState.CONTINUE;
    }

    public String getAnimation() {
        return (String)this.f_19804_.m_135370_(DATA_ANIMATION);
    }

    public void setAnimation(String animation) {
        this.f_19804_.m_135381_(DATA_ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 0, this::movementPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "procedure", 0, this::procedurePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void delayServerAction(int tick, Consumer<CastleKeeper> action) {
        ActionUtl.delayInServer(tick, () -> action.accept(this));
    }

    @Override
    public ResourceKey<Structure> getHomeStructure() {
        return TFStructures.FINAL_CASTLE;
    }

    @Override
    public Block getDeathContainer(RandomSource random) {
        return (Block)TFBlocks.MINING_CHEST.get();
    }

    @Override
    public Block getBossSpawner() {
        return (Block)TFBlocks.FINAL_BOSS_BOSS_SPAWNER.get();
    }

    public int getHomeRadius() {
        return 20;
    }

    @Override
    public boolean isDeathAnimationFinished() {
        return this.f_20919_ >= 200;
    }

    @Nullable
    public <T extends Mob> T spawnNearby(EntityType<T> typeToSpawn) {
        return this.spawnNearby(typeToSpawn, null);
    }

    @Nullable
    public <T extends Mob> T spawnNearby(EntityType<T> typeToSpawn, @Nullable Consumer<T> spawnCallback) {
        Mob entityToSpawn = (Mob)typeToSpawn.m_20615_(this.m_9236_());
        if (entityToSpawn == null) {
            return null;
        }
        entityToSpawn.m_146884_(this.m_20182_());
        double origX = this.m_20185_();
        double origY = this.m_20186_();
        double origZ = this.m_20189_();
        int tries = 100;
        Vec3 tpPos = this.m_20182_();
        for (int i = 0; i < tries; ++i) {
            double tz;
            double ty;
            double tx = entityToSpawn.m_20185_() + this.m_217043_().m_188583_() * 16.0;
            boolean destClear = this.m_20984_(tx, ty = entityToSpawn.m_20186_() + 2.0, tz = entityToSpawn.m_20189_() + this.m_217043_().m_188583_() * 16.0, false);
            if (destClear) {
                tx = this.m_20185_();
                ty = this.m_20186_();
                tz = this.m_20189_();
            }
            boolean canSeeTargetAtDest = this.m_142582_((Entity)entityToSpawn);
            this.m_6021_(origX, origY, origZ);
            if (i < 85 && ty < entityToSpawn.m_20186_() || !destClear || !canSeeTargetAtDest || !(entityToSpawn.m_20182_().m_82531_(tx, ty, tz) >= 25.0)) continue;
            tpPos = new Vec3(tx, ty, tz);
        }
        entityToSpawn.m_20219_(tpPos);
        entityToSpawn.m_6710_(this.m_5448_());
        entityToSpawn.f_21346_.m_262460_(it -> true);
        entityToSpawn.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal(entityToSpawn, Player.class, false));
        if (spawnCallback != null) {
            spawnCallback.accept(entityToSpawn);
        }
        this.m_9236_().m_7967_((Entity)entityToSpawn);
        return (T)entityToSpawn;
    }

    @Nullable
    public <T extends AbstractHurtingProjectile> T shoot(AbstractHurtingProjectileFactory<T> factory) {
        return this.shoot(factory, null);
    }

    @Nullable
    public <T extends AbstractHurtingProjectile> T shoot(AbstractHurtingProjectileFactory<T> factory, @Nullable Consumer<T> spawnCallback) {
        Vec3 start = this.m_5448_() != null ? this.m_5448_().m_20182_().m_82520_((double)Mth.m_216271_((RandomSource)this.f_19796_, (int)-8, (int)8), 10.0, (double)Mth.m_216271_((RandomSource)this.f_19796_, (int)-8, (int)8)) : new Vec3(this.m_20185_() + (double)Mth.m_216271_((RandomSource)this.f_19796_, (int)-20, (int)20), this.m_20188_() + 10.0, this.m_20189_() + (double)Mth.m_216271_((RandomSource)this.f_19796_, (int)-20, (int)20));
        Vec3 movement = new Vec3(this.f_19796_.m_188583_() * 0.01, -10.0, this.f_19796_.m_188583_() * 0.01).m_82541_();
        T projectile = factory.create(this.m_9236_(), (LivingEntity)this, movement.f_82479_, movement.f_82480_, movement.f_82481_);
        if (projectile == null) {
            return null;
        }
        projectile.m_20343_(start.f_82479_, start.f_82480_, start.f_82481_);
        if (spawnCallback != null) {
            spawnCallback.accept(projectile);
        }
        this.m_9236_().m_7967_(projectile);
        return projectile;
    }

    static class CastleKeeperStompAttackGoal
    extends Goal {
        private final CastleKeeper keeper;
        public int attackTimer;
        public final int ATTACK_DURATION = 25;
        public final int EXTRA_COOLDOWN = 60;

        protected CastleKeeperStompAttackGoal(CastleKeeper keeper) {
            this.keeper = keeper;
        }

        public void m_8056_() {
            this.attackTimer = 0;
        }

        public void m_8041_() {
            this.keeper.f_19804_.m_135381_(DATA_STOMP_CD, (Object)(25 - this.attackTimer + 60));
        }

        public boolean m_8036_() {
            if (this.keeper.m_5448_() == null) {
                return false;
            }
            Vec3 pos = this.keeper.m_20182_();
            Vec3 targetPos = this.keeper.m_5448_().m_20182_();
            return (Integer)this.keeper.f_19804_.m_135370_(DATA_STOMP_CD) <= 0 && targetPos.m_82546_(pos).m_165925_() < 25.0 && targetPos.m_82557_(pos) < 50.0 && this.keeper.m_142582_((Entity)this.keeper.m_5448_());
        }

        public void m_8037_() {
            ++this.attackTimer;
            if (this.attackTimer == 1) {
                this.keeper.setAnimation("stomp");
                this.keeper.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 25, 254, true, false));
            } else if (this.attackTimer > 25) {
                int difficulty = this.keeper.m_9236_().m_46791_().m_19028_();
                for (int i = 0; i < 50; ++i) {
                    this.keeper.m_9236_().m_46796_(2001, this.keeper.m_20183_().m_7918_(Mth.m_216271_((RandomSource)this.keeper.m_217043_(), (int)-5, (int)5), -1, Mth.m_216271_((RandomSource)this.keeper.m_217043_(), (int)-5, (int)5)), Block.m_49956_((BlockState)this.keeper.m_9236_().m_8055_(this.keeper.m_20183_().m_7495_())));
                }
                for (Entity entityInside : this.keeper.m_9236_().m_6443_(Entity.class, new AABB(this.keeper.m_20182_(), this.keeper.m_20182_()).m_82400_((double)(4.0f + (float)difficulty / 2.0f)), e -> true).stream().sorted(Comparator.comparingDouble(it -> it.m_20238_(this.keeper.m_20182_()))).toList()) {
                    if (!entityInside.m_6095_().m_20674_().m_21609_()) continue;
                    entityInside.m_6469_(new DamageSource((Holder)this.keeper.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268566_), (Entity)this.keeper), 9.0f + (float)difficulty);
                    Vec3 delta = new Vec3(entityInside.m_20182_().f_82479_ - this.keeper.m_20182_().f_82479_, 5.0, entityInside.m_20182_().f_82481_ - this.keeper.m_20182_().f_82481_).m_82541_().m_82542_(2.0, 2.5, 2.0);
                    entityInside.m_5997_(delta.f_82479_, delta.f_82480_, delta.f_82481_);
                }
                this.keeper.m_9236_().m_5594_(null, this.keeper.m_20183_(), (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(RLUtl.ofVanilla("entity.dragon_fireball.explode")), SoundSource.MASTER, 2.0f, -1.0f);
                this.attackTimer = -60;
            }
        }
    }

    static class CastleKeeperSwingAttackGoal
    extends Goal {
        private final CastleKeeper keeper;
        public int attackTimer;
        public final int ATTACK_DURATION = 25;
        public final int EXTRA_COOLDOWN = 55;

        protected CastleKeeperSwingAttackGoal(CastleKeeper keeper) {
            this.keeper = keeper;
        }

        public void m_8056_() {
            this.attackTimer = 0;
        }

        public void m_8041_() {
            this.keeper.f_19804_.m_135381_(DATA_SWING_CD, (Object)(25 - this.attackTimer + 55));
        }

        public boolean m_8036_() {
            if (this.keeper.m_5448_() == null) {
                return false;
            }
            Vec3 pos = this.keeper.m_20182_();
            Vec3 targetPos = this.keeper.m_5448_().m_20182_();
            return (Integer)this.keeper.f_19804_.m_135370_(DATA_SWING_CD) <= 0 && targetPos.m_82546_(pos).m_165925_() < 9.0 && targetPos.m_82557_(pos) < 18.0 && this.keeper.m_142582_((Entity)this.keeper.m_5448_());
        }

        public void m_8037_() {
            ++this.attackTimer;
            if (this.attackTimer == 1) {
                this.keeper.setAnimation("swing");
                this.keeper.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 25, 254, true, false));
            } else if (this.attackTimer > 25) {
                int difficulty = this.keeper.m_9236_().m_46791_().m_19028_();
                for (int i = 0; i < 100; ++i) {
                    this.keeper.delayServerAction(Mth.m_216271_((RandomSource)this.keeper.m_217043_(), (int)0, (int)8), it -> {
                        Vec3 center = new Vec3((double)it.m_9236_().m_45547_(new ClipContext(it.m_20299_(1.0f), it.m_20299_(1.0f).m_82549_(it.m_20252_(1.0f).m_82490_((double)(Mth.m_216271_((RandomSource)it.m_217043_(), (int)2, (int)5) + difficulty))), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)it)).m_82425_().m_123341_(), it.m_20186_(), (double)it.m_9236_().m_45547_(new ClipContext(it.m_20299_(1.0f), it.m_20299_(1.0f).m_82549_(it.m_20252_(1.0f).m_82490_((double)(Mth.m_216271_((RandomSource)it.m_217043_(), (int)2, (int)5) + difficulty))), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)it)).m_82425_().m_123343_());
                        for (Entity entityInside : it.m_9236_().m_6443_(Entity.class, new AABB(center, center).m_82400_(1.0), e -> true).stream().sorted(Comparator.comparingDouble(_it -> _it.m_20238_(center))).toList()) {
                            if (entityInside == it) continue;
                            entityInside.m_6469_(new DamageSource((Holder)it.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268566_), (Entity)it), 8.0f + (float)difficulty);
                        }
                    });
                }
                this.keeper.m_9236_().m_5594_(null, this.keeper.m_20183_(), (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(RLUtl.ofVanilla("entity.camel.dash")), SoundSource.MASTER, 2.0f, 1.0f);
                this.attackTimer = -55;
            }
        }
    }

    static class CastleKeeperSpoutAttackGoal
    extends Goal {
        private final CastleKeeper keeper;
        public int attackTimer;
        public final int ATTACK_DURATION = 30;
        public final int EXTRA_COOLDOWN = 70;

        protected CastleKeeperSpoutAttackGoal(CastleKeeper keeper) {
            this.keeper = keeper;
        }

        public void m_8056_() {
            this.attackTimer = 0;
        }

        public void m_8041_() {
            this.keeper.f_19804_.m_135381_(DATA_SPOUT_CD, (Object)(30 - this.attackTimer + 70));
        }

        public boolean m_8036_() {
            if (this.keeper.m_5448_() == null) {
                return false;
            }
            Vec3 pos = this.keeper.m_20182_();
            Vec3 targetPos = this.keeper.m_5448_().m_20182_();
            return (Integer)this.keeper.f_19804_.m_135370_(DATA_STOMP_CD) <= 0 && targetPos.m_82546_(pos).m_165925_() < 64.0 && targetPos.m_82557_(pos) < 128.0 && this.keeper.m_142582_((Entity)this.keeper.m_5448_());
        }

        public void m_8037_() {
            ++this.attackTimer;
            if (this.attackTimer == 1) {
                this.keeper.setAnimation("spout");
                this.keeper.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 30, 254, true, false));
            } else if (this.attackTimer > 10 && this.attackTimer <= 30) {
                for (int i = 0; i < 5; ++i) {
                    AbstractArrow arrow = (AbstractArrow)((EntityType)TFFBEntities.LOBBED_FIREBALL.get()).m_20615_(this.keeper.m_9236_());
                    arrow.m_5602_((Entity)this.keeper);
                    arrow.m_36781_(10.0);
                    arrow.m_20225_(true);
                    arrow.m_7311_(2000);
                    arrow.m_6027_(this.keeper.m_20185_(), this.keeper.m_20188_() + 1.0, this.keeper.m_20189_());
                    arrow.m_6686_(Mth.m_216263_((RandomSource)this.keeper.m_217043_(), (double)-1.0, (double)1.0), 2.0, Mth.m_216263_((RandomSource)this.keeper.m_217043_(), (double)-1.0, (double)1.0), 1.0f, 0.0f);
                    this.keeper.m_9236_().m_7967_((Entity)arrow);
                }
                this.keeper.m_9236_().m_5594_(null, this.keeper.m_20183_(), (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(RLUtl.ofVanilla("entity.blaze.shoot")), SoundSource.MASTER, 2.0f, 1.0f);
            } else if (this.attackTimer > 30) {
                this.attackTimer = -70;
            }
        }
    }

    static class CastleKeeperShootAttackGoal
    extends Goal {
        private final CastleKeeper keeper;
        public int attackTimer;
        public final int ATTACK_DURATION = 40;
        public final int EXTRA_COOLDOWN = 95;

        protected CastleKeeperShootAttackGoal(CastleKeeper keeper) {
            this.keeper = keeper;
        }

        public void m_8056_() {
            this.attackTimer = 0;
        }

        public void m_8041_() {
            this.keeper.f_19804_.m_135381_(DATA_SHOOT_CD, (Object)(40 - this.attackTimer + 95));
        }

        public boolean m_8036_() {
            return (Integer)this.keeper.f_19804_.m_135370_(DATA_SHOOT_CD) <= 0;
        }

        public void m_8037_() {
            ++this.attackTimer;
            int difficulty = this.keeper.m_9236_().m_46791_().m_19028_();
            if (this.attackTimer == 1) {
                this.keeper.setAnimation("shoot");
                this.keeper.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 254, true, false));
            } else if (this.attackTimer >= 20 && this.attackTimer <= 40) {
                if (this.attackTimer % (10 - difficulty * 2) == 0) {
                    this.keeper.shoot((_level, _owner, deltaX, deltaY, deltaZ) -> new LargeFireball(_level, _owner, deltaX, deltaY, deltaZ, this.keeper.m_217043_().m_216339_(1, 4)), it -> it.m_7311_(99999));
                    for (int i = 0; i < 5; ++i) {
                        this.keeper.shoot(SmallFireball::new, it -> it.m_7311_(99999));
                    }
                    if (difficulty >= 2) {
                        this.keeper.shoot(DragonFireball::new);
                    }
                    if (difficulty >= 3) {
                        this.keeper.shoot(WitherSkull::new);
                    }
                    this.keeper.m_9236_().m_5594_(null, this.keeper.m_20183_(), (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(RLUtl.ofVanilla("entity.ghast.shoot")), SoundSource.MASTER, 2.0f, 1.0f);
                }
            } else if (this.attackTimer > 40) {
                this.attackTimer = -95;
            }
        }
    }

    @FunctionalInterface
    public static interface AbstractHurtingProjectileFactory<T extends AbstractHurtingProjectile> {
        public T create(Level var1, LivingEntity var2, double var3, double var5, double var7);
    }
}

