/*
 * Decompiled with CFR 0.152.
 */
package net.psunset.twilightforestfinalboss.entity.nonliving;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.psunset.twilightforestfinalboss.init.TFFBEntities;
import net.psunset.twilightforestfinalboss.tool.RLUtl;

public class EscapingSoul
extends AbstractArrow
implements ItemSupplier {
    public static final ItemStack EMPTY_ITEM = new ItemStack((ItemLike)Blocks.f_50016_);

    public EscapingSoul(EntityType<? extends EscapingSoul> type, Level world) {
        super(type, world);
    }

    public EscapingSoul(EntityType<? extends EscapingSoul> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
    }

    public EscapingSoul(EntityType<? extends EscapingSoul> type, LivingEntity entity, Level world) {
        super(type, entity, world);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack m_7846_() {
        return EMPTY_ITEM;
    }

    protected ItemStack m_7941_() {
        return EMPTY_ITEM;
    }

    protected void m_7761_(LivingEntity entity) {
        super.m_7761_(entity);
        entity.m_21317_(entity.m_21234_() - 1);
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_20242_(true);
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_235898_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123745_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        if (this.f_36703_) {
            this.m_146870_();
        }
    }

    public void m_7380_(CompoundTag compound) {
        try {
            super.m_7380_(compound);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static EscapingSoul shoot(Level world, LivingEntity entity, RandomSource source) {
        return EscapingSoul.shoot(world, entity, source, 1.0f, 5.0, 5);
    }

    public static EscapingSoul shoot(Level world, LivingEntity entity, RandomSource source, float pullingPower) {
        return EscapingSoul.shoot(world, entity, source, pullingPower, 5.0, 5);
    }

    public static EscapingSoul shoot(Level world, LivingEntity entity, RandomSource random, float power, double damage, int knockback) {
        EscapingSoul arrow = new EscapingSoul((EntityType<? extends EscapingSoul>)((EntityType)TFFBEntities.ESCAPING_SOUL.get()), entity, world);
        arrow.m_6686_(entity.m_20252_((float)1.0f).f_82479_, entity.m_20252_((float)1.0f).f_82480_, entity.m_20252_((float)1.0f).f_82481_, power * 2.0f, 0.0f);
        arrow.m_20225_(true);
        arrow.m_36762_(false);
        arrow.m_36781_(damage);
        world.m_7967_((Entity)arrow);
        world.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(RLUtl.ofVanilla("entity.arrow.shoot")), SoundSource.PLAYERS, 1.0f, 1.0f / (random.m_188501_() * 0.5f + 1.0f) + power / 2.0f);
        return arrow;
    }

    public static EscapingSoul shoot(LivingEntity entity, LivingEntity target) {
        EscapingSoul arrow = new EscapingSoul((EntityType<? extends EscapingSoul>)((EntityType)TFFBEntities.ESCAPING_SOUL.get()), entity, entity.m_9236_());
        double dx = target.m_20185_() - entity.m_20185_();
        double dy = target.m_20186_() + (double)target.m_20192_() - 1.1;
        double dz = target.m_20189_() - entity.m_20189_();
        arrow.m_6686_(dx, dy - arrow.m_20186_() + Math.hypot(dx, dz) * (double)0.2f, dz, 2.0f, 12.0f);
        arrow.m_20225_(true);
        arrow.m_36781_(5.0);
        arrow.m_36762_(false);
        entity.m_9236_().m_7967_((Entity)arrow);
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(RLUtl.ofVanilla("entity.arrow.shoot")), SoundSource.PLAYERS, 1.0f, 1.0f / (RandomSource.m_216327_().m_188501_() * 0.5f + 1.0f));
        return arrow;
    }
}

