/*
 * Decompiled with CFR 0.152.
 */
package net.psunset.twilightforestfinalboss.init;

import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.psunset.twilightforestfinalboss.entity.boss.CastleKeeper;
import net.psunset.twilightforestfinalboss.entity.nonliving.EscapingSoul;
import net.psunset.twilightforestfinalboss.entity.nonliving.LobbedFireball;
import net.psunset.twilightforestfinalboss.init.TFFBItems;

public class TFFBEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"twilight_forest_final_boss");
    public static final RegistryObject<EntityType<CastleKeeper>> CASTLE_KEEPER = TFFBEntities.register("castle_keeper", EntityType.Builder.m_20704_(CastleKeeper::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(128).setUpdateInterval(3).m_20719_().m_20699_(1.0f, 3.6f), () -> new ForgeSpawnEggItem(CASTLE_KEEPER, -1, -16777216, new Item.Properties()));
    public static final RegistryObject<EntityType<LobbedFireball>> LOBBED_FIREBALL = TFFBEntities.register("lobbed_fireball", EntityType.Builder.m_20704_(LobbedFireball::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<EscapingSoul>> ESCAPING_SOUL = TFFBEntities.register("escaping_soul", EntityType.Builder.m_20704_(EscapingSoul::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String name, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(name, () -> entityTypeBuilder.m_20712_(name));
    }

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String name, EntityType.Builder<T> entityTypeBuilder, Supplier<SpawnEggItem> spawnEggItem) {
        RegistryObject toReturn = REGISTRY.register(name, () -> entityTypeBuilder.m_20712_(name));
        TFFBItems.SPAWN_EGGS_REGISTRY.register(name + "_spawn_egg", spawnEggItem);
        return toReturn;
    }
}

