/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.world;

import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3fc;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;
import org.joml.primitives.LineSegmentf;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.api.ships.LoadedShip;
import org.valkyrienskies.core.util.AABBdUtilKt;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.mod.util.McMathUtilKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a]\u0010\u000b\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00042\u001a\u0010\b\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00028\u00000\u00062\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\tH\u0002\u00a2\u0006\u0004\b\u000b\u0010\f\u001a+\u0010\u000b\u001a\u00020\u000e*\u00020\r2\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u000b\u0010\u000f\u001aA\u0010\u0017\u001a\u00020\u000e*\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00042\b\b\u0002\u0010\u0012\u001a\u00020\u00112\u0010\b\u0002\u0010\u0015\u001a\n\u0018\u00010\u0013j\u0004\u0018\u0001`\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u0011H\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018\u001aI\u0010$\u001a\u0004\u0018\u00010#*\u00020\r2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u001d2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00190\u001f2\u0006\u0010\"\u001a\u00020!\u00a2\u0006\u0004\b$\u0010%\u001a\u0019\u0010'\u001a\u00020\u000e*\u00020&2\u0006\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0004\b'\u0010(\"\u001c\u0010+\u001a\n **\u0004\u0018\u00010)0)8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,\u00a8\u0006-"}, d2={"T", "Lnet/minecraft/world/phys/Vec3;", "realStart", "realEnd", "Lnet/minecraft/world/level/ClipContext;", "raycastContext", "Ljava/util/function/BiFunction;", "Lnet/minecraft/core/BlockPos;", "context", "Ljava/util/function/Function;", "blockRaycaster", "clip", "(Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/level/ClipContext;Ljava/util/function/BiFunction;Ljava/util/function/Function;)Ljava/lang/Object;", "Lnet/minecraft/world/level/Level;", "Lnet/minecraft/world/phys/BlockHitResult;", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/ClipContext;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/BlockHitResult;", "ctx", "", "shouldTransformHitPos", "", "Lorg/valkyrienskies/core/api/ships/properties/ShipId;", "skipShip", "skipWorld", "clipIncludeShips", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/ClipContext;ZLjava/lang/Long;Z)Lnet/minecraft/world/phys/BlockHitResult;", "Lnet/minecraft/world/entity/Entity;", "shooter", "origStartVecM", "origEndVecM", "Lnet/minecraft/world/phys/AABB;", "origBoundingBoxM", "Ljava/util/function/Predicate;", "filter", "", "maxDistance2", "Lnet/minecraft/world/phys/EntityHitResult;", "raytraceEntities", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;D)Lnet/minecraft/world/phys/EntityHitResult;", "Lnet/minecraft/world/level/BlockGetter;", "vanillaClip", "(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/world/level/ClipContext;)Lnet/minecraft/world/phys/BlockHitResult;", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/apache/logging/log4j/Logger;", "valkyrienskies-120"})
@SourceDebugExtension(value={"SMAP\nRaycastUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RaycastUtils.kt\norg/valkyrienskies/mod/common/world/RaycastUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,312:1\n1855#2,2:313\n1855#2,2:315\n*S KotlinDebug\n*F\n+ 1 RaycastUtils.kt\norg/valkyrienskies/mod/common/world/RaycastUtilsKt\n*L\n265#1:313,2\n224#1:315,2\n*E\n"})
public final class RaycastUtilsKt {
    private static final Logger logger = LogManager.getLogger((String)"RaycastUtilsKt");

    @JvmOverloads
    @NotNull
    public static final BlockHitResult clipIncludeShips(@NotNull Level $this$clipIncludeShips, @NotNull ClipContext ctx, boolean shouldTransformHitPos, @Nullable Long skipShip, boolean skipWorld) {
        BlockHitResult vanillaHit;
        Intrinsics.checkNotNullParameter((Object)$this$clipIncludeShips, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (skipWorld) {
            Vec3 line = ctx.m_45693_().m_82546_(ctx.m_45702_());
            v0 = BlockHitResult.m_82426_((Vec3)ctx.m_45693_(), (Direction)Direction.m_122366_((double)line.f_82479_, (double)line.f_82480_, (double)line.f_82481_), (BlockPos)BlockPos.m_274446_((Position)((Position)ctx.m_45693_())));
        } else {
            v0 = vanillaHit = RaycastUtilsKt.vanillaClip((BlockGetter)$this$clipIncludeShips, ctx);
        }
        if (VSGameUtilsKt.getShipObjectWorld($this$clipIncludeShips) == null) {
            logger.error("shipObjectWorld was empty for level raytrace, this should not be possible! Returning vanilla result.");
            Intrinsics.checkNotNull((Object)vanillaHit);
            return vanillaHit;
        }
        BlockHitResult closestHit = vanillaHit;
        Vec3 closestHitPos = vanillaHit.f_82445_;
        double closestHitDist = closestHitPos.m_82557_(ctx.m_45702_());
        Vec3 vec3 = ctx.m_45702_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getFrom(...)");
        Vector3dc vector3dc = (Vector3dc)VectorConversionsMCKt.toJOML(vec3);
        Vec3 vec32 = ctx.m_45693_();
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"getTo(...)");
        AABBd aABBd = new AABBd(vector3dc, (Vector3dc)VectorConversionsMCKt.toJOML(vec32)).correctBounds();
        Intrinsics.checkNotNullExpressionValue((Object)aABBd, (String)"correctBounds(...)");
        AABBdc clipAABB = (AABBdc)aABBd;
        LineSegmentf clipSegment = new LineSegmentf((Vector3fc)ctx.m_45702_().m_252839_(), (Vector3fc)ctx.m_45693_().m_252839_());
        for (LoadedShip ship : VSGameUtilsKt.getShipObjectWorld($this$clipIncludeShips).getLoadedShips().getIntersecting(clipAABB)) {
            ClientShip clientShip;
            ClientShip worldToShip;
            ClientShip clientShip2;
            Vector2d chopParam = new Vector2d();
            AABBd expandedAABB = AABBdUtilKt.expand((AABBd)new AABBd(ship.getWorldAABB()), (double)1.0);
            int intersectType = expandedAABB.intersectsLineSegment(clipSegment, chopParam);
            if (intersectType == -1) continue;
            Long l2 = skipShip;
            if (l2 != null && ship.getId() == l2.longValue()) continue;
            Vector3d choppedFrom = null;
            Vector3d choppedTo = null;
            switch (intersectType) {
                case 2: {
                    Vec3 vec33 = ctx.m_45702_();
                    Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"getFrom(...)");
                    Vector3d vector3d = VectorConversionsMCKt.toJOML(vec33);
                    Vec3 vec34 = ctx.m_45693_();
                    Intrinsics.checkNotNullExpressionValue((Object)vec34, (String)"getTo(...)");
                    Vector3d vector3d2 = VectorConversionsMCKt.toJOML(vec34);
                    Vec3 vec35 = ctx.m_45702_();
                    Intrinsics.checkNotNullExpressionValue((Object)vec35, (String)"getFrom(...)");
                    Vector3d vector3d3 = vector3d.add((Vector3dc)vector3d2.sub((Vector3dc)VectorConversionsMCKt.toJOML(vec35)).mul(chopParam.x));
                    Intrinsics.checkNotNullExpressionValue((Object)vector3d3, (String)"add(...)");
                    choppedFrom = vector3d3;
                    Vec3 vec36 = ctx.m_45702_();
                    Intrinsics.checkNotNullExpressionValue((Object)vec36, (String)"getFrom(...)");
                    Vector3d vector3d4 = VectorConversionsMCKt.toJOML(vec36);
                    Vec3 vec37 = ctx.m_45693_();
                    Intrinsics.checkNotNullExpressionValue((Object)vec37, (String)"getTo(...)");
                    Vector3d vector3d5 = VectorConversionsMCKt.toJOML(vec37);
                    Vec3 vec38 = ctx.m_45702_();
                    Intrinsics.checkNotNullExpressionValue((Object)vec38, (String)"getFrom(...)");
                    Vector3d vector3d6 = vector3d4.add((Vector3dc)vector3d5.sub((Vector3dc)VectorConversionsMCKt.toJOML(vec38)).mul(chopParam.y));
                    Intrinsics.checkNotNullExpressionValue((Object)vector3d6, (String)"add(...)");
                    choppedTo = vector3d6;
                    break;
                }
                case 1: {
                    Vec3 vec39 = ctx.m_45702_();
                    Intrinsics.checkNotNullExpressionValue((Object)vec39, (String)"getFrom(...)");
                    if (expandedAABB.containsPoint((Vector3dc)VectorConversionsMCKt.toJOML(vec39))) {
                        Vec3 vec310 = ctx.m_45702_();
                        Intrinsics.checkNotNullExpressionValue((Object)vec310, (String)"getFrom(...)");
                        choppedFrom = VectorConversionsMCKt.toJOML(vec310);
                        Vec3 vec311 = ctx.m_45702_();
                        Intrinsics.checkNotNullExpressionValue((Object)vec311, (String)"getFrom(...)");
                        Vector3d vector3d = VectorConversionsMCKt.toJOML(vec311);
                        Vec3 vec312 = ctx.m_45693_();
                        Intrinsics.checkNotNullExpressionValue((Object)vec312, (String)"getTo(...)");
                        Vector3d vector3d7 = VectorConversionsMCKt.toJOML(vec312);
                        Vec3 vec313 = ctx.m_45702_();
                        Intrinsics.checkNotNullExpressionValue((Object)vec313, (String)"getFrom(...)");
                        Vector3d vector3d8 = vector3d.add((Vector3dc)vector3d7.sub((Vector3dc)VectorConversionsMCKt.toJOML(vec313)).mul(chopParam.y));
                        Intrinsics.checkNotNullExpressionValue((Object)vector3d8, (String)"add(...)");
                        choppedTo = vector3d8;
                        break;
                    }
                    Vec3 vec314 = ctx.m_45702_();
                    Intrinsics.checkNotNullExpressionValue((Object)vec314, (String)"getFrom(...)");
                    Vector3d vector3d = VectorConversionsMCKt.toJOML(vec314);
                    Vec3 vec315 = ctx.m_45693_();
                    Intrinsics.checkNotNullExpressionValue((Object)vec315, (String)"getTo(...)");
                    Vector3d vector3d9 = VectorConversionsMCKt.toJOML(vec315);
                    Vec3 vec316 = ctx.m_45702_();
                    Intrinsics.checkNotNullExpressionValue((Object)vec316, (String)"getFrom(...)");
                    Vector3d vector3d10 = vector3d.add((Vector3dc)vector3d9.sub((Vector3dc)VectorConversionsMCKt.toJOML(vec316)).mul(chopParam.x));
                    Intrinsics.checkNotNullExpressionValue((Object)vector3d10, (String)"add(...)");
                    choppedFrom = vector3d10;
                    Vec3 vec317 = ctx.m_45693_();
                    Intrinsics.checkNotNullExpressionValue((Object)vec317, (String)"getTo(...)");
                    choppedTo = VectorConversionsMCKt.toJOML(vec317);
                    break;
                }
                default: {
                    Vec3 vec318 = ctx.m_45702_();
                    Intrinsics.checkNotNullExpressionValue((Object)vec318, (String)"getFrom(...)");
                    choppedFrom = VectorConversionsMCKt.toJOML(vec318);
                    Vec3 vec319 = ctx.m_45693_();
                    Intrinsics.checkNotNullExpressionValue((Object)vec319, (String)"getTo(...)");
                    choppedTo = VectorConversionsMCKt.toJOML(vec319);
                }
            }
            if ((clientShip2 = ship instanceof ClientShip ? (ClientShip)ship : null) == null || (clientShip2 = clientShip2.getRenderTransform()) == null || (clientShip2 = clientShip2.getWorldToShipMatrix()) == null) {
                clientShip2 = worldToShip = ship.getWorldToShip();
            }
            if ((clientShip = ship instanceof ClientShip ? (ClientShip)ship : null) == null || (clientShip = clientShip.getRenderTransform()) == null || (clientShip = clientShip.getShipToWorldMatrix()) == null) {
                clientShip = ship.getShipToWorld();
            }
            ClientShip shipToWorld = clientShip;
            Vector3d vector3d = worldToShip.transformPosition(choppedFrom);
            Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"transformPosition(...)");
            Vec3 shipStart = VectorConversionsMCKt.toMinecraft((Vector3dc)vector3d);
            Vector3d vector3d11 = worldToShip.transformPosition(choppedTo);
            Intrinsics.checkNotNullExpressionValue((Object)vector3d11, (String)"transformPosition(...)");
            Vec3 shipEnd = VectorConversionsMCKt.toMinecraft((Vector3dc)vector3d11);
            BlockHitResult shipHit = RaycastUtilsKt.clip($this$clipIncludeShips, ctx, shipStart, shipEnd);
            Vec3 vec320 = shipHit.f_82445_;
            Intrinsics.checkNotNullExpressionValue((Object)vec320, (String)"location");
            Vector3d vector3d12 = shipToWorld.transformPosition(VectorConversionsMCKt.toJOML(vec320));
            Intrinsics.checkNotNullExpressionValue((Object)vector3d12, (String)"transformPosition(...)");
            Vec3 shipHitPos = VectorConversionsMCKt.toMinecraft((Vector3dc)vector3d12);
            double shipHitDist = shipHitPos.m_82557_(ctx.m_45702_());
            if (!(shipHitDist < closestHitDist) || shipHit.m_6662_() == HitResult.Type.MISS) continue;
            closestHit = shipHit;
            closestHitPos = shipHitPos;
            closestHitDist = shipHitDist;
        }
        if (shouldTransformHitPos) {
            closestHit.f_82445_ = closestHitPos;
        }
        BlockHitResult blockHitResult = closestHit;
        Intrinsics.checkNotNull((Object)blockHitResult);
        return blockHitResult;
    }

    public static /* synthetic */ BlockHitResult clipIncludeShips$default(Level level, ClipContext clipContext, boolean bl2, Long l2, boolean bl3, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl2 = true;
        }
        if ((n2 & 4) != 0) {
            l2 = null;
        }
        if ((n2 & 8) != 0) {
            bl3 = false;
        }
        return RaycastUtilsKt.clipIncludeShips(level, clipContext, bl2, l2, bl3);
    }

    private static final BlockHitResult clip(Level $this$clip, ClipContext context, Vec3 realStart, Vec3 realEnd) {
        BlockHitResult blockHitResult = RaycastUtilsKt.clip(realStart, realEnd, context, (arg_0, arg_1) -> RaycastUtilsKt.clip$lambda$0($this$clip, realStart, realEnd, arg_0, arg_1), arg_0 -> RaycastUtilsKt.clip$lambda$1(realStart, realEnd, arg_0));
        Intrinsics.checkNotNull((Object)blockHitResult, (String)"null cannot be cast to non-null type net.minecraft.world.phys.BlockHitResult");
        return blockHitResult;
    }

    private static final <T> T clip(Vec3 realStart, Vec3 realEnd, ClipContext raycastContext, BiFunction<ClipContext, BlockPos, T> context, Function<ClipContext, T> blockRaycaster) {
        T t2;
        Vec3 vec3d = realStart;
        Vec3 vec3d2 = realEnd;
        if (Intrinsics.areEqual((Object)vec3d, (Object)vec3d2)) {
            t2 = blockRaycaster.apply(raycastContext);
        } else {
            int l2;
            int k2;
            double d2 = Mth.m_14139_((double)-1.0E-7, (double)vec3d2.f_82479_, (double)vec3d.f_82479_);
            double e2 = Mth.m_14139_((double)-1.0E-7, (double)vec3d2.f_82480_, (double)vec3d.f_82480_);
            double f2 = Mth.m_14139_((double)-1.0E-7, (double)vec3d2.f_82481_, (double)vec3d.f_82481_);
            double g2 = Mth.m_14139_((double)-1.0E-7, (double)vec3d.f_82479_, (double)vec3d2.f_82479_);
            double h2 = Mth.m_14139_((double)-1.0E-7, (double)vec3d.f_82480_, (double)vec3d2.f_82480_);
            double i2 = Mth.m_14139_((double)-1.0E-7, (double)vec3d.f_82481_, (double)vec3d2.f_82481_);
            int j2 = Mth.m_14107_((double)g2);
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(j2, k2 = Mth.m_14107_((double)h2), l2 = Mth.m_14107_((double)i2));
            T object = context.apply(raycastContext, (BlockPos)mutable);
            if (object != null) {
                t2 = object;
            } else {
                double m2 = d2 - g2;
                double n2 = e2 - h2;
                double o2 = f2 - i2;
                int p2 = Mth.m_14205_((double)m2);
                int q2 = Mth.m_14205_((double)n2);
                int r2 = Mth.m_14205_((double)o2);
                double s2 = p2 == 0 ? Double.MAX_VALUE : (double)p2 / m2;
                double t3 = q2 == 0 ? Double.MAX_VALUE : (double)q2 / n2;
                double u2 = r2 == 0 ? Double.MAX_VALUE : (double)r2 / o2;
                double v2 = s2 * (p2 > 0 ? 1.0 - Mth.m_14185_((double)g2) : Mth.m_14185_((double)g2));
                double w2 = t3 * (q2 > 0 ? 1.0 - Mth.m_14185_((double)h2) : Mth.m_14185_((double)h2));
                double x2 = u2 * (r2 > 0 ? 1.0 - Mth.m_14185_((double)i2) : Mth.m_14185_((double)i2));
                Object object2 = null;
                do {
                    if (v2 > 1.0 && w2 > 1.0 && x2 > 1.0) {
                        return blockRaycaster.apply(raycastContext);
                    }
                    if (v2 < w2) {
                        if (v2 < x2) {
                            j2 += p2;
                            v2 += s2;
                            continue;
                        }
                        l2 += r2;
                        x2 += u2;
                        continue;
                    }
                    if (w2 < x2) {
                        k2 += q2;
                        w2 += t3;
                        continue;
                    }
                    l2 += r2;
                    x2 += u2;
                } while ((object2 = context.apply(raycastContext, (BlockPos)mutable.m_122178_(j2, k2, l2))) == null);
                t2 = object2;
            }
        }
        return t2;
    }

    @Nullable
    public static final EntityHitResult raytraceEntities(@NotNull Level $this$raytraceEntities, @NotNull Entity shooter, @NotNull Vec3 origStartVecM, @NotNull Vec3 origEndVecM, @NotNull AABB origBoundingBoxM, @NotNull Predicate<Entity> filter, double maxDistance2) {
        Intrinsics.checkNotNullParameter((Object)$this$raytraceEntities, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)shooter, (String)"shooter");
        Intrinsics.checkNotNullParameter((Object)origStartVecM, (String)"origStartVecM");
        Intrinsics.checkNotNullParameter((Object)origEndVecM, (String)"origEndVecM");
        Intrinsics.checkNotNullParameter((Object)origBoundingBoxM, (String)"origBoundingBoxM");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        Ref.DoubleRef distance2 = new Ref.DoubleRef();
        distance2.element = maxDistance2;
        Ref.ObjectRef resultEntity = new Ref.ObjectRef();
        Ref.ObjectRef location = new Ref.ObjectRef();
        List entities = $this$raytraceEntities.m_6249_(shooter, origBoundingBoxM, filter);
        Intrinsics.checkNotNull((Object)entities);
        RaycastUtilsKt.raytraceEntities$checkEntities(distance2, (Ref.ObjectRef<Entity>)resultEntity, (Ref.ObjectRef<Vec3>)location, shooter, entities, origStartVecM, origEndVecM, 1.0);
        Vector3d origStartVec = VectorConversionsMCKt.toJOML(origStartVecM);
        Vector3d origEndVec = VectorConversionsMCKt.toJOML(origEndVecM);
        Vector3d start = new Vector3d();
        Vector3d end = new Vector3d();
        Iterable $this$forEach$iv = VSGameUtilsKt.getShipObjectWorld($this$raytraceEntities).getLoadedShips().getIntersecting((AABBdc)VectorConversionsMCKt.toJOML(origBoundingBoxM));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LoadedShip it2 = (LoadedShip)element$iv;
            boolean bl2 = false;
            it2.getWorldToShip().transformPosition((Vector3dc)origStartVec, start);
            it2.getWorldToShip().transformPosition((Vector3dc)origEndVec, end);
            double scale = 1.0 / it2.getTransform().getShipToWorldScaling().x();
            RaycastUtilsKt.raytraceEntities$checkEntities(distance2, (Ref.ObjectRef<Entity>)resultEntity, (Ref.ObjectRef<Vec3>)location, shooter, entities, VectorConversionsMCKt.toMinecraft((Vector3dc)start), VectorConversionsMCKt.toMinecraft((Vector3dc)end), scale);
        }
        return resultEntity.element == null ? null : new EntityHitResult((Entity)resultEntity.element, (Vec3)location.element);
    }

    @NotNull
    public static final BlockHitResult vanillaClip(@NotNull BlockGetter $this$vanillaClip, @NotNull ClipContext context) {
        Intrinsics.checkNotNullParameter((Object)$this$vanillaClip, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = BlockGetter.m_151361_((Vec3)context.m_45702_(), (Vec3)context.m_45693_(), (Object)context, (arg_0, arg_1) -> RaycastUtilsKt.vanillaClip$lambda$4($this$vanillaClip, arg_0, arg_1), RaycastUtilsKt::vanillaClip$lambda$5);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"traverseBlocks(...)");
        return (BlockHitResult)object;
    }

    @JvmOverloads
    @NotNull
    public static final BlockHitResult clipIncludeShips(@NotNull Level $this$clipIncludeShips, @NotNull ClipContext ctx, boolean shouldTransformHitPos, @Nullable Long skipShip) {
        Intrinsics.checkNotNullParameter((Object)$this$clipIncludeShips, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return RaycastUtilsKt.clipIncludeShips$default($this$clipIncludeShips, ctx, shouldTransformHitPos, skipShip, false, 8, null);
    }

    @JvmOverloads
    @NotNull
    public static final BlockHitResult clipIncludeShips(@NotNull Level $this$clipIncludeShips, @NotNull ClipContext ctx, boolean shouldTransformHitPos) {
        Intrinsics.checkNotNullParameter((Object)$this$clipIncludeShips, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return RaycastUtilsKt.clipIncludeShips$default($this$clipIncludeShips, ctx, shouldTransformHitPos, null, false, 12, null);
    }

    @JvmOverloads
    @NotNull
    public static final BlockHitResult clipIncludeShips(@NotNull Level $this$clipIncludeShips, @NotNull ClipContext ctx) {
        Intrinsics.checkNotNullParameter((Object)$this$clipIncludeShips, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return RaycastUtilsKt.clipIncludeShips$default($this$clipIncludeShips, ctx, false, null, false, 14, null);
    }

    private static final BlockHitResult clip$lambda$0(Level $this_clip, Vec3 $realStart, Vec3 $realEnd, ClipContext raycastContext, BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)$this_clip, (String)"$this_clip");
        Intrinsics.checkNotNullParameter((Object)$realStart, (String)"$realStart");
        Intrinsics.checkNotNullParameter((Object)$realEnd, (String)"$realEnd");
        Intrinsics.checkNotNullParameter((Object)raycastContext, (String)"raycastContext");
        BlockPos blockPos2 = blockPos;
        Intrinsics.checkNotNull((Object)blockPos2);
        BlockState blockState = $this_clip.m_8055_(blockPos2);
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
        BlockState blockState2 = blockState;
        FluidState fluidState = $this_clip.m_6425_(blockPos);
        Intrinsics.checkNotNullExpressionValue((Object)fluidState, (String)"getFluidState(...)");
        FluidState fluidState2 = fluidState;
        Vec3 vec3d = $realStart;
        Vec3 vec3d2 = $realEnd;
        VoxelShape voxelShape = raycastContext.m_45694_(blockState2, (BlockGetter)$this_clip, blockPos);
        BlockHitResult blockHitResult = $this_clip.m_45558_(vec3d, vec3d2, blockPos, voxelShape, blockState2);
        VoxelShape voxelShape2 = raycastContext.m_45698_(fluidState2, (BlockGetter)$this_clip, blockPos);
        BlockHitResult blockHitResult2 = voxelShape2.m_83220_(vec3d, vec3d2, blockPos);
        BlockHitResult blockHitResult3 = blockHitResult;
        double d2 = blockHitResult3 == null ? Double.MAX_VALUE : $realStart.m_82557_(blockHitResult3.f_82445_);
        BlockHitResult blockHitResult4 = blockHitResult2;
        double e2 = blockHitResult4 == null ? Double.MAX_VALUE : $realEnd.m_82557_(blockHitResult4.f_82445_);
        return d2 <= e2 ? blockHitResult : blockHitResult2;
    }

    private static final BlockHitResult clip$lambda$1(Vec3 $realStart, Vec3 $realEnd, ClipContext raycastContext) {
        Intrinsics.checkNotNullParameter((Object)$realStart, (String)"$realStart");
        Intrinsics.checkNotNullParameter((Object)$realEnd, (String)"$realEnd");
        Intrinsics.checkNotNullParameter((Object)raycastContext, (String)"raycastContext");
        Vec3 vec3d = $realStart.m_82546_($realEnd);
        return BlockHitResult.m_82426_((Vec3)$realEnd, (Direction)Direction.m_122366_((double)vec3d.f_82479_, (double)vec3d.f_82480_, (double)vec3d.f_82481_), (BlockPos)BlockPos.m_274446_((Position)((Position)$realEnd)));
    }

    private static final void raytraceEntities$checkEntities(Ref.DoubleRef distance2, Ref.ObjectRef<Entity> resultEntity, Ref.ObjectRef<Vec3> location, Entity $shooter, List<? extends Entity> entities, Vec3 startVec, Vec3 endVec, double scale) {
        Iterable $this$forEach$iv = entities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity entity = (Entity)element$iv;
            boolean bl2 = false;
            AABB aABB = entity.m_20191_().m_82400_((double)entity.m_6143_());
            Intrinsics.checkNotNullExpressionValue((Object)aABB, (String)"inflate(...)");
            AABB aabb = McMathUtilKt.scale(aABB, scale);
            Optional clipO = aabb.m_82371_(startVec, endVec);
            if (aabb.m_82390_(startVec)) {
                if (distance2.element < 0.0) continue;
                resultEntity.element = entity;
                location.element = clipO.orElse(startVec);
                distance2.element = 0.0;
                continue;
            }
            if (!clipO.isPresent()) continue;
            Object t2 = clipO.get();
            Intrinsics.checkNotNullExpressionValue(t2, (String)"get(...)");
            Vec3 clip = (Vec3)t2;
            double d2 = startVec.m_82557_(clip) / (scale * scale);
            if (d2 >= distance2.element && !(distance2.element == 0.0)) continue;
            if (entity.m_20201_() == $shooter.m_20201_()) {
                if (!(distance2.element == 0.0)) continue;
                resultEntity.element = entity;
                location.element = clip;
                continue;
            }
            resultEntity.element = entity;
            location.element = clip;
            distance2.element = d2;
        }
    }

    private static final BlockHitResult vanillaClip$lambda$4(BlockGetter $this_vanillaClip, ClipContext clipContext, BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)$this_vanillaClip, (String)"$this_vanillaClip");
        Intrinsics.checkNotNullParameter((Object)clipContext, (String)"clipContext");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        BlockState blockState = $this_vanillaClip.m_8055_(blockPos);
        FluidState fluidState = $this_vanillaClip.m_6425_(blockPos);
        Vec3 vec3 = clipContext.m_45702_();
        Vec3 vec32 = clipContext.m_45693_();
        VoxelShape voxelShape = clipContext.m_45694_(blockState, $this_vanillaClip, blockPos);
        BlockHitResult blockHitResult = $this_vanillaClip.m_45558_(vec3, vec32, blockPos, voxelShape, blockState);
        VoxelShape voxelShape2 = clipContext.m_45698_(fluidState, $this_vanillaClip, blockPos);
        BlockHitResult blockHitResult2 = voxelShape2.m_83220_(vec3, vec32, blockPos);
        double d2 = blockHitResult == null ? Double.MAX_VALUE : clipContext.m_45702_().m_82557_(blockHitResult.f_82445_);
        double e2 = blockHitResult2 == null ? Double.MAX_VALUE : clipContext.m_45702_().m_82557_(blockHitResult2.f_82445_);
        return d2 <= e2 ? blockHitResult : blockHitResult2;
    }

    private static final BlockHitResult vanillaClip$lambda$5(ClipContext ctx) {
        Vec3 vec3 = ctx.m_45702_().m_82546_(ctx.m_45693_());
        return BlockHitResult.m_82426_((Vec3)ctx.m_45693_(), (Direction)Direction.m_122366_((double)vec3.f_82479_, (double)vec3.f_82480_, (double)vec3.f_82481_), (BlockPos)BlockPos.m_274446_((Position)((Position)ctx.m_45693_())));
    }
}

