/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.feature.fluid_camera_fix;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.client.Camera;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Mixin(value={Camera.class})
public abstract class MixinCamera {
    @Unique
    private boolean isShipWater = false;

    @Shadow
    public abstract Vec3 m_90583_();

    @WrapOperation(at={@At(value="INVOKE", target="Lnet/minecraft/world/level/BlockGetter;getFluidState(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/material/FluidState;")}, method={"getFluidInCamera"})
    private FluidState getFluidInCamera(BlockGetter instance, BlockPos blockPos, Operation<FluidState> getFluidState) {
        FluidState[] fluidState = new FluidState[]{(FluidState)getFluidState.call(new Object[]{instance, blockPos})};
        this.isShipWater = false;
        if (fluidState[0].m_76178_() && instance instanceof Level) {
            Level level = (Level)instance;
            double origX = this.m_90583_().f_82479_;
            double origY = this.m_90583_().f_82480_;
            double origZ = this.m_90583_().f_82481_;
            VSGameUtilsKt.transformToNearbyShipsAndWorld(level, origX, origY, origZ, 1.0, (x2, y2, z2) -> {
                fluidState[0] = instance.m_8055_(BlockPos.m_274561_((double)x2, (double)y2, (double)z2)).m_60819_();
                if (!fluidState[0].m_76178_()) {
                    this.isShipWater = true;
                }
            });
        }
        return fluidState[0];
    }

    @WrapOperation(at={@At(value="INVOKE", target="Lnet/minecraft/world/level/material/FluidState;getHeight(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)F")}, method={"getFluidInCamera"})
    private float fluidHeightOverride(FluidState instance, BlockGetter arg, BlockPos arg2, Operation<Float> getHeight) {
        if (!instance.m_76178_() && this.isShipWater && instance.m_76170_()) {
            return 1.0f;
        }
        return ((Float)getHeight.call(new Object[]{instance, arg, arg2})).floatValue();
    }
}

