/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.mod_compat.create;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.simibubi.create.content.kinetics.fan.AirCurrent;
import com.simibubi.create.content.kinetics.fan.AirFlowParticle;
import com.simibubi.create.content.kinetics.fan.IAirCurrentSource;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.mod.mixinducks.mod_compat.create.IExtendedAirCurrentSource;

@Mixin(value={AirFlowParticle.class})
public abstract class MixinAirFlowParticle
extends SimpleAnimatedParticle {
    @Shadow
    @Final
    private IAirCurrentSource source;

    protected MixinAirFlowParticle(ClientLevel level, double x2, double y2, double z2, SpriteSet sprites, float gravity) {
        super(level, x2, y2, z2, sprites, gravity);
    }

    @WrapOperation(method={"<init>"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/kinetics/fan/AirFlowParticle;setPos(DDD)V")})
    private void setPos(AirFlowParticle particle, double x2, double y2, double z2, Operation<Void> original) {
        Ship ship = this.getShip();
        if (ship != null) {
            Vector3d p2 = new Vector3d(x2, y2, z2);
            ship.getPrevTickTransform().getWorldToShip().transformPosition(p2);
            ship.getTransform().getShipToWorld().transformPosition(p2);
            original.call(new Object[]{particle, p2.x, p2.y, p2.z});
            return;
        }
        original.call(new Object[]{particle, x2, y2, z2});
    }

    @Unique
    private Ship getShip() {
        IAirCurrentSource iAirCurrentSource = this.source;
        if (iAirCurrentSource instanceof IExtendedAirCurrentSource) {
            IExtendedAirCurrentSource se2 = (IExtendedAirCurrentSource)iAirCurrentSource;
            return se2.getShip();
        }
        if (this.source.getAirCurrentWorld() != null) {
            return VSGameUtilsKt.getShipManagingPos(this.source.getAirCurrentWorld(), this.source.getAirCurrentPos());
        }
        return null;
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/AABB;contains(DDD)Z"))
    private boolean redirectBounds(AABB instance, double x2, double y2, double z2) {
        AirCurrent current = this.source.getAirCurrent();
        Level level = this.source.getAirCurrentWorld();
        Ship ship = this.getShip();
        if (current != null && level != null && ship != null) {
            Vector3d tempPos = ship.getTransform().getWorldToShip().transformPosition(x2, y2, z2, new Vector3d());
            return instance.m_82393_(tempPos.x, tempPos.y, tempPos.z);
        }
        return instance.m_82393_(x2, y2, z2);
    }

    @WrapOperation(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/phys/Vec3;subtract(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;")})
    private Vec3 transformPosToShip(Vec3 instance, Vec3 vec3, Operation<Vec3> original) {
        Ship ship = this.getShip();
        if (ship != null) {
            instance = VectorConversionsMCKt.toMinecraft((Vector3dc)ship.getWorldToShip().transformPosition(VectorConversionsMCKt.toJOML(instance)));
        }
        return (Vec3)original.call(new Object[]{instance, vec3});
    }

    @WrapOperation(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/phys/Vec3;scale(D)Lnet/minecraft/world/phys/Vec3;", ordinal=0)})
    private Vec3 transformDirectionForMotion(Vec3 dir, double d2, Operation<Vec3> original) {
        Ship ship = this.getShip();
        if (ship != null) {
            Vector3d tempVec = new Vector3d();
            ship.getTransform().getShipToWorld().transformDirection(dir.f_82479_, dir.f_82480_, dir.f_82481_, tempVec);
            dir = VectorConversionsMCKt.toMinecraft((Vector3dc)tempVec);
        }
        return (Vec3)original.call(new Object[]{dir, d2});
    }

    @WrapOperation(method={"tick"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/kinetics/fan/AirFlowParticle;move(DDD)V")})
    private void moveWithShip(AirFlowParticle particle, double x2, double y2, double z2, Operation<Void> original) {
        original.call(new Object[]{particle, x2, y2, z2});
        Ship ship = this.getShip();
        if (ship != null) {
            Vector3d p2 = new Vector3d(this.f_107212_, this.f_107213_, this.f_107214_);
            ship.getPrevTickTransform().getWorldToShip().transformPosition(p2);
            ship.getTransform().getShipToWorld().transformPosition(p2);
            this.f_107215_ = p2.x - this.f_107209_;
            this.f_107216_ = p2.y - this.f_107210_;
            this.f_107217_ = p2.z - this.f_107211_;
            this.m_107264_(p2.x, p2.y, p2.z);
        }
    }
}

