/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.mod_compat.create.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Iterator;
import net.createmod.catnip.outliner.BlockClusterOutline;
import net.createmod.catnip.outliner.Outline;
import net.createmod.catnip.render.BindableTexture;
import net.createmod.catnip.render.PonderRenderTypes;
import net.createmod.catnip.render.SuperRenderTypeBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.mod.mixin.mod_compat.create.accessors.OutlineParamsAccessor;
import org.valkyrienskies.mod.mixinducks.mod_compat.create.CWCluster;

@Mixin(value={BlockClusterOutline.class})
public abstract class MixinBlockClusterOutline
extends Outline {
    @Unique
    private CWCluster cw$cluster = null;
    @Shadow
    @Final
    protected Vector3f originTemp;

    @Shadow
    protected abstract void bufferBlockFace(PoseStack.Pose var1, VertexConsumer var2, BlockPos var3, Direction var4, Vector4f var5, int var6);

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void postInit(Iterable<BlockPos> positions, CallbackInfo ci2) {
        ClientLevel level;
        BlockPos firstPos;
        Iterator<BlockPos> iterator2 = positions.iterator();
        BlockPos blockPos = firstPos = iterator2.hasNext() ? iterator2.next() : null;
        if (firstPos != null && (level = Minecraft.m_91087_().f_91073_) != null && VSGameUtilsKt.getShipManagingPos((Level)level, firstPos) != null) {
            this.cw$cluster = new CWCluster();
            positions.forEach(this.cw$cluster::include);
        }
    }

    @Inject(method={"renderFaces"}, at={@At(value="HEAD")}, cancellable=true)
    private void preRenderFaces(PoseStack ms2, SuperRenderTypeBuffer buffer, Vec3 camera, float pt2, Vector4f color, int lightmap, CallbackInfo ci2) {
        if (this.cw$cluster != null) {
            BlockPos anchorPos = this.cw$cluster.anchor;
            if (anchorPos == null) {
                return;
            }
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            ClientShip ship = (ClientShip)VSGameUtilsKt.getShipManagingPos((Level)level, anchorPos);
            if (ship != null) {
                BindableTexture faceTexture = ((OutlineParamsAccessor)this.params).getFaceTexture();
                if (faceTexture == null) {
                    return;
                }
                ShipTransform renderTransform = ship.getRenderTransform();
                ms2.m_85836_();
                ms2.m_85837_(renderTransform.getPositionInWorld().x() - camera.f_82479_, renderTransform.getPositionInWorld().y() - camera.f_82480_, renderTransform.getPositionInWorld().z() - camera.f_82481_);
                ms2.m_85841_((float)renderTransform.getShipToWorldScaling().x(), (float)renderTransform.getShipToWorldScaling().y(), (float)renderTransform.getShipToWorldScaling().z());
                ms2.m_252781_(VectorConversionsMCKt.toFloat(renderTransform.getShipToWorldRotation()));
                ms2.m_85837_((double)this.cw$cluster.anchor.m_123341_() - renderTransform.getPositionInShip().x(), (double)this.cw$cluster.anchor.m_123342_() - renderTransform.getPositionInShip().y(), (double)this.cw$cluster.anchor.m_123343_() - renderTransform.getPositionInShip().z());
                PoseStack.Pose pose = ms2.m_85850_();
                RenderType renderType = PonderRenderTypes.outlineTranslucent((ResourceLocation)faceTexture.getLocation(), (boolean)true);
                VertexConsumer consumer = buffer.getLateBuffer(renderType);
                this.cw$cluster.visibleFaces.forEach((face, axisDirection) -> {
                    Direction direction = Direction.m_122390_((Direction.AxisDirection)axisDirection, (Direction.Axis)face.axis);
                    BlockPos pos = face.pos;
                    if (axisDirection == Direction.AxisDirection.POSITIVE) {
                        pos = pos.m_121945_(direction.m_122424_());
                    }
                    this.bufferBlockFace(pose, consumer, pos, direction, color, lightmap);
                });
                ms2.m_85849_();
                ci2.cancel();
            }
        }
    }

    @Inject(method={"renderEdges"}, at={@At(value="HEAD")}, cancellable=true)
    private void preRenderEdges(PoseStack ms2, SuperRenderTypeBuffer buffer, Vec3 camera, float pt2, Vector4f color, int lightmap, boolean disableNormals, CallbackInfo ci2) {
        if (this.cw$cluster != null) {
            BlockPos anchorPos = this.cw$cluster.anchor;
            if (anchorPos == null) {
                return;
            }
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            ClientShip ship = (ClientShip)VSGameUtilsKt.getShipManagingPos((Level)level, anchorPos);
            if (ship != null) {
                float lineWidth = this.params.getLineWidth();
                if (lineWidth == 0.0f) {
                    return;
                }
                if (this.cw$cluster.isEmpty()) {
                    return;
                }
                ShipTransform renderTransform = ship.getRenderTransform();
                ms2.m_85836_();
                ms2.m_85837_(renderTransform.getPositionInWorld().x() - camera.f_82479_, renderTransform.getPositionInWorld().y() - camera.f_82480_, renderTransform.getPositionInWorld().z() - camera.f_82481_);
                ms2.m_85841_((float)renderTransform.getShipToWorldScaling().x(), (float)renderTransform.getShipToWorldScaling().y(), (float)renderTransform.getShipToWorldScaling().z());
                ms2.m_252781_(VectorConversionsMCKt.toFloat(renderTransform.getShipToWorldRotation()));
                ms2.m_85837_((double)this.cw$cluster.anchor.m_123341_() - renderTransform.getPositionInShip().x(), (double)this.cw$cluster.anchor.m_123342_() - renderTransform.getPositionInShip().y(), (double)this.cw$cluster.anchor.m_123343_() - renderTransform.getPositionInShip().z());
                PoseStack.Pose pose = ms2.m_85850_();
                VertexConsumer consumer = buffer.m_6299_(PonderRenderTypes.outlineSolid());
                this.cw$cluster.visibleEdges.forEach(edge -> {
                    BlockPos pos = edge.pos;
                    Vector3f origin = this.originTemp;
                    origin.set((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
                    Direction direction = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)edge.axis);
                    this.bufferCuboidLine(pose, consumer, origin, direction, 1.0f, lineWidth, color, lightmap, disableNormals);
                });
                ms2.m_85849_();
                ci2.cancel();
            }
        }
    }
}

