/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.server.world;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.core.apigame.world.IPlayer;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.MinecraftPlayer;

@Mixin(value={ChunkMap.class})
public abstract class MixinChunkMap {
    @Shadow
    @Final
    ServerLevel f_140133_;
    @Shadow
    @Final
    private Supplier<DimensionDataStorage> f_140137_;

    @Inject(method={"getPlayers"}, at={@At(value="TAIL")}, cancellable=true)
    private void postGetPlayersWatchingChunk(ChunkPos chunkPos, boolean onlyOnWatchDistanceEdge, CallbackInfoReturnable<List<ServerPlayer>> cir) {
        Iterator<IPlayer> playersWatchingShipChunk = VSGameUtilsKt.getShipObjectWorld(this.f_140133_).getIPlayersWatchingShipChunk(chunkPos.f_45578_, chunkPos.f_45579_, VSGameUtilsKt.getDimensionId((Level)this.f_140133_));
        if (!playersWatchingShipChunk.hasNext()) {
            return;
        }
        List oldReturnValue = (List)cir.getReturnValue();
        HashSet watchingPlayers = new HashSet(oldReturnValue);
        playersWatchingShipChunk.forEachRemaining(iPlayer -> {
            MinecraftPlayer minecraftPlayer = (MinecraftPlayer)iPlayer;
            ServerPlayer playerEntity = (ServerPlayer)minecraftPlayer.getPlayerEntityReference().get();
            if (playerEntity != null) {
                watchingPlayers.add(playerEntity);
            }
        });
        cir.setReturnValue(new ArrayList(watchingPlayers));
    }
}

