/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.util;

import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public final class BlockWalker {
    private BlockPos.MutableBlockPos nextValue = new BlockPos.MutableBlockPos();
    private final int xStep;
    private final int yStep;
    private final int zStep;
    private final double xPartialStep;
    private final double yPartialStep;
    private final double zPartialStep;
    private int x;
    private int y;
    private int z;
    private double xPartial;
    private double yPartial;
    private double zPartial;

    public BlockWalker(Vec3 from, Vec3 to2) {
        if (from.equals((Object)to2)) {
            this.nextValue = null;
            this.xStep = 0;
            this.yStep = 0;
            this.zStep = 0;
            this.xPartialStep = 0.0;
            this.yPartialStep = 0.0;
            this.zPartialStep = 0.0;
            return;
        }
        double afterToX = Mth.m_14139_((double)-1.0E-7, (double)to2.f_82479_, (double)from.f_82479_);
        double afterToY = Mth.m_14139_((double)-1.0E-7, (double)to2.f_82480_, (double)from.f_82480_);
        double afterToZ = Mth.m_14139_((double)-1.0E-7, (double)to2.f_82481_, (double)from.f_82481_);
        double beforeFromX = Mth.m_14139_((double)-1.0E-7, (double)from.f_82479_, (double)to2.f_82479_);
        double beforeFromY = Mth.m_14139_((double)-1.0E-7, (double)from.f_82480_, (double)to2.f_82480_);
        double beforeFromZ = Mth.m_14139_((double)-1.0E-7, (double)from.f_82481_, (double)to2.f_82481_);
        this.x = Mth.m_14107_((double)beforeFromX);
        this.y = Mth.m_14107_((double)beforeFromY);
        this.z = Mth.m_14107_((double)beforeFromZ);
        double xDiff = afterToX - beforeFromX;
        double yDiff = afterToY - beforeFromY;
        double zDiff = afterToZ - beforeFromZ;
        this.xStep = Mth.m_14205_((double)xDiff);
        this.yStep = Mth.m_14205_((double)yDiff);
        this.zStep = Mth.m_14205_((double)zDiff);
        this.xPartialStep = this.xStep == 0 ? Double.MAX_VALUE : (double)this.xStep / xDiff;
        this.yPartialStep = this.yStep == 0 ? Double.MAX_VALUE : (double)this.yStep / yDiff;
        this.zPartialStep = this.zStep == 0 ? Double.MAX_VALUE : (double)this.zStep / zDiff;
        this.xPartial = this.xPartialStep * (this.xStep > 0 ? 1.0 - Mth.m_14185_((double)beforeFromX) : Mth.m_14185_((double)beforeFromX));
        this.yPartial = this.yPartialStep * (this.yStep > 0 ? 1.0 - Mth.m_14185_((double)beforeFromY) : Mth.m_14185_((double)beforeFromY));
        this.zPartial = this.zPartialStep * (this.zStep > 0 ? 1.0 - Mth.m_14185_((double)beforeFromZ) : Mth.m_14185_((double)beforeFromZ));
    }

    public BlockPos value() {
        return this.nextValue == null ? null : this.nextValue.m_122178_(this.x, this.y, this.z);
    }

    public boolean next() {
        if (this.nextValue == null) {
            return false;
        }
        if (this.xPartial > 1.0 && this.yPartial > 1.0 && this.zPartial > 1.0) {
            this.nextValue = null;
            return false;
        }
        if (this.xPartial < this.yPartial) {
            if (this.xPartial < this.zPartial) {
                this.x += this.xStep;
                this.xPartial += this.xPartialStep;
            } else {
                this.z += this.zStep;
                this.zPartial += this.zPartialStep;
            }
        } else if (this.yPartial < this.zPartial) {
            this.y += this.yStep;
            this.yPartial += this.yPartialStep;
        } else {
            this.z += this.zStep;
            this.zPartial += this.zPartialStep;
        }
        return true;
    }
}

