/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.mod_compat.flywheel;

import dev.engine_room.flywheel.lib.math.MoreMath;
import dev.engine_room.flywheel.lib.visual.EntityVisibilityTester;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import org.joml.FrustumIntersection;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Mixin(value={EntityVisibilityTester.class})
public class MixinEntityVisibilityTester {
    @Shadow
    @Final
    private Entity entity;
    @Shadow
    @Final
    private float scale;

    @Inject(method={"adjustAndTestAABB"}, at={@At(value="HEAD")}, cancellable=true)
    private void cullingOnShip(FrustumIntersection frustum, AABB aabb, CallbackInfoReturnable<Boolean> cir) {
        Ship ship = VSGameUtilsKt.getShipManaging(this.entity);
        if (ship instanceof ClientShip) {
            ClientShip ship2 = (ClientShip)ship;
            Vector3f pos = ship2.getRenderTransform().getShipToWorld().transformPosition(VectorConversionsMCKt.toJOML(this.entity.m_20182_())).get(new Vector3f());
            float maxSize = (float)Math.max(aabb.m_82362_(), Math.max(aabb.m_82376_(), aabb.m_82385_()));
            if (frustum.testSphere(pos.x, pos.y, pos.z, maxSize * MoreMath.SQRT_3_OVER_2 * this.scale)) {
                cir.setReturnValue((Object)true);
            }
        }
    }
}

