/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.server.command.level;

import com.mojang.authlib.GameProfile;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.joml.Vector3d;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Mixin(value={ServerPlayer.class})
public abstract class MixinServerPlayer
extends Player {
    public MixinServerPlayer(Level level, BlockPos blockPos, float f2, GameProfile gameProfile) {
        super(level, blockPos, f2, gameProfile);
    }

    @Shadow
    public abstract void m_6021_(double var1, double var3, double var5);

    @Shadow
    public abstract boolean m_264318_(ServerLevel var1, double var2, double var4, double var6, Set<RelativeMovement> var8, float var9, float var10);

    @Inject(at={@At(value="HEAD")}, method={"teleportTo(DDD)V"}, cancellable=true)
    private void beforeTeleportTo(double x2, double y2, double z2, CallbackInfo ci2) {
        ServerLevel level = ((ServerPlayer)this).m_284548_();
        ServerShip ship = VSGameUtilsKt.getShipManagingPos(level, x2, y2, z2);
        if (ship != null) {
            ci2.cancel();
            Vector3d inWorld = VSGameUtilsKt.toWorldCoordinates((Ship)ship, x2, y2, z2);
            this.m_6021_(inWorld.x, inWorld.y, inWorld.z);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"dismountTo"}, cancellable=true)
    private void beforeDismountTo(double x2, double y2, double z2, CallbackInfo ci2) {
        ServerLevel level = ((ServerPlayer)this).m_284548_();
        ServerShip ship = VSGameUtilsKt.getShipManagingPos(level, x2, y2, z2);
        if (ship != null) {
            ci2.cancel();
            Vector3d lookVector = VectorConversionsMCKt.toJOML(this.m_20154_());
            Vector3d transformedLook = ship.getTransform().getShipToWorld().transformDirection(lookVector);
            double yaw = Math.atan2(-transformedLook.x, transformedLook.z) * 180.0 / Math.PI;
            double pitch = Math.atan2(-transformedLook.y, Math.sqrt(transformedLook.x * transformedLook.x + transformedLook.z * transformedLook.z)) * 180.0 / Math.PI;
            this.m_146922_((float)yaw);
            this.m_146926_((float)pitch);
            Vector3d inWorld = VSGameUtilsKt.toWorldCoordinates((Ship)ship, x2, y2, z2);
            this.m_264318_(level, inWorld.x, inWorld.y, inWorld.z, Set.of(), this.m_146908_(), this.m_146909_());
        }
    }
}

