/*
 * Decompiled with CFR 0.152.
 */
package g_mungus.vlib.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import g_mungus.vlib.VLib;
import g_mungus.vlib.mixin.massCalculator.BitsetDiscreteVoxelShapeAccessor;
import g_mungus.vlib.util.CanAccessShape;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.mod.common.config.MassDatapackResolver;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\u001a\u0015\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u000b\u0010\f\"\u0014\u0010\u000e\u001a\u00020\r8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000f\"\u0014\u0010\u0010\u001a\u00020\r8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lnet/minecraft/world/level/Level;", "level", "", "calculateMasses", "(Lnet/minecraft/world/level/Level;)Ljava/lang/String;", "Ljava/io/File;", "sourceDir", "parentPath", "Ljava/util/zip/ZipOutputStream;", "zipOut", "", "zipDirectory", "(Ljava/io/File;Ljava/lang/String;Ljava/util/zip/ZipOutputStream;)V", "", "DEFAULT_DENSITY", "D", "MIN_MASS", "vlib"})
@SourceDebugExtension(value={"SMAP\nMassCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MassCalculator.kt\ng_mungus/vlib/util/MassCalculatorKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,164:1\n819#2:165\n847#2,2:166\n1855#2,2:168\n1855#2,2:170\n215#3,2:172\n13309#4,2:174\n*S KotlinDebug\n*F\n+ 1 MassCalculator.kt\ng_mungus/vlib/util/MassCalculatorKt\n*L\n27#1:165\n27#1:166,2\n31#1:168,2\n78#1:170,2\n100#1:172,2\n141#1:174,2\n*E\n"})
public final class MassCalculatorKt {
    public static final double DEFAULT_DENSITY = 1000.0;
    public static final double MIN_MASS = 10.0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final String calculateMasses(@NotNull Level level) {
        Object throwable;
        Object filePath;
        boolean $i$f$forEach;
        Object $this$forEach$iv;
        Object it;
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Set set = BuiltInRegistries.f_256975_.m_6566_();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"keySet(...)");
        Iterable $this$filterNot$iv = set;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Object[] destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object t : $this$filterNotTo$iv$iv) {
            ResourceLocation it2 = (ResourceLocation)t;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it2.m_135827_(), (Object)"minecraft")) continue;
            destination$iv$iv.add(t);
        }
        List keys = (List)destination$iv$iv;
        Map output = new LinkedHashMap();
        Iterable $this$forEach$iv2 = keys;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            it = (ResourceLocation)element$iv;
            boolean bl = false;
            try {
                Object object = BuiltInRegistries.f_256975_.m_7745_((ResourceLocation)it);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                Block block = (Block)object;
                VoxelShape voxelShape = block.m_5940_(block.m_49966_(), (BlockGetter)level, new BlockPos(0, 0, 0), CollisionContext.m_82749_());
                Intrinsics.checkNotNull((Object)voxelShape, (String)"null cannot be cast to non-null type g_mungus.vlib.util.CanAccessShape");
                DiscreteVoxelShape shape = ((CanAccessShape)voxelShape).vlib$getShape();
                Ref.DoubleRef volume = new Ref.DoubleRef();
                BlockState blockState = block.m_49966_();
                Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"defaultBlockState(...)");
                Double existingMass = MassDatapackResolver.INSTANCE.getBlockStateMass(blockState);
                BitsetDiscreteVoxelShapeAccessor.forAllBoxes(shape, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> MassCalculatorKt.calculateMasses$lambda$2$lambda$1(shape, volume, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5), false);
                if (existingMass != null) continue;
                double newMass = (double)MathKt.roundToInt((double)(volume.element * 1000.0 * 10.0)) / 10.0;
                Intrinsics.checkNotNull((Object)it);
                output.put(it, Math.max(newMass, 10.0));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        File outputDir = new File("mods/vlib_mass_synthetic_mod");
        if (outputDir.exists()) {
            FilesKt.deleteRecursively((File)outputDir);
        }
        outputDir.mkdirs();
        try {
            destination$iv$iv = new String[]{"pack.mcmeta", "fabric.mod.json", "META-INF/mods.toml", "META-INF/MANIFEST.MF", "META-INF/neoforge.mods.toml", "data/valkyrienskies/vs_mass/vlib_calculated_masses.json"};
            List templateFiles = CollectionsKt.listOf((Object[])destination$iv$iv);
            $this$forEach$iv = templateFiles;
            $i$f$forEach = false;
            it = $this$forEach$iv.iterator();
            while (it.hasNext()) {
                Object e = it.next();
                filePath = (String)e;
                boolean bl = false;
                InputStream resourceStream = VLib.class.getResourceAsStream("/mass_mod_template/" + (String)filePath);
                if (resourceStream != null) {
                    File outputFile = new File(outputDir, (String)filePath);
                    outputFile.getParentFile().mkdirs();
                    Closeable closeable = resourceStream;
                    Throwable newMass = null;
                    try {
                        long throwable2;
                        InputStream input = (InputStream)closeable;
                        boolean bl2 = false;
                        Closeable closeable2 = new FileOutputStream(outputFile);
                        Throwable throwable3 = null;
                        try {
                            FileOutputStream output2 = (FileOutputStream)closeable2;
                            boolean bl3 = false;
                            throwable2 = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)output2, (int)0, (int)2, null);
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable3);
                        }
                        long throwable5 = throwable2;
                        continue;
                    }
                    catch (Throwable throwable6) {
                        newMass = throwable6;
                        throw throwable6;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)newMass);
                    }
                }
                VLib.INSTANCE.getLOGGER().warn("Template file not found: " + (String)filePath);
            }
        }
        catch (Exception e) {
            VLib.INSTANCE.getLOGGER().error("Error copying template files", (Throwable)e);
            throw e;
        }
        JsonArray jsonArray = new JsonArray();
        $this$forEach$iv = output;
        $i$f$forEach = false;
        for (Map.Entry entry : $this$forEach$iv.entrySet()) {
            filePath = entry;
            boolean bl = false;
            ResourceLocation resourceLocation = (ResourceLocation)filePath.getKey();
            double mass = ((Number)filePath.getValue()).doubleValue();
            JsonObject entry2 = new JsonObject();
            entry2.addProperty("block", resourceLocation.toString());
            entry2.addProperty("mass", (Number)mass);
            jsonArray.add((JsonElement)entry2);
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        File massFile = new File(outputDir, "data/valkyrienskies/vs_mass/vlib_calculated_masses.json");
        massFile.getParentFile().mkdirs();
        it = new FileWriter(massFile);
        Throwable throwable7 = null;
        try {
            FileWriter writer = (FileWriter)it;
            boolean bl = false;
            gson.toJson((JsonElement)jsonArray, (Appendable)writer);
            throwable = Unit.INSTANCE;
        }
        catch (Throwable throwable8) {
            Throwable throwable9 = throwable8;
            throw throwable8;
        }
        finally {
            CloseableKt.closeFinally((Closeable)it, throwable7);
        }
        File zipFile = new File("mods/vlib_mass_synthetic_mod.jar");
        if (zipFile.exists()) {
            zipFile.delete();
        }
        try {
            Closeable closeable = new ZipOutputStream(new FileOutputStream(zipFile));
            throwable = null;
            try {
                ZipOutputStream zipOut = (ZipOutputStream)closeable;
                boolean bl = false;
                zipOut.setMethod(8);
                zipOut.setLevel(-1);
                MassCalculatorKt.zipDirectory(outputDir, "", zipOut);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable10) {
                throwable = throwable10;
                throw throwable10;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            if (outputDir.exists()) {
                FilesKt.deleteRecursively((File)outputDir);
            }
        }
        catch (Exception exception) {
            VLib.INSTANCE.getLOGGER().error("Error creating jar file", (Throwable)exception);
            throw exception;
        }
        String string = zipFile.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void zipDirectory(File sourceDir, String parentPath, ZipOutputStream zipOut) {
        block8: {
            File[] fileArray = sourceDir.listFiles();
            if (fileArray == null) break block8;
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Object object;
                File element$iv;
                File file = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if (file.isDirectory()) {
                    String dirPath = ((CharSequence)parentPath).length() == 0 ? file.getName() + "/" : parentPath + "/" + file.getName() + "/";
                    zipOut.putNextEntry(new ZipEntry(dirPath));
                    zipOut.closeEntry();
                    Intrinsics.checkNotNull((Object)file);
                    object = ((CharSequence)parentPath).length() == 0 ? file.getName() : parentPath + "/" + file.getName();
                    Intrinsics.checkNotNull((Object)object);
                    MassCalculatorKt.zipDirectory(file, (String)object, zipOut);
                    continue;
                }
                String filePath = ((CharSequence)parentPath).length() == 0 ? file.getName() : parentPath + "/" + file.getName();
                zipOut.putNextEntry(new ZipEntry(filePath));
                Intrinsics.checkNotNull((Object)file);
                object = new FileInputStream(file);
                Throwable throwable = null;
                try {
                    FileInputStream input = (FileInputStream)object;
                    boolean bl2 = false;
                    long l = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)zipOut, (int)0, (int)2, null);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                zipOut.closeEntry();
            }
        }
    }

    private static final void calculateMasses$lambda$2$lambda$1(DiscreteVoxelShape $shape, Ref.DoubleRef $volume, int a, int b, int c, int d, int e, int f) {
        Intrinsics.checkNotNullParameter((Object)$volume, (String)"$volume");
        double xSize = (double)(d - a) / (double)$shape.m_82828_();
        double ySize = (double)(e - b) / (double)$shape.m_82845_();
        double zSize = (double)(f - c) / (double)$shape.m_82852_();
        $volume.element += xSize * ySize * zSize;
    }
}

