/*
 * Decompiled with CFR 0.152.
 */
package com.quintonc.vs_sails;

import com.quintonc.vs_sails.ServerWindManager;
import com.quintonc.vs_sails.blocks.BuoyBlock;
import com.quintonc.vs_sails.blocks.HelmBlock;
import com.quintonc.vs_sails.blocks.entity.HelmBlockEntity;
import com.quintonc.vs_sails.blocks.entity.RedstoneHelmBlockEntity;
import com.quintonc.vs_sails.config.ConfigUtils;
import com.quintonc.vs_sails.registration.SailsBlocks;
import com.quintonc.vs_sails.registration.SailsItems;
import com.quintonc.vs_sails.ship.SailsShipControl;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.platform.Platform;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3dc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.IEntityDraggingInformationProvider;

public class ValkyrienSails {
    public static final String MOD_ID = "vs_sails";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"vs_sails_common");
    private static int tickCount = 0;
    private static final int refreshRate = 4;
    public static boolean weather2 = Platform.isModLoaded((String)"weather2");
    public static boolean sailsWind = false;
    public static final double EULERS_NUMBER = 2.71828182846;
    public static final ResourceLocation WIND_PARTICLE_PACKET = ResourceLocation.m_214293_((String)"vs_sails", (String)"wind_particle_packet");
    private static DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((String)"vs_sails", (ResourceKey)Registries.f_279569_);
    public static DeferredRegister<ParticleType<?>> PARTICLES = DeferredRegister.create((String)"vs_sails", (ResourceKey)Registries.f_256890_);
    public static BlockEntityType<HelmBlockEntity> HELM_BLOCK_ENTITY;
    public static BlockEntityType<RedstoneHelmBlockEntity> REDSTONE_HELM_BLOCK_ENTITY;
    public static RegistrySupplier<CreativeModeTab> SAILS_MAIN;
    public static RegistrySupplier<CreativeModeTab> SAILS_COLORS;
    public static SimpleParticleType WIND_PARTICLE;

    public static void init() {
        LOGGER.info("Common Init");
        ConfigUtils.checkConfigs();
        SAILS_MAIN = TABS.register("sails_main", () -> CreativeTabRegistry.create((Component)Component.m_237115_((String)"category.sails_main"), () -> new ItemStack((ItemLike)((HelmBlock)((Object)((Object)((Object)SailsBlocks.HELM_BLOCK.get())))).m_5456_())));
        SAILS_COLORS = TABS.register("sails_colors", () -> CreativeTabRegistry.create((Component)Component.m_237115_((String)"category.sails_colors"), () -> new ItemStack((ItemLike)((BuoyBlock)((Object)((Object)((Object)SailsBlocks.CYAN_BUOY.get())))).m_5456_())));
        TABS.register();
        SailsBlocks.register();
        SailsItems.register();
        LifecycleEvent.SERVER_STARTED.register(ValkyrienSails::onServerStarted);
        TickEvent.SERVER_LEVEL_PRE.register(ValkyrienSails::onWorldTick);
        LOGGER.info("Sailing time.");
    }

    public static void InitializeVSWind(ServerLevel world) {
        LOGGER.info("The wind is blowing.");
        sailsWind = Boolean.parseBoolean(ConfigUtils.config.getOrDefault("wind-shows-no-sails", "true"));
    }

    public static void onWorldTick(ServerLevel world) {
        if (tickCount == 4) {
            tickCount = 0;
            VSGameUtilsKt.getAllShips((Level)world).forEach(ship -> {
                SailsShipControl controller;
                ServerShip serverShip = (ServerShip)ship;
                if (serverShip != null && (controller = (SailsShipControl)serverShip.getAttachment(SailsShipControl.class)) != null) {
                    controller.world = world;
                }
            });
            if (sailsWind) {
                world.m_7654_().m_6846_().m_11314_().forEach(serverPlayerEntity -> {
                    IEntityDraggingInformationProvider player;
                    if (serverPlayerEntity instanceof IEntityDraggingInformationProvider && (player = (IEntityDraggingInformationProvider)serverPlayerEntity).getDraggingInformation().getLastShipStoodOn() != null) {
                        SailsShipControl controller;
                        long shipId = player.getDraggingInformation().getLastShipStoodOn();
                        ServerShip ship = (ServerShip)VSGameUtilsKt.getAllShips((Level)world).getById(shipId);
                        if (ship != null && (controller = (SailsShipControl)ship.getAttachment(SailsShipControl.class)) != null && player.getDraggingInformation().getTicksSinceStoodOnShip() < 100) {
                            Vector3dc shipPos = ship.getTransform().getPositionInWorld();
                            double windDir = Math.toRadians(ServerWindManager.getWindDirection((Level)world, new Vec3(shipPos.x(), shipPos.y(), shipPos.z())) + 180.0f);
                            world.m_8624_(serverPlayerEntity, (ParticleOptions)WIND_PARTICLE, false, serverPlayerEntity.m_20185_() + 15.0 * Math.sin(windDir), serverPlayerEntity.m_20186_() + 25.0, serverPlayerEntity.m_20189_() + 15.0 * Math.sin(windDir), 10, 20.0, 10.0, 20.0, 0.0);
                        }
                    }
                });
            }
        } else {
            ++tickCount;
        }
    }

    private static Vec3 project(Vec3 vec1, Vec3 vec2) {
        return vec1.m_82490_(vec1.m_82526_(vec2) / Math.pow(vec1.m_82553_(), 2.0));
    }

    public static void onServerStarted(MinecraftServer server) {
        if (Boolean.parseBoolean(ConfigUtils.config.getOrDefault("enable-wind", "true"))) {
            ServerWindManager.InitializeWind(server.m_129783_());
            ValkyrienSails.InitializeVSWind(server.m_129783_());
        }
    }
}

