/*
 * Decompiled with CFR 0.152.
 */
package com.quintonc.vs_sails.blocks;

import com.quintonc.vs_sails.blocks.entity.BaseHelmBlockEntity;
import com.quintonc.vs_sails.ship.SailsShipControl;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public abstract class BaseHelmBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING;
    public static final Logger LOGGER;
    private static final VoxelShape NORTH_SHAPE;
    private static final VoxelShape SOUTH_SHAPE;
    private static final VoxelShape EAST_SHAPE;
    private static final VoxelShape WEST_SHAPE;

    public BaseHelmBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            default: {
                return NORTH_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case EAST: {
                return EAST_SHAPE;
            }
            case WEST: 
        }
        return WEST_SHAPE;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_());
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        LoadedServerShip ship;
        if (world.f_46443_) {
            return;
        }
        if (VSGameUtilsKt.isBlockInShipyard((Level)world, (BlockPos)pos) && (ship = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)((ServerLevel)world), (Vec3i)pos)) != null) {
            SailsShipControl controller = SailsShipControl.getOrCreate((ServerShip)ship, world);
            ++controller.numHelms;
            if (Objects.equals(controller.shipDirection, state.m_61143_((Property)FACING))) {
                controller.shipDirection = controller.shipDirection.m_122424_();
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity be = world.m_7702_(pos);
        if (be instanceof BaseHelmBlockEntity) {
            BaseHelmBlockEntity blockEntity = (BaseHelmBlockEntity)be;
            if (VSGameUtilsKt.isBlockInShipyard((Level)world, (BlockPos)pos)) {
                blockEntity.sit(player);
            } else {
                if (player.m_6144_()) {
                    blockEntity.rotateWheelLeft(state, (ServerLevel)world, pos);
                } else {
                    blockEntity.rotateWheelRight(state, (ServerLevel)world, pos);
                }
                player.m_5661_((Component)Component.m_237113_((String)("Angle: " + blockEntity.wheelAngle)), true);
            }
            return InteractionResult.m_19078_((boolean)false);
        }
        return InteractionResult.m_19078_((boolean)false);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        LoadedServerShip ship;
        if (!world.f_46443_ && VSGameUtilsKt.isBlockInShipyard((Level)world, (BlockPos)pos) && (ship = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)((ServerLevel)world), (Vec3i)pos)) != null) {
            SailsShipControl controller = (SailsShipControl)ship.getAttachment(SailsShipControl.class);
            assert (controller != null);
            --controller.numHelms;
        }
        if (state.m_155947_() && !state.m_60713_(newState.m_60734_())) {
            world.m_46747_(pos);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    static {
        LOGGER = LoggerFactory.getLogger((String)"base_helm_block");
        NORTH_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)0.0, (double)2.0, (double)11.0, (double)16.0, (double)11.0), (VoxelShape)Block.m_49796_((double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)21.0, (double)14.0));
        SOUTH_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)14.0), (VoxelShape)Block.m_49796_((double)0.0, (double)5.0, (double)2.0, (double)16.0, (double)21.0, (double)5.0));
        EAST_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)14.0, (double)16.0, (double)11.0), (VoxelShape)Block.m_49796_((double)2.0, (double)5.0, (double)0.0, (double)5.0, (double)21.0, (double)16.0));
        WEST_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0), (VoxelShape)Block.m_49796_((double)11.0, (double)5.0, (double)0.0, (double)14.0, (double)21.0, (double)16.0));
        FACING = BlockStateProperties.f_61374_;
    }
}

