/*
 * Decompiled with CFR 0.152.
 */
package com.quintonc.vs_sails.blocks;

import com.quintonc.vs_sails.blocks.SailToggleBlock;
import com.quintonc.vs_sails.ship.SailsShipControl;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public class SailBlock
extends Block {
    public static final BooleanProperty SET = BooleanProperty.m_61465_((String)"set");
    public static final BooleanProperty INVISIBLE = BooleanProperty.m_61465_((String)"invisible");
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"sail_block");
    public static final VoxelShape SET_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public SailBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)SET, (Comparable)Boolean.valueOf(true))).m_61124_((Property)INVISIBLE, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)SET, (Comparable)Boolean.valueOf(true));
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (world.f_46443_) {
            return;
        }
        if (((Boolean)state.m_61143_((Property)SET)).booleanValue()) {
            world.m_7731_(pos, state, 10);
            if (VSGameUtilsKt.isBlockInShipyard((Level)world, (BlockPos)pos) && (!oldState.m_60713_((Block)this) || state.m_61143_((Property)SET) != oldState.m_61143_((Property)SET))) {
                LoadedServerShip ship = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)((ServerLevel)world), (Vec3i)pos);
                if (ship != null) {
                    SailsShipControl controller = SailsShipControl.getOrCreate((ServerShip)ship, world);
                    this.addSailToShip(world, pos, controller);
                } else {
                    ship = VSGameUtilsKt.getShipManagingPos((ServerLevel)((ServerLevel)world), (BlockPos)pos);
                    if (ship != null) {
                        SailsShipControl controller = SailsShipControl.getOrCreate((ServerShip)ship, world);
                        this.addSailToShip(world, pos, controller);
                    }
                }
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("sail_togglers"));
        if (!player.m_21120_(InteractionHand.MAIN_HAND).m_204117_(tag)) {
            if (!world.f_46443_) {
                this.toggleFirstSail(state, world, pos);
            } else {
                boolean bl = (Boolean)state.m_61143_((Property)SET);
                world.m_5594_(player, pos, bl ? SoundEvents.f_12087_ : SoundEvents.f_12642_, SoundSource.BLOCKS, 0.75f, world.m_213780_().m_188501_() * 0.1f + 0.9f);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void toggleFirstSail(BlockState state, Level world, BlockPos pos) {
        if (((Boolean)state.m_61143_((Property)SET)).booleanValue()) {
            this.toggleOff(state, world, pos);
        } else {
            state = (BlockState)state.m_61124_((Property)SET, (Comparable)Boolean.valueOf(true));
            state = (BlockState)state.m_61124_((Property)INVISIBLE, (Comparable)Boolean.valueOf(false));
            world.m_7731_(pos, state, 10);
            this.updateAdjacents(world, pos, this);
        }
    }

    public void toggleOff(BlockState state, Level world, BlockPos pos) {
        state = this.isNotSailOrAir(world, pos.m_7918_(1, 1, 0)) || this.isNotSailOrAir(world, pos.m_7918_(-1, 1, 0)) || this.isNotSailOrAir(world, pos.m_7918_(0, 1, 1)) || this.isNotSailOrAir(world, pos.m_7918_(0, 1, -1)) || this.isNotSailOrAir(world, pos.m_7918_(1, -1, 0)) || this.isNotSailOrAir(world, pos.m_7918_(-1, -1, 0)) || this.isNotSailOrAir(world, pos.m_7918_(0, -1, 1)) || this.isNotSailOrAir(world, pos.m_7918_(0, -1, -1)) || this.isNotSailOrAir(world, pos.m_7494_()) || this.isNotSailOrAir(world, pos.m_7495_()) ? (BlockState)state.m_61124_((Property)INVISIBLE, (Comparable)Boolean.valueOf(false)) : (BlockState)state.m_61124_((Property)INVISIBLE, (Comparable)Boolean.valueOf(true));
        state = (BlockState)state.m_61124_((Property)SET, (Comparable)Boolean.valueOf(false));
        world.m_7731_(pos, state, 10);
        this.updateAdjacents(world, pos, this);
    }

    private boolean isNotSailOrAir(Level world, BlockPos pos) {
        return !(world.m_8055_(pos).m_60734_() instanceof SailBlock) && !world.m_8055_(pos).m_60795_() && world.m_8055_(pos).m_280296_();
    }

    private boolean fewerThanXSailsHorizontally(Level world, BlockPos pos, int x) {
        return this.countHorizontallyAdjacentSails(world, pos) < x;
    }

    private boolean atLeastXSailsHorizontally(Level world, BlockPos pos, int x) {
        return this.countHorizontallyAdjacentSails(world, pos) >= x;
    }

    private int countHorizontallyAdjacentSails(Level world, BlockPos pos) {
        int n = 0;
        if (world.m_8055_(pos).m_60734_() instanceof SailBlock) {
            ++n;
        }
        if (world.m_8055_(pos.m_122012_()).m_60734_() instanceof SailBlock) {
            ++n;
        }
        if (world.m_8055_(pos.m_122019_()).m_60734_() instanceof SailBlock) {
            ++n;
        }
        if (world.m_8055_(pos.m_122029_()).m_60734_() instanceof SailBlock) {
            ++n;
        }
        if (world.m_8055_(pos.m_122024_()).m_60734_() instanceof SailBlock) {
            ++n;
        }
        if (world.m_8055_(pos.m_122029_().m_122012_()).m_60734_() instanceof SailBlock) {
            ++n;
        }
        if (world.m_8055_(pos.m_122029_().m_122019_()).m_60734_() instanceof SailBlock) {
            ++n;
        }
        if (world.m_8055_(pos.m_122024_().m_122012_()).m_60734_() instanceof SailBlock) {
            ++n;
        }
        if (world.m_8055_(pos.m_122024_().m_122019_()).m_60734_() instanceof SailBlock) {
            ++n;
        }
        return n;
    }

    private boolean noBlockHereOrAboveOrBelow(Level world, BlockPos pos) {
        return this.isNotSailOrAir(world, pos) && this.isNotSailOrAir(world, pos.m_7494_()) && this.isNotSailOrAir(world, pos.m_7495_());
    }

    private int countHorizontallyAdjacentSolids(Level world, BlockPos pos) {
        int n = 0;
        if (!world.m_8055_(pos).m_60795_()) {
            ++n;
        }
        if (!world.m_8055_(pos.m_122012_()).m_60795_()) {
            ++n;
        }
        if (!world.m_8055_(pos.m_122019_()).m_60795_()) {
            ++n;
        }
        if (!world.m_8055_(pos.m_122029_()).m_60795_()) {
            ++n;
        }
        if (!world.m_8055_(pos.m_122024_()).m_60795_()) {
            ++n;
        }
        if (!world.m_8055_(pos.m_122029_().m_122012_()).m_60795_()) {
            ++n;
        }
        if (!world.m_8055_(pos.m_122029_().m_122019_()).m_60795_()) {
            ++n;
        }
        if (!world.m_8055_(pos.m_122024_().m_122012_()).m_60795_()) {
            ++n;
        }
        if (!world.m_8055_(pos.m_122024_().m_122019_()).m_60795_()) {
            ++n;
        }
        return n;
    }

    private boolean hasMismatchedOppositeAir(Level world, BlockPos pos) {
        return world.m_8055_(pos.m_122012_()).m_60795_() != world.m_8055_(pos.m_122019_()).m_60795_() && (world.m_8055_(pos.m_122012_()).m_60734_() instanceof SailBlock || world.m_8055_(pos.m_122019_()).m_60734_() instanceof SailBlock) || world.m_8055_(pos.m_122029_()).m_60795_() != world.m_8055_(pos.m_122024_()).m_60795_() && (world.m_8055_(pos.m_122029_()).m_60734_() instanceof SailBlock || world.m_8055_(pos.m_122024_()).m_60734_() instanceof SailBlock) || world.m_8055_(pos.m_122012_().m_122029_()).m_60795_() != world.m_8055_(pos.m_122019_().m_122024_()).m_60795_() && (world.m_8055_(pos.m_122012_().m_122029_()).m_60734_() instanceof SailBlock || world.m_8055_(pos.m_122019_().m_122024_()).m_60734_() instanceof SailBlock) || world.m_8055_(pos.m_122012_().m_122024_()).m_60795_() != world.m_8055_(pos.m_122019_().m_122029_()).m_60795_() && (world.m_8055_(pos.m_122012_().m_122024_()).m_60734_() instanceof SailBlock || world.m_8055_(pos.m_122019_().m_122029_()).m_60734_() instanceof SailBlock);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        BlockState sourceState;
        if ((sourceBlock instanceof SailBlock || sourceBlock instanceof SailToggleBlock) && !world.m_8055_(sourcePos).m_60795_() && (sourceState = world.m_8055_(sourcePos)).m_61138_((Property)SET) && sourceState.m_61143_((Property)SET) != state.m_61143_((Property)SET)) {
            if (((Boolean)sourceState.m_61143_((Property)SET)).booleanValue()) {
                state = (BlockState)state.m_61124_((Property)SET, (Comparable)Boolean.valueOf(true));
                state = (BlockState)state.m_61124_((Property)INVISIBLE, (Comparable)Boolean.valueOf(false));
                world.m_7731_(pos, state, 10);
                this.updateAdjacents(world, pos, this);
            } else {
                this.toggleOff(state, world, pos);
            }
        }
    }

    public void updateAdjacents(Level world, BlockPos sourcePos, Block sourceBlock) {
        world.m_6289_(sourcePos, sourceBlock);
        world.m_46586_(sourcePos.m_7918_(1, 1, 0), sourceBlock, sourcePos);
        world.m_46586_(sourcePos.m_7918_(1, -1, 0), sourceBlock, sourcePos);
        world.m_46586_(sourcePos.m_7918_(1, 0, 1), sourceBlock, sourcePos);
        world.m_46586_(sourcePos.m_7918_(1, 0, -1), sourceBlock, sourcePos);
        world.m_46586_(sourcePos.m_7918_(-1, 1, 0), sourceBlock, sourcePos);
        world.m_46586_(sourcePos.m_7918_(-1, -1, 0), sourceBlock, sourcePos);
        world.m_46586_(sourcePos.m_7918_(-1, 0, 1), sourceBlock, sourcePos);
        world.m_46586_(sourcePos.m_7918_(-1, 0, -1), sourceBlock, sourcePos);
        world.m_46586_(sourcePos.m_7918_(0, 1, 1), sourceBlock, sourcePos);
        world.m_46586_(sourcePos.m_7918_(0, 1, -1), sourceBlock, sourcePos);
        world.m_46586_(sourcePos.m_7918_(0, -1, 1), sourceBlock, sourcePos);
        world.m_46586_(sourcePos.m_7918_(0, -1, -1), sourceBlock, sourcePos);
    }

    public char calculateSailType(Level world, BlockPos pos, SailsShipControl controller) {
        if (!world.m_8055_(pos.m_122012_()).m_60795_() || !world.m_8055_(pos.m_122019_()).m_60795_()) {
            if (world.m_8055_(pos.m_122029_()).m_60795_() && world.m_8055_(pos.m_122024_()).m_60795_()) {
                if (controller.shipDirection == Direction.EAST || controller.shipDirection == Direction.WEST) {
                    return 's';
                }
                return 'f';
            }
            return 'x';
        }
        if ((!world.m_8055_(pos.m_122029_()).m_60795_() || !world.m_8055_(pos.m_122024_()).m_60795_()) && world.m_8055_(pos.m_122012_()).m_60795_() && world.m_8055_(pos.m_122019_()).m_60795_()) {
            if (controller.shipDirection == Direction.EAST || controller.shipDirection == Direction.WEST) {
                return 'f';
            }
            return 's';
        }
        return 'x';
    }

    private void addSailToShip(Level world, BlockPos pos, SailsShipControl controller) {
        char sailType = this.calculateSailType(world, pos, controller);
        if (sailType == 's') {
            ++controller.numSquareSails;
        } else if (sailType == 'f') {
            ++controller.numFnASails;
        }
        ++controller.numSails;
    }

    private void removeSailFromShip(Level world, BlockPos pos, SailsShipControl controller) {
        char sailType = this.calculateSailType(world, pos, controller);
        if (sailType == 's') {
            --controller.numSquareSails;
        }
        if (sailType == 'f') {
            --controller.numFnASails;
        }
        --controller.numSails;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        LoadedServerShip ship;
        if (!world.f_46443_ && VSGameUtilsKt.isBlockInShipyard((Level)world, (BlockPos)pos) && (ship = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)((ServerLevel)world), (Vec3i)pos)) != null) {
            SailsShipControl controller = (SailsShipControl)ship.getAttachment(SailsShipControl.class);
            if (!newState.m_60795_() && newState.m_61138_((Property)SET) && !((Boolean)newState.m_61143_((Property)SET)).booleanValue() && state.m_61143_((Property)SET) != newState.m_61143_((Property)SET) && controller != null) {
                this.removeSailFromShip(world, pos, controller);
            }
            if (newState.m_60795_() && ((Boolean)state.m_61143_((Property)SET)).booleanValue() && controller != null) {
                this.removeSailFromShip(world, pos, controller);
            }
        }
    }

    public Item getSailItem() {
        return this.m_5456_();
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return true;
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 5;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 20;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)INVISIBLE)).booleanValue()) {
            return Shapes.m_83040_();
        }
        return SET_SHAPE;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)INVISIBLE)).booleanValue()) {
            return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        }
        return SET_SHAPE;
    }

    public boolean m_7420_(BlockState state, BlockGetter world, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)SET) == false;
    }

    public boolean m_6104_(BlockState state, BlockState stateFrom, Direction direction) {
        return stateFrom.m_60713_((Block)this) || super.m_6104_(state, stateFrom, direction);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SET});
        builder.m_61104_(new Property[]{INVISIBLE});
    }
}

