/*
 * Decompiled with CFR 0.152.
 */
package com.quintonc.vs_sails.blocks.entity;

import com.quintonc.vs_sails.ValkyrienSails;
import com.quintonc.vs_sails.blocks.HelmWheel;
import com.quintonc.vs_sails.blocks.entity.BaseHelmBlockEntity;
import com.quintonc.vs_sails.config.ConfigUtils;
import com.quintonc.vs_sails.registration.SailsBlocks;
import com.quintonc.vs_sails.ship.SailsShipControl;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.mod.api.SeatedControllingPlayer;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public class HelmBlockEntity
extends BaseHelmBlockEntity {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"helm_entity");
    private static final double rudderarea = Double.parseDouble(ConfigUtils.config.getOrDefault("rudder-power", "1.0"));

    public HelmBlockEntity(BlockPos pos, BlockState state) {
        super(ValkyrienSails.HELM_BLOCK_ENTITY, pos, state);
        this.wheelAngle = 360;
        maxAngle = 720;
        wheelInterval = Integer.parseInt(ConfigUtils.config.getOrDefault("wheel-interval", "6"));
    }

    public static void tick(Level world, BlockPos pos, BlockState state) {
        ChunkPos chunkPos;
        LoadedServerShip ship;
        if (!world.f_46443_ && VSGameUtilsKt.isBlockInShipyard((Level)world, (BlockPos)pos) && (ship = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)((ServerLevel)world), (ChunkPos)(chunkPos = world.m_46865_(pos).m_7697_()))) != null) {
            SeatedControllingPlayer playerControl = (SeatedControllingPlayer)ship.getAttachment(SeatedControllingPlayer.class);
            BlockEntity be = world.m_7702_(pos);
            if (be instanceof HelmBlockEntity) {
                HelmBlockEntity blockEntity = (HelmBlockEntity)be;
                if (playerControl != null) {
                    if (playerControl.getLeftImpulse() < 0.0f) {
                        blockEntity.rotateWheelRight(state, (ServerLevel)world, pos);
                    } else if (playerControl.getLeftImpulse() > 0.0f) {
                        blockEntity.rotateWheelLeft(state, (ServerLevel)world, pos);
                    }
                }
                Vector3dc com = ship.getInertiaData().getCenterOfMassInShip();
                double rudderOffset = ship.getShipAABB().maxX() - ship.getShipAABB().minX();
                Vec3i shipDir = SailsShipControl.getOrCreate((ServerShip)ship, (Level)world).shipDirection.m_122424_().m_122436_();
                Vector3d loc = new Vector3d(com.x() + rudderOffset * (double)shipDir.m_123341_(), com.y(), com.z() + rudderOffset * (double)shipDir.m_123343_() + 1.0);
                Vector3d loc2 = new Vector3d(com.x() + rudderOffset * (double)shipDir.m_123341_(), com.y(), com.z() + rudderOffset * (double)shipDir.m_123343_() - 1.0);
                Vector3d rudderPos = new Vector3d(com.x() + rudderOffset * (double)shipDir.m_123341_(), com.y(), com.z() + rudderOffset * (double)shipDir.m_123343_());
                AABBic shipDims = ship.getShipAABB();
                double rudderSize = rudderarea * (double)((shipDims.maxX() - shipDims.minX()) * (shipDims.maxZ() - shipDims.minZ())) / 100.0;
                double rudderAngle = ((double)blockEntity.wheelAngle - 360.0) / 10.0 * Math.PI / 180.0;
                double mass = ship.getInertiaData().getMass() / 100.0;
                double vel = Math.sqrt(Math.pow(ship.getVelocity().x(), 2.0) + Math.pow(ship.getVelocity().z(), 2.0));
                double rudderForce = Boolean.parseBoolean(ConfigUtils.config.getOrDefault("realistic-rudder", "true")) ? Math.PI * 2 * rudderAngle * 998.0 / 6.0 * Math.sqrt(mass) * Math.pow(vel, 2.0) * rudderSize : Math.PI * 2 * rudderAngle * 998.0 * Math.sqrt(mass) * rudderSize;
                Vector3d turnvector = new Vector3d(rudderForce + mass, 0.0, 0.0);
                Vector3d turnvector2 = new Vector3d(-rudderForce - mass, 0.0, 0.0);
                Vector3d turnvector3 = new Vector3d(0.0, 0.0, rudderForce);
                SailsShipControl shipForceApplier = (SailsShipControl)ship.getAttachment(SailsShipControl.class);
                if (shipForceApplier != null) {
                    shipForceApplier.applyRotDependentForceToPos((Vector3dc)turnvector, (Vector3dc)loc.sub(ship.getTransform().getPositionInShip()));
                    shipForceApplier.applyRotDependentForceToPos((Vector3dc)turnvector2, (Vector3dc)loc2.sub(ship.getTransform().getPositionInShip()));
                }
                HelmBlockEntity.m_155232_((Level)world, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    @Override
    public ItemStack getRenderStack() {
        return new ItemStack((ItemLike)((HelmWheel)((Object)SailsBlocks.HELM_WHEEL.get())).m_5456_());
    }
}

