/*
 * Decompiled with CFR 0.152.
 */
package com.quintonc.vs_sails.blocks.entity;

import com.quintonc.vs_sails.ValkyrienSails;
import com.quintonc.vs_sails.blocks.HelmWheel;
import com.quintonc.vs_sails.blocks.RedstoneHelmBlock;
import com.quintonc.vs_sails.blocks.entity.BaseHelmBlockEntity;
import com.quintonc.vs_sails.config.ConfigUtils;
import com.quintonc.vs_sails.registration.SailsBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.mod.api.SeatedControllingPlayer;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public class RedstoneHelmBlockEntity
extends BaseHelmBlockEntity {
    public RedstoneHelmBlockEntity(BlockPos pos, BlockState blockState) {
        super(ValkyrienSails.REDSTONE_HELM_BLOCK_ENTITY, pos, blockState);
        this.wheelAngle = 360;
        maxAngle = 720;
        wheelInterval = Integer.parseInt(ConfigUtils.config.getOrDefault("wheel-interval", "6"));
    }

    public static void tick(Level world, BlockPos pos, BlockState state) {
        ChunkPos chunkPos;
        LoadedServerShip ship;
        if (!world.f_46443_ && VSGameUtilsKt.isBlockInShipyard((Level)world, (BlockPos)pos) && (ship = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)((ServerLevel)world), (ChunkPos)(chunkPos = world.m_46865_(pos).m_7697_()))) != null) {
            SeatedControllingPlayer playerControl = (SeatedControllingPlayer)ship.getAttachment(SeatedControllingPlayer.class);
            BlockEntity be = world.m_7702_(pos);
            if (be instanceof RedstoneHelmBlockEntity) {
                RedstoneHelmBlockEntity blockEntity = (RedstoneHelmBlockEntity)be;
                if (playerControl != null) {
                    if (playerControl.getLeftImpulse() < 0.0f) {
                        blockEntity.rotateWheelRight(state, (ServerLevel)world, pos);
                        Block block = state.m_60734_();
                        if (block instanceof RedstoneHelmBlock) {
                            RedstoneHelmBlock redstoneHelmBlock = (RedstoneHelmBlock)block;
                            redstoneHelmBlock.updateNeighbours(state, world, pos);
                        }
                    } else if (playerControl.getLeftImpulse() > 0.0f) {
                        blockEntity.rotateWheelLeft(state, (ServerLevel)world, pos);
                        Block block = state.m_60734_();
                        if (block instanceof RedstoneHelmBlock) {
                            RedstoneHelmBlock redstoneHelmBlock = (RedstoneHelmBlock)block;
                            redstoneHelmBlock.updateNeighbours(state, world, pos);
                        }
                    }
                }
                RedstoneHelmBlockEntity.m_155232_((Level)world, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    @Override
    public ItemStack getRenderStack() {
        return new ItemStack((ItemLike)((HelmWheel)((Object)SailsBlocks.REDSTONE_HELM_WHEEL.get())).m_5456_());
    }
}

