/*
 * Decompiled with CFR 0.152.
 */
package com.quintonc.vs_sails.client.particles;

import com.quintonc.vs_sails.client.ClientWindManager;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Unique;

public class WindParticle
extends TextureSheetParticle {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"wind_particle");

    protected WindParticle(ClientLevel world, double x, double y, double z, SpriteSet spriteSet, double xd, double yd, double zd) {
        super(world, x, y, z, xd, yd, zd);
        this.f_172258_ = 0.6f;
        this.f_107212_ = x;
        this.f_107213_ = y;
        this.f_107214_ = z;
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107217_ = 0.0;
        this.f_107663_ = 0.25f;
        this.f_107225_ = 20;
        this.f_107230_ = 0.0f;
        this.m_108339_(spriteSet);
        this.f_107227_ = 1.0f;
        this.f_107228_ = 1.0f;
        this.f_107229_ = 1.0f;
    }

    public void m_5989_() {
        super.m_5989_();
        this.f_107215_ = this.modifyDx(this.f_107215_);
        this.f_107217_ = this.modifyDz(this.f_107217_);
        this.fade();
    }

    private void fade() {
        double windStrength = ClientWindManager.getWindStrength((Level)this.f_107208_, new BlockPos((int)this.f_107212_, (int)this.f_107213_, (int)this.f_107214_));
        this.f_107230_ = (float)(Math.abs(windStrength) * 0.75 * Math.sin(Math.PI * (double)this.f_107224_ / (double)this.f_107225_));
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    private double modifyDx(double dx) {
        Vec3 oldParticlePos = new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
        Vec3 windEffect = this.calculateWindEffect(oldParticlePos);
        Vec3 particlePos = new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
        Vec3 windDirection = new Vec3(Math.cos(Math.toRadians(ClientWindManager.getWindDirection((Level)this.f_107208_, particlePos))), 0.0, Math.sin(Math.toRadians(ClientWindManager.getWindDirection((Level)this.f_107208_, particlePos))));
        double windInfluenceFactor = this.getWindInfluenceFactor(particlePos, windDirection);
        return dx + windEffect.f_82479_ * windInfluenceFactor;
    }

    private double modifyDz(double dz) {
        Vec3 oldParticlePos = new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
        Vec3 windEffect = this.calculateWindEffect(oldParticlePos);
        Vec3 particlePos = new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
        Vec3 windDirection = new Vec3(Math.cos(Math.toRadians(ClientWindManager.getWindDirection((Level)this.f_107208_, particlePos))), 0.0, Math.sin(Math.toRadians(ClientWindManager.getWindDirection((Level)this.f_107208_, particlePos))));
        double windInfluenceFactor = this.getWindInfluenceFactor(particlePos, windDirection);
        return dz + windEffect.f_82481_ * windInfluenceFactor;
    }

    private double getWindInfluenceFactor(Vec3 particlePosition, Vec3 windDirection) {
        int range = 5;
        Vec3 invertedWindDirection = windDirection.m_82490_(-1.0);
        for (int i = 1; i <= range; ++i) {
            Vec3 checkPosition = particlePosition.m_82549_(invertedWindDirection.m_82490_((double)i));
            BlockPos pos = new BlockPos((int)checkPosition.m_7096_(), (int)checkPosition.m_7098_(), (int)checkPosition.m_7094_());
            BlockState state = this.f_107208_.m_8055_(pos);
            if (!state.m_60795_() && !this.isNonSolidBlock(state)) continue;
            return 1.0;
        }
        return 0.0;
    }

    @Unique
    private boolean isNonSolidBlock(BlockState state) {
        return state.m_60713_(Blocks.f_50058_) || state.m_60713_(Blocks.f_50050_) || state.m_60713_(Blocks.f_50183_) || state.m_60819_().m_76152_() == Fluids.f_76193_ || state.m_60819_().m_76152_() == Fluids.f_76195_;
    }

    @Unique
    private Vec3 calculateWindEffect(Vec3 particlePos) {
        double windEffectiveness = 2.0;
        BlockPos pos = new BlockPos((int)this.f_107212_, (int)this.f_107213_, (int)this.f_107214_);
        double angleRadians = Math.toRadians(ClientWindManager.getWindDirection((Level)this.f_107208_, particlePos));
        double windX = Math.cos(angleRadians) * (double)ClientWindManager.getWindStrength((Level)this.f_107208_, pos) * windEffectiveness;
        double windZ = Math.sin(angleRadians) * (double)ClientWindManager.getWindStrength((Level)this.f_107208_, pos) * windEffectiveness;
        Vec3 initialWindEffect = new Vec3(windX, 0.0, windZ);
        return this.calculateRealisticWindFlow(initialWindEffect, pos);
    }

    private boolean checkForWallInteraction(BlockPos particlePos) {
        for (Direction dir : Direction.values()) {
            BlockState state = this.f_107208_.m_8055_(particlePos.m_121945_(dir));
            if (!state.m_60796_((BlockGetter)this.f_107208_, particlePos.m_121945_(dir))) continue;
            return true;
        }
        return false;
    }

    private Vec3 deflectWind(double windX, double windZ, BlockPos pos) {
        Direction windDirection = this.getWindDirection(windX, windZ);
        Direction wallDirection = this.getWallFacingDirection(pos, windDirection);
        double incidenceAngle = this.calculateIncidenceAngle(windDirection, wallDirection);
        double deflectionFactor = this.calculateDeflectionFactor(incidenceAngle, windX, windZ);
        double deflectedWindX = windX * deflectionFactor;
        double deflectedWindZ = windZ * deflectionFactor;
        return new Vec3(deflectedWindX += this.randomizeDeflection(incidenceAngle), 0.0, deflectedWindZ += this.randomizeDeflection(incidenceAngle));
    }

    private double randomizeDeflection(double incidenceAngle) {
        return Math.random() * Math.cos(Math.toRadians(incidenceAngle)) * 0.05;
    }

    private Direction getWindDirection(double windX, double windZ) {
        double angle = Math.toDegrees(Math.atan2(windZ, windX));
        if (angle < 0.0) {
            angle += 360.0;
        }
        if (angle <= 45.0 || angle > 315.0) {
            return Direction.EAST;
        }
        if (angle > 45.0 && angle <= 135.0) {
            return Direction.SOUTH;
        }
        if (angle > 135.0 && angle <= 225.0) {
            return Direction.WEST;
        }
        if (angle > 225.0) {
            return Direction.NORTH;
        }
        return Direction.EAST;
    }

    private Direction getWallFacingDirection(BlockPos pos, Direction windDirection) {
        for (Direction dir : Direction.values()) {
            BlockState state = this.f_107208_.m_8055_(pos.m_121945_(dir));
            if (!state.m_60796_((BlockGetter)this.f_107208_, pos.m_121945_(dir)) || !dir.m_122434_().m_122479_()) continue;
            return dir;
        }
        return windDirection;
    }

    private double calculateIncidenceAngle(Direction windDirection, Direction wallDirection) {
        int wallAngle;
        int windAngle = this.directionToAngle(windDirection);
        int angleDifference = Math.abs(windAngle - (wallAngle = this.directionToAngle(wallDirection)));
        if (angleDifference > 180) {
            angleDifference = 360 - angleDifference;
        }
        return angleDifference;
    }

    private int directionToAngle(Direction direction) {
        return switch (direction) {
            case Direction.NORTH -> 180;
            case Direction.WEST -> 270;
            case Direction.EAST -> 90;
            default -> 0;
        };
    }

    private double calculateDeflectionFactor(double incidenceAngle, double windX, double windZ) {
        double baseDeflection = 0.01;
        double velocityFactor = Math.sqrt(windX * windX + windZ * windZ) * 0.01;
        double angleFactor = Math.cos(Math.toRadians(incidenceAngle));
        return baseDeflection * angleFactor * velocityFactor;
    }

    private boolean checkForLaminarFlow(double incidenceAngle) {
        return incidenceAngle < 45.0;
    }

    private Vec3 adjustWindFlow(Vec3 windEffect, BlockPos pos, double windX, double windZ) {
        Direction wallDirection;
        Direction windDirection = this.getWindDirection(windX, windZ);
        double incidenceAngle = this.calculateIncidenceAngle(windDirection, wallDirection = this.getWallFacingDirection(pos, windDirection));
        if (this.checkForLaminarFlow(incidenceAngle)) {
            return this.slideWindAlongWall(windEffect, wallDirection);
        }
        return this.deflectWind(windX, windZ, pos);
    }

    private Vec3 slideWindAlongWall(Vec3 windEffect, Direction wallDirection) {
        return switch (wallDirection) {
            case Direction.NORTH, Direction.SOUTH -> new Vec3(windEffect.f_82479_, windEffect.f_82480_, 0.0);
            case Direction.WEST, Direction.EAST -> new Vec3(0.0, windEffect.f_82480_, windEffect.f_82481_);
            default -> windEffect;
        };
    }

    private Vec3 funnelWindAroundStructure(Vec3 windEffect, BlockPos pos) {
        Direction wallDirection;
        Direction windDirection = this.getWindDirection(windEffect.f_82479_, windEffect.f_82481_);
        double incidenceAngle = this.calculateIncidenceAngle(windDirection, wallDirection = this.getWallFacingDirection(pos, windDirection));
        if (incidenceAngle >= 45.0 && incidenceAngle <= 135.0) {
            double funnelFactor = 1.0 + (1.0 - Math.cos(Math.toRadians(incidenceAngle))) * 0.5;
            return windEffect.m_82490_(funnelFactor);
        }
        return windEffect;
    }

    private boolean isNearTunnel(BlockPos pos) {
        int airCount = 0;
        int solidCount = 0;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -1; dz <= 1; ++dz) {
                    BlockPos checkPos = pos.m_7918_(dx, dy, dz);
                    BlockState state = this.f_107208_.m_8055_(checkPos);
                    if (state.m_60795_()) {
                        ++airCount;
                        continue;
                    }
                    if (!state.m_60796_((BlockGetter)this.f_107208_, checkPos)) continue;
                    ++solidCount;
                }
            }
        }
        return airCount >= 15 && solidCount >= 10;
    }

    private Vec3 adjustForTunnelAttraction(Vec3 windEffect, BlockPos pos) {
        if (this.isNearTunnel(pos)) {
            double attractionFactor = 1.5;
            return windEffect.m_82490_(attractionFactor);
        }
        return windEffect;
    }

    private Vec3 calculateRealisticWindFlow(Vec3 windEffect, BlockPos pos) {
        if (this.checkForWallInteraction(pos)) {
            windEffect = this.adjustWindFlow(windEffect, pos, windEffect.f_82479_, windEffect.f_82481_);
        }
        windEffect = this.funnelWindAroundStructure(windEffect, pos);
        return this.adjustForTunnelAttraction(windEffect, pos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Factory(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType parameters, ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new WindParticle(world, x, y, z, this.sprites, velocityX, velocityY, velocityZ);
        }
    }
}

