/*
 * Decompiled with CFR 0.152.
 */
package com.quintonc.vs_sails.config;

import dev.architectury.platform.Platform;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class ConfigUtils {
    public static Map<String, String> config = new HashMap<String, String>();

    public static Map<String, String> loadConfigs() {
        File file = new File(Platform.getConfigFolder().toString() + "/vs_sails/config.cfg");
        try {
            List lines = FileUtils.readLines((File)file, (String)"utf-8");
            lines.forEach(line -> {
                if (!(line = line.replaceAll("#.*", "")).isEmpty()) {
                    String noSpace = line.replace(" ", "");
                    String[] entry = noSpace.split("=");
                    config.put(entry[0], entry[1]);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return config;
    }

    public static void generateConfigs(List<String> input) {
        File file = new File(Platform.getConfigFolder().toString() + "/vs_sails/config.cfg");
        try {
            FileUtils.writeLines((File)file, input);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Map<String, String> checkConfigs() {
        if (new File(Platform.getConfigFolder().toString() + "/vs_sails/config.cfg").exists()) {
            if (360 % Integer.parseInt(config.getOrDefault("wheel-interval", "6")) != 0) {
                throw new RuntimeException("WHEEL INTERVAL MUST BE A FACTOR OF 360. It is: " + config.getOrDefault("wheel-interval", "6"));
            }
            return ConfigUtils.loadConfigs();
        }
        ConfigUtils.generateConfigs(ConfigUtils.makeDefaults());
        return ConfigUtils.loadConfigs();
    }

    private static List<String> makeDefaults() {
        ArrayList<String> defaults = new ArrayList<String>();
        defaults.add("#Valkyrien Sails Configuration\n");
        defaults.add("#World Options");
        defaults.add("enable-wind = true #[Default: true]");
        defaults.add("no-sail-zone = 90 #[Default: 90] Angular size in degrees of zone where sails lose most of their effectiveness");
        defaults.add("blow-vanilla-particles = false #[Default: false] Should the wind blow vanilla particles");
        defaults.add("\n#Sail Options");
        defaults.add("sail-power = 25000 #[Default: 25000]");
        defaults.add("forgiving-sails = false #[Default: false] Enable this if you want the wind direction to matter less to the sails");
        defaults.add("\n#Helm Options");
        defaults.add("rudder-power = 1.0 #[Default: 1.0]");
        defaults.add("realistic-rudder = true #[Default: true] Is the rudder turning force dependent on the ship's speed");
        defaults.add("keel-power = 4.0 #[Default: 4.0] How strongly ships resist drifting");
        defaults.add("wheel-interval = 6 #[Default: 6] How many degrees the wheel will turn per tick. MUST BE A FACTOR OF 360!!!");
        defaults.add("");
        defaults.add("magic-ballast-righting-force = 0.25 #[Default: 0.25]");
        defaults.add("");
        defaults.add("ballast-float-strength = 0.0 #[Default: 0.0]");
        defaults.add("buoy-float-strength = 0.125 #[Default: 0.125]");
        return defaults;
    }
}

